'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeInterpreter = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var initializeInterpreter = exports.initializeInterpreter = function () {
  var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee3(socket, typesRegistry, functionsRegistry) {
    var _this = this;

    var resolve, functionList, getInitializedFunctions, interpretAst, gotFunctionList, interval;
    return _regenerator2.default.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            resolve = void 0;
            functionList = new Promise(function (_resolve) {
              return resolve = _resolve;
            });

            getInitializedFunctions = function () {
              var _ref2 = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
                return _regenerator2.default.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        return _context.abrupt('return', functionList);

                      case 1:
                      case 'end':
                        return _context.stop();
                    }
                  }
                }, _callee, _this);
              }));

              return function getInitializedFunctions() {
                return _ref2.apply(this, arguments);
              };
            }();

            interpretAst = function () {
              var _ref3 = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee2(ast, context, handlers) {
                var serverFunctionList, interpretFn;
                return _regenerator2.default.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 2;
                        return functionList;

                      case 2:
                        serverFunctionList = _context2.sent;
                        _context2.next = 5;
                        return (0, _socket_interpret.socketInterpreterProvider)({
                          types: typesRegistry.toJS(),
                          handlers: (0, _extends3.default)({}, handlers, (0, _create_handlers.createHandlers)(socket)),
                          functions: functionsRegistry.toJS(),
                          referableFunctions: serverFunctionList,
                          socket: socket
                        });

                      case 5:
                        interpretFn = _context2.sent;
                        return _context2.abrupt('return', interpretFn(ast, context));

                      case 7:
                      case 'end':
                        return _context2.stop();
                    }
                  }
                }, _callee2, _this);
              }));

              return function interpretAst(_x4, _x5, _x6) {
                return _ref3.apply(this, arguments);
              };
            }();

            // Listen for interpreter runs


            socket.on('run', function (_ref4) {
              var ast = _ref4.ast,
                  context = _ref4.context,
                  id = _ref4.id;

              var types = typesRegistry.toJS();

              var _serializeProvider = (0, _serialize.serializeProvider)(types),
                  serialize = _serializeProvider.serialize,
                  deserialize = _serializeProvider.deserialize;

              interpretAst(ast, deserialize(context)).then(function (value) {
                socket.emit('resp:' + id, { value: serialize(value) });
              });
            });

            // Create the function list
            gotFunctionList = false;

            socket.once('functionList', function (fl) {
              gotFunctionList = true;
              resolve(fl);
            });

            interval = setInterval(function () {
              if (gotFunctionList) {
                clearInterval(interval);
                return;
              }
              socket.emit('getFunctionList');
            }, 1000);
            return _context3.abrupt('return', { getInitializedFunctions: getInitializedFunctions, interpretAst: interpretAst });

          case 9:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, this);
  }));

  return function initializeInterpreter(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}(); /*
      * Licensed to Elasticsearch B.V. under one or more contributor
      * license agreements. See the NOTICE file distributed with
      * this work for additional information regarding copyright
      * ownership. Elasticsearch B.V. licenses this file to you under
      * the Apache License, Version 2.0 (the "License"); you may
      * not use this file except in compliance with the License.
      * You may obtain a copy of the License at
      *
      *    http://www.apache.org/licenses/LICENSE-2.0
      *
      * Unless required by applicable law or agreed to in writing,
      * software distributed under the License is distributed on an
      * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
      * KIND, either express or implied.  See the License for the
      * specific language governing permissions and limitations
      * under the License.
      */

var _socket_interpret = require('../common/interpreter/socket_interpret');

var _serialize = require('../common/lib/serialize');

var _create_handlers = require('./create_handlers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }