/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.google.gson.Gson;
import com.microsoft.azure.eventprocessorhost.AzureBlobLease;
import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LeaseLostException;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.LeaseState;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureStorageCheckpointLeaseManager
implements ICheckpointManager,
ILeaseManager {
    private HostContext hostContext;
    private final String storageConnectionString;
    private String storageContainerName;
    private final String storageBlobPrefix;
    private CloudBlobClient storageClient;
    private CloudBlobContainer eventHubContainer;
    private CloudBlobDirectory consumerGroupDirectory;
    private ArrayList<String> partitionIds = null;
    private Gson gson;
    private final BlobRequestOptions leaseOperationOptions = new BlobRequestOptions();
    private final BlobRequestOptions checkpointOperationOptions = new BlobRequestOptions();
    private final BlobRequestOptions renewRequestOptions = new BlobRequestOptions();
    private Hashtable<String, Checkpoint> latestCheckpoint = new Hashtable();
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(AzureStorageCheckpointLeaseManager.class);

    AzureStorageCheckpointLeaseManager(String storageConnectionString) {
        this(storageConnectionString, null);
    }

    AzureStorageCheckpointLeaseManager(String storageConnectionString, String storageContainerName) {
        this(storageConnectionString, storageContainerName, "");
    }

    AzureStorageCheckpointLeaseManager(String storageConnectionString, String storageContainerName, String storageBlobPrefix) {
        if (storageConnectionString == null || storageConnectionString.trim().isEmpty()) {
            throw new IllegalArgumentException("Provide valid Azure Storage connection string when using Azure Storage");
        }
        this.storageConnectionString = storageConnectionString;
        if (storageContainerName != null && storageContainerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Azure Storage container name must be a valid container name or null to use the default");
        }
        this.storageContainerName = storageContainerName;
        this.storageBlobPrefix = storageBlobPrefix != null ? storageBlobPrefix.trim() : "";
    }

    void initialize(HostContext hostContext) throws InvalidKeyException, URISyntaxException, StorageException {
        Pattern p;
        Matcher m;
        this.hostContext = hostContext;
        if (this.storageContainerName == null) {
            this.storageContainerName = this.hostContext.getEventHubPath();
        }
        if (!(m = (p = Pattern.compile("^(?-i)(?:[a-z0-9]|(?<=[0-9a-z])-(?=[0-9a-z])){3,63}$")).matcher(this.storageContainerName)).find()) {
            throw new IllegalArgumentException("EventHub names must conform to the following rules to be able to use it with EventProcessorHost: Must start with a letter or number, and can contain only letters, numbers, and the dash (-) character. Every dash (-) character must be immediately preceded and followed by a letter or number; consecutive dashes are not permitted in container names. All letters in a container name must be lowercase. Must be from 3 to 63 characters long.");
        }
        this.storageClient = CloudStorageAccount.parse((String)this.storageConnectionString).createCloudBlobClient();
        this.eventHubContainer = this.storageClient.getContainerReference(this.storageContainerName);
        this.consumerGroupDirectory = this.eventHubContainer.getDirectoryReference(this.storageBlobPrefix + this.hostContext.getConsumerGroupName());
        this.gson = new Gson();
        this.leaseOperationOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds() * 1000));
        this.storageClient.setDefaultRequestOptions(this.leaseOperationOptions);
        this.checkpointOperationOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getCheckpointTimeoutInSeconds() * 1000));
        this.renewRequestOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds() * 1000));
    }

    @Override
    public CompletableFuture<Boolean> checkpointStoreExists() {
        return this.leaseStoreExistsInternal(this.checkpointOperationOptions, "Checking Checpoint Store Existence").whenCompleteAsync((result, e) -> {
            if (e != null) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure while checking checkpoint store existence"), LoggingUtils.unwrapException(e, null));
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> createCheckpointStoreIfNotExists() {
        return this.createLeaseStoreIfNotExistsInternal(this.checkpointOperationOptions, "Creating Checkpoint Store").whenCompleteAsync((result, e) -> {
            if (e != null) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure while creating checkpoint store"), LoggingUtils.unwrapException(e, null));
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> deleteCheckpointStore() {
        return this.deleteLeaseStoreInternal(this.checkpointOperationOptions);
    }

    @Override
    public CompletableFuture<Checkpoint> getCheckpoint(String partitionId) {
        return CompletableFuture.supplyAsync(() -> {
            AzureBlobLease lease = null;
            try {
                lease = this.getLeaseInternal(partitionId, this.checkpointOperationOptions);
            }
            catch (StorageException | IOException | URISyntaxException e) {
                throw LoggingUtils.wrapException(e, "Getting Checkpoint Details");
            }
            Checkpoint checkpoint = null;
            if (lease != null && lease.getOffset() != null) {
                checkpoint = new Checkpoint(partitionId);
                checkpoint.setOffset(lease.getOffset());
                checkpoint.setSequenceNumber(lease.getSequenceNumber());
            }
            return checkpoint;
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Checkpoint> createCheckpointIfNotExists(String partitionId) {
        return CompletableFuture.supplyAsync(() -> {
            AzureBlobLease lease = null;
            try {
                lease = this.createLeaseIfNotExistsInternal(partitionId, this.checkpointOperationOptions);
            }
            catch (StorageException | IOException | URISyntaxException e) {
                TRACE_LOGGER.error(this.hostContext.withHostAndPartition(partitionId, "CreateCheckpointIfNotExist exception - leaseContainerName: " + this.storageContainerName + " consumerGroupName: " + this.hostContext.getConsumerGroupName() + "storageBlobPrefix: " + this.storageBlobPrefix), e);
                throw LoggingUtils.wrapException(e, "Creating Checkpoint");
            }
            Checkpoint checkpoint = null;
            if (lease.getOffset() != null) {
                checkpoint = new Checkpoint(partitionId, lease.getOffset(), lease.getSequenceNumber());
            }
            return checkpoint;
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> updateCheckpoint(Lease lease, Checkpoint checkpoint) {
        AzureBlobLease updatedLease = new AzureBlobLease((AzureBlobLease)lease);
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "Checkpointing at " + checkpoint.getOffset() + " // " + checkpoint.getSequenceNumber()));
        updatedLease.setOffset(checkpoint.getOffset());
        updatedLease.setSequenceNumber(checkpoint.getSequenceNumber());
        return this.updateLeaseInternal(updatedLease, this.checkpointOperationOptions, "Updating Checkpoint").thenAcceptAsync(result -> {
            if (!result.booleanValue()) {
                throw LoggingUtils.wrapException(new LeaseLostException(lease, "Lease lost"), "Updating Checkpoint");
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> deleteCheckpoint(String partitionId) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getLeaseRenewIntervalInMilliseconds() {
        return this.hostContext.getPartitionManagerOptions().getLeaseRenewIntervalInSeconds() * 1000;
    }

    @Override
    public int getLeaseDurationInMilliseconds() {
        return this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds() * 1000;
    }

    @Override
    public CompletableFuture<Boolean> leaseStoreExists() {
        return this.leaseStoreExistsInternal(this.leaseOperationOptions, "Checking Lease Store Existence").whenCompleteAsync((result, e) -> {
            if (e != null) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure while checking lease store existence"), LoggingUtils.unwrapException(e, null));
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    private CompletableFuture<Boolean> leaseStoreExistsInternal(BlobRequestOptions options, String action) {
        return CompletableFuture.supplyAsync(() -> {
            boolean result = false;
            try {
                result = this.eventHubContainer.exists(null, options, null);
            }
            catch (StorageException e) {
                throw LoggingUtils.wrapException(e, action);
            }
            return result;
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> createLeaseStoreIfNotExists() {
        return this.createLeaseStoreIfNotExistsInternal(this.leaseOperationOptions, "Creating Lease Store").whenCompleteAsync((result, e) -> {
            if (e != null) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure while creating lease store"), LoggingUtils.unwrapException(e, null));
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    private CompletableFuture<Void> createLeaseStoreIfNotExistsInternal(BlobRequestOptions options, String action) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.eventHubContainer.createIfNotExists(options, null);
                TRACE_LOGGER.info(this.hostContext.withHost("Created lease store OK or it already existed"));
            }
            catch (StorageException e) {
                throw LoggingUtils.wrapException(e, action);
            }
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> deleteLeaseStore() {
        return this.deleteLeaseStoreInternal(this.leaseOperationOptions);
    }

    private CompletableFuture<Void> deleteLeaseStoreInternal(BlobRequestOptions options) {
        return CompletableFuture.runAsync(() -> {
            for (ListBlobItem blob : this.eventHubContainer.listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), options, null)) {
                if (blob instanceof CloudBlobDirectory) {
                    try {
                        for (ListBlobItem subBlob : ((CloudBlobDirectory)blob).listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), options, null)) {
                            ((CloudBlockBlob)subBlob).deleteIfExists(DeleteSnapshotsOption.NONE, null, options, null);
                        }
                        continue;
                    }
                    catch (StorageException | URISyntaxException e) {
                        TRACE_LOGGER.error(this.hostContext.withHost("Failure while deleting lease store"), e);
                        throw new CompletionException(e);
                    }
                }
                if (!(blob instanceof CloudBlockBlob)) continue;
                try {
                    ((CloudBlockBlob)blob).deleteIfExists(DeleteSnapshotsOption.NONE, null, options, null);
                }
                catch (StorageException e) {
                    TRACE_LOGGER.error(this.hostContext.withHost("Failure while deleting lease store"), (Throwable)e);
                    throw new CompletionException(e);
                }
            }
            try {
                this.eventHubContainer.deleteIfExists(null, options, null);
            }
            catch (StorageException e) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure while deleting lease store"), (Throwable)e);
                throw new CompletionException(e);
            }
        }, this.hostContext.getExecutor());
    }

    private CompletableFuture<Lease> getLease(String partitionId) {
        return CompletableFuture.supplyAsync(() -> {
            AzureBlobLease result = null;
            try {
                result = this.getLeaseInternal(partitionId, this.leaseOperationOptions);
            }
            catch (StorageException | IOException | URISyntaxException e) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(partitionId, "Failure while getting lease details"), e);
                throw LoggingUtils.wrapException(e, "Getting Lease Details");
            }
            return result;
        }, this.hostContext.getExecutor());
    }

    private AzureBlobLease getLeaseInternal(String partitionId, BlobRequestOptions options) throws URISyntaxException, IOException, StorageException {
        AzureBlobLease retval = null;
        CloudBlockBlob leaseBlob = this.consumerGroupDirectory.getBlockBlobReference(partitionId);
        if (leaseBlob.exists(null, options, null)) {
            retval = this.downloadLease(leaseBlob, options);
        }
        return retval;
    }

    @Override
    public CompletableFuture<List<Lease>> getAllLeases() {
        CompletionStage intermediateFuture = this.cachePartitionIds().thenApplyAsync(empty -> {
            ArrayList<CompletableFuture<Lease>> leaseFutures = new ArrayList<CompletableFuture<Lease>>();
            for (String id : this.partitionIds) {
                leaseFutures.add(this.getLease(id));
            }
            return leaseFutures;
        }, (Executor)this.hostContext.getExecutor());
        return ((CompletableFuture)((CompletableFuture)intermediateFuture).thenComposeAsync(leaseFutures -> {
            CompletableFuture[] blah = new CompletableFuture[leaseFutures.size()];
            return CompletableFuture.allOf(leaseFutures.toArray(blah));
        }, (Executor)this.hostContext.getExecutor())).thenCombineAsync(intermediateFuture, (empty, leaseFutures) -> {
            ArrayList leaseList = new ArrayList();
            leaseFutures.forEach(lf -> {
                try {
                    leaseList.add(lf.get());
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            });
            return leaseList;
        }, (Executor)this.hostContext.getExecutor());
    }

    private CompletableFuture<Void> cachePartitionIds() {
        CompletableFuture<Object> result = null;
        result = this.partitionIds != null ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> {
            try {
                Iterable blobList = this.consumerGroupDirectory.listBlobs("", true, null, this.leaseOperationOptions, null);
                this.partitionIds = new ArrayList();
                blobList.forEach(lbi -> {
                    Path p = Paths.get(lbi.getUri().getPath(), new String[0]);
                    this.partitionIds.add(p.getFileName().toString());
                });
            }
            catch (StorageException | URISyntaxException e) {
                throw new CompletionException(e);
            }
        }, this.hostContext.getExecutor());
        return result;
    }

    @Override
    public CompletableFuture<Lease> createLeaseIfNotExists(String partitionId) {
        return CompletableFuture.supplyAsync(() -> {
            AzureBlobLease returnLease = null;
            try {
                returnLease = this.createLeaseIfNotExistsInternal(partitionId, this.leaseOperationOptions);
            }
            catch (StorageException | IOException | URISyntaxException e) {
                TRACE_LOGGER.error(this.hostContext.withHostAndPartition(partitionId, "CreateLeaseIfNotExist exception - leaseContainerName: " + this.storageContainerName + " consumerGroupName: " + this.hostContext.getConsumerGroupName() + " storageBlobPrefix: " + this.storageBlobPrefix), e);
                throw LoggingUtils.wrapException(e, "Creating Lease");
            }
            return returnLease;
        }, this.hostContext.getExecutor());
    }

    private AzureBlobLease createLeaseIfNotExistsInternal(String partitionId, BlobRequestOptions options) throws URISyntaxException, IOException, StorageException {
        AzureBlobLease returnLease = null;
        try {
            CloudBlockBlob leaseBlob = this.consumerGroupDirectory.getBlockBlobReference(partitionId);
            returnLease = new AzureBlobLease(partitionId, leaseBlob, this.leaseOperationOptions);
            this.uploadLease(returnLease, leaseBlob, AccessCondition.generateIfNoneMatchCondition((String)"*"), UploadActivity.Create, options);
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(partitionId, "CreateLeaseIfNotExist OK - leaseContainerName: " + this.storageContainerName + " consumerGroupName: " + this.hostContext.getConsumerGroupName() + " storageBlobPrefix: " + this.storageBlobPrefix));
        }
        catch (StorageException se) {
            StorageExtendedErrorInformation extendedErrorInfo = se.getExtendedErrorInformation();
            if (extendedErrorInfo != null && (extendedErrorInfo.getErrorCode().compareTo("BlobAlreadyExists") == 0 || extendedErrorInfo.getErrorCode().compareTo("LeaseIdMissing") == 0)) {
                TRACE_LOGGER.info(this.hostContext.withHostAndPartition(partitionId, "Lease already exists"));
                returnLease = this.getLeaseInternal(partitionId, options);
            }
            throw se;
        }
        return returnLease;
    }

    @Override
    public CompletableFuture<Void> deleteLease(Lease lease) {
        return CompletableFuture.runAsync(() -> {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(lease, "Deleting lease"));
            try {
                ((AzureBlobLease)lease).getBlob().deleteIfExists();
            }
            catch (StorageException e) {
                TRACE_LOGGER.error(this.hostContext.withHostAndPartition(lease, "Exception deleting lease"), (Throwable)e);
                throw LoggingUtils.wrapException(e, "Deleting Lease");
            }
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Boolean> acquireLease(Lease lease) {
        return CompletableFuture.supplyAsync(() -> {
            boolean result = false;
            try {
                result = this.acquireLeaseInternal((AzureBlobLease)lease);
            }
            catch (StorageException | IOException e) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(lease, "Failure acquiring lease"), e);
                throw LoggingUtils.wrapException(e, "Acquiring Lease");
            }
            return result;
        }, this.hostContext.getExecutor());
    }

    private boolean acquireLeaseInternal(AzureBlobLease lease) throws IOException, StorageException {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Acquiring lease"));
        CloudBlockBlob leaseBlob = lease.getBlob();
        boolean succeeded = true;
        String newLeaseId = EventProcessorHost.safeCreateUUID();
        if (newLeaseId == null || newLeaseId.isEmpty()) {
            throw new IllegalArgumentException("acquireLeaseSync: newLeaseId really is " + (newLeaseId == null ? "null" : "empty"));
        }
        try {
            String newToken = null;
            leaseBlob.downloadAttributes();
            if (leaseBlob.getProperties().getLeaseState() == LeaseState.LEASED) {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "changeLease"));
                if (lease.getToken() == null || lease.getToken().isEmpty()) {
                    succeeded = false;
                } else {
                    newToken = leaseBlob.changeLease(newLeaseId, AccessCondition.generateLeaseCondition((String)lease.getToken()));
                }
            } else {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "acquireLease"));
                newToken = leaseBlob.acquireLease(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds()), newLeaseId);
            }
            if (succeeded) {
                lease.setToken(newToken);
                lease.setOwner(this.hostContext.getHostName());
                lease.incrementEpoch();
                this.uploadLease(lease, leaseBlob, AccessCondition.generateLeaseCondition((String)lease.getToken()), UploadActivity.Acquire, this.leaseOperationOptions);
            }
        }
        catch (StorageException se) {
            if (this.wasLeaseLost(se, lease.getPartitionId())) {
                succeeded = false;
            }
            throw se;
        }
        return succeeded;
    }

    @Override
    public CompletableFuture<Boolean> renewLease(Lease lease) {
        return CompletableFuture.supplyAsync(() -> {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Renewing lease"));
            CloudBlockBlob leaseBlob = ((AzureBlobLease)lease).getBlob();
            boolean retval = true;
            try {
                leaseBlob.renewLease(AccessCondition.generateLeaseCondition((String)lease.getToken()), this.renewRequestOptions, null);
            }
            catch (StorageException se) {
                if (this.wasLeaseLost(se, lease.getPartitionId())) {
                    retval = false;
                }
                throw LoggingUtils.wrapException(se, "Renewing Lease");
            }
            return retval;
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Void> releaseLease(Lease lease) {
        return CompletableFuture.runAsync(() -> {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Releasing lease"));
            AzureBlobLease inLease = (AzureBlobLease)lease;
            CloudBlockBlob leaseBlob = inLease.getBlob();
            try {
                String leaseId = lease.getToken();
                AzureBlobLease releasedCopy = new AzureBlobLease(inLease);
                releasedCopy.setToken("");
                releasedCopy.setOwner("");
                this.uploadLease(releasedCopy, leaseBlob, AccessCondition.generateLeaseCondition((String)leaseId), UploadActivity.Release, this.leaseOperationOptions);
                leaseBlob.releaseLease(AccessCondition.generateLeaseCondition((String)leaseId));
            }
            catch (StorageException se) {
                if (!this.wasLeaseLost(se, lease.getPartitionId())) {
                    throw LoggingUtils.wrapException(se, "Releasing Lease");
                }
            }
            catch (IOException ie) {
                throw LoggingUtils.wrapException(ie, "Releasing Lease");
            }
        }, this.hostContext.getExecutor());
    }

    @Override
    public CompletableFuture<Boolean> updateLease(Lease lease) {
        return this.updateLeaseInternal((AzureBlobLease)lease, this.leaseOperationOptions, "Updating Lease").whenCompleteAsync((result, e) -> {
            if (e != null) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(lease, "Failure updating lease"), LoggingUtils.unwrapException(e, null));
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    public CompletableFuture<Boolean> updateLeaseInternal(AzureBlobLease lease, BlobRequestOptions options, String action) {
        if (lease == null) {
            return CompletableFuture.completedFuture(false);
        }
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Updating lease"));
        String token = lease.getToken();
        if (token == null || token.length() == 0) {
            return CompletableFuture.completedFuture(false);
        }
        return this.renewLease(lease).thenApplyAsync(result -> {
            CloudBlockBlob leaseBlob = lease.getBlob();
            try {
                this.uploadLease(lease, leaseBlob, AccessCondition.generateLeaseCondition((String)token), UploadActivity.Update, options);
            }
            catch (StorageException se) {
                if (this.wasLeaseLost(se, lease.getPartitionId())) {
                    return false;
                }
                throw LoggingUtils.wrapException(se, action);
            }
            catch (IOException ie) {
                throw LoggingUtils.wrapException(ie, action);
            }
            return true;
        }, (Executor)this.hostContext.getExecutor());
    }

    private AzureBlobLease downloadLease(CloudBlockBlob blob, BlobRequestOptions options) throws StorageException, IOException {
        String jsonLease = blob.downloadText(null, null, options, null);
        TRACE_LOGGER.debug(this.hostContext.withHost("Raw JSON downloaded: " + jsonLease));
        AzureBlobLease rehydrated = (AzureBlobLease)this.gson.fromJson(jsonLease, AzureBlobLease.class);
        AzureBlobLease blobLease = new AzureBlobLease(rehydrated, blob, this.leaseOperationOptions);
        if (blobLease.getOffset() != null) {
            this.latestCheckpoint.put(blobLease.getPartitionId(), blobLease.getCheckpoint());
        }
        return blobLease;
    }

    private void uploadLease(AzureBlobLease lease, CloudBlockBlob blob, AccessCondition condition, UploadActivity activity, BlobRequestOptions options) throws StorageException, IOException {
        if (activity != UploadActivity.Create) {
            Checkpoint cached = this.latestCheckpoint.get(lease.getPartitionId());
            if (cached != null && (cached.getSequenceNumber() > lease.getSequenceNumber() || lease.getOffset() == null)) {
                lease.setOffset(cached.getOffset());
                lease.setSequenceNumber(cached.getSequenceNumber());
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Replacing stale offset/seqno while uploading lease"));
            } else if (lease.getOffset() != null) {
                this.latestCheckpoint.put(lease.getPartitionId(), lease.getCheckpoint());
            }
        }
        String jsonLease = this.gson.toJson((Object)lease);
        blob.uploadText(jsonLease, null, condition, options, null);
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Raw JSON uploading for " + (Object)((Object)activity) + ": " + jsonLease));
    }

    private boolean wasLeaseLost(StorageException se, String partitionId) {
        StorageExtendedErrorInformation extendedErrorInfo;
        boolean retval = false;
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "WAS LEASE LOST? Http " + se.getHttpStatusCode()));
        if (se.getExtendedErrorInformation() != null) {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "Http " + se.getExtendedErrorInformation().getErrorCode() + " :: " + se.getExtendedErrorInformation().getErrorMessage()));
        }
        if ((se.getHttpStatusCode() == 409 || se.getHttpStatusCode() == 412) && (extendedErrorInfo = se.getExtendedErrorInformation()) != null) {
            String errorCode = extendedErrorInfo.getErrorCode();
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "Error code: " + errorCode));
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "Error message: " + extendedErrorInfo.getErrorMessage()));
            if (errorCode.compareTo("LeaseLost") == 0 || errorCode.compareTo("LeaseIdMismatchWithLeaseOperation") == 0 || errorCode.compareTo("LeaseIdMismatchWithBlobOperation") == 0 || errorCode.compareTo("LeaseAlreadyPresent") == 0) {
                retval = true;
            }
        }
        return retval;
    }

    private static enum UploadActivity {
        Create,
        Acquire,
        Release,
        Update;

    }
}

