/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.IllegalEntityException;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.TimeoutException;
import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.eventprocessorhost.Pump;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionManager {
    protected final HostContext hostContext;
    protected Pump pump = null;
    protected volatile String[] partitionIds = null;
    private final Object scanFutureSynchronizer = new Object();
    private ScheduledFuture<?> scanFuture = null;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(PartitionManager.class);

    PartitionManager(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    CompletableFuture<Void> cachePartitionIds() {
        CompletionStage<Object> retval = null;
        if (this.partitionIds != null) {
            retval = CompletableFuture.completedFuture(null);
        } else {
            try {
                retval = ((CompletableFuture)((CompletableFuture)EventHubClient.create((String)this.hostContext.getEventHubConnectionString(), (RetryPolicy)this.hostContext.getRetryPolicy(), (Executor)this.hostContext.getExecutor()).thenComposeAsync(ehClient -> ehClient.getRuntimeInformation(), (Executor)this.hostContext.getExecutor())).thenAcceptAsync(ehInfo -> {
                    if (ehInfo != null) {
                        this.partitionIds = ehInfo.getPartitionIds();
                        TRACE_LOGGER.info(this.hostContext.withHost("Eventhub " + this.hostContext.getEventHubPath() + " count of partitions: " + ehInfo.getPartitionCount()));
                        for (String id : this.partitionIds) {
                            TRACE_LOGGER.info(this.hostContext.withHost("Found partition with id: " + id));
                        }
                    } else {
                        throw new CompletionException((Throwable)new TimeoutException("getRuntimeInformation returned null"));
                    }
                }, (Executor)this.hostContext.getExecutor())).whenCompleteAsync((empty, e) -> {
                    if (e != null) {
                        Throwable notifyWith = e;
                        if (e instanceof CompletionException) {
                            notifyWith = e.getCause();
                        }
                        throw new CompletionException((Throwable)new IllegalEntityException("Failure getting partition ids for event hub", notifyWith));
                    }
                }, (Executor)this.hostContext.getExecutor());
            }
            catch (EventHubException | IOException e2) {
                retval = new CompletableFuture();
                retval.completeExceptionally((Throwable)new IllegalEntityException("Failure getting partition ids for event hub", e2));
            }
        }
        return retval;
    }

    Pump createPumpTestHook() {
        return new Pump(this.hostContext);
    }

    void onInitializeCompleteTestHook() {
    }

    void onPartitionCheckCompleteTestHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> stopPartitions() {
        Object object = this.scanFutureSynchronizer;
        synchronized (object) {
            if (this.scanFuture != null) {
                this.scanFuture.cancel(true);
            }
        }
        CompletionStage<Object> retval = CompletableFuture.completedFuture(null);
        if (this.pump != null) {
            TRACE_LOGGER.info(this.hostContext.withHost("Shutting down all pumps"));
            CompletableFuture<?>[] pumpRemovals = this.pump.removeAllPumps(CloseReason.Shutdown);
            retval = CompletableFuture.allOf(pumpRemovals).whenCompleteAsync((empty, e) -> {
                if (e != null) {
                    Throwable notifyWith = LoggingUtils.unwrapException(e, null);
                    TRACE_LOGGER.warn(this.hostContext.withHost("Failure during shutdown"), notifyWith);
                    if (notifyWith instanceof Exception) {
                        this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), (Exception)notifyWith, "Partition Manager Cleanup");
                    }
                }
                TRACE_LOGGER.info(this.hostContext.withHost("Partition manager exiting"));
            }, (Executor)this.hostContext.getExecutor());
        }
        return retval;
    }

    public CompletableFuture<Void> initialize() {
        this.pump = this.createPumpTestHook();
        return ((CompletableFuture)((CompletableFuture)this.cachePartitionIds().thenComposeAsync(unused -> this.initializeStores(), (Executor)this.hostContext.getExecutor())).whenCompleteAsync((empty, e) -> {
            if (e != null) {
                StringBuilder outAction = new StringBuilder();
                Throwable notifyWith = LoggingUtils.unwrapException(e, outAction);
                if (outAction.length() > 0) {
                    TRACE_LOGGER.error(this.hostContext.withHost("Exception while initializing stores (" + outAction.toString() + "), not starting partition manager"), notifyWith);
                } else {
                    TRACE_LOGGER.error(this.hostContext.withHost("Exception while initializing stores, not starting partition manager"), notifyWith);
                }
            }
        }, (Executor)this.hostContext.getExecutor())).thenRunAsync(() -> {
            Object object = this.scanFutureSynchronizer;
            synchronized (object) {
                this.scanFuture = this.hostContext.getExecutor().schedule(() -> this.scan(), 0L, TimeUnit.SECONDS);
            }
            this.onInitializeCompleteTestHook();
        }, this.hostContext.getExecutor());
    }

    private CompletableFuture<?> initializeStores() {
        ILeaseManager leaseManager = this.hostContext.getLeaseManager();
        ICheckpointManager checkpointManager = this.hostContext.getCheckpointManager();
        CompletableFuture<?> initializeStoresFuture = this.buildRetries(CompletableFuture.completedFuture(null), () -> leaseManager.createLeaseStoreIfNotExists(), null, "Failure creating lease store for this Event Hub, retrying", "Out of retries creating lease store for this Event Hub", "Creating Lease Store", 5);
        initializeStoresFuture = this.buildRetries(initializeStoresFuture, () -> checkpointManager.createCheckpointStoreIfNotExists(), null, "Failure creating checkpoint store for this Event Hub, retrying", "Out of retries creating checkpoint store for this Event Hub", "Creating Checkpoint Store", 5);
        String[] stringArray = this.partitionIds;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String id;
            String iterationId = id = stringArray[i];
            initializeStoresFuture = this.buildRetries(initializeStoresFuture, () -> leaseManager.createLeaseIfNotExists(iterationId), iterationId, "Failure creating lease for partition, retrying", "Out of retries creating lease for partition", "Creating Lease", 5);
            initializeStoresFuture = this.buildRetries(initializeStoresFuture, () -> checkpointManager.createCheckpointIfNotExists(iterationId), iterationId, "Failure creating checkpoint for partition, retrying", "Out of retries creating checkpoint blob for partition", "Creating Checkpoint", 5);
        }
        initializeStoresFuture.whenCompleteAsync((r, e) -> {
            if (e != null && e instanceof FinalException) {
                throw ((FinalException)e).getInner();
            }
        }, (Executor)this.hostContext.getExecutor());
        return initializeStoresFuture;
    }

    private CompletableFuture<?> buildRetries(CompletableFuture<?> buildOnto, Callable<CompletableFuture<?>> lambda, String partitionId, String retryMessage, String finalFailureMessage, String action, int maxRetries) {
        CompletionStage retryChain = buildOnto.thenComposeAsync(unused -> {
            CompletableFuture newresult = CompletableFuture.completedFuture(null);
            try {
                newresult = (CompletableFuture)lambda.call();
            }
            catch (Exception e1) {
                throw new CompletionException(e1);
            }
            return newresult;
        }, (Executor)this.hostContext.getExecutor());
        for (int i = 1; i < maxRetries; ++i) {
            retryChain = ((CompletableFuture)((CompletableFuture)retryChain).handleAsync((r, e) -> {
                Object effectiveResult = r;
                if (e != null) {
                    if (e instanceof FinalException) {
                        throw (FinalException)e;
                    }
                    if (partitionId != null) {
                        TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(partitionId, retryMessage), LoggingUtils.unwrapException(e, null));
                    } else {
                        TRACE_LOGGER.warn(this.hostContext.withHost(retryMessage), LoggingUtils.unwrapException(e, null));
                    }
                } else if (r == null) {
                    effectiveResult = true;
                }
                return e == null ? effectiveResult : null;
            }, (Executor)this.hostContext.getExecutor())).thenComposeAsync(oldresult -> {
                CompletableFuture newresult = CompletableFuture.completedFuture(oldresult);
                if (oldresult == null) {
                    try {
                        newresult = (CompletableFuture)lambda.call();
                    }
                    catch (Exception e1) {
                        throw new CompletionException(e1);
                    }
                }
                return newresult;
            }, (Executor)this.hostContext.getExecutor());
        }
        retryChain = ((CompletableFuture)retryChain).handleAsync((r, e) -> {
            if (e != null) {
                if (e instanceof FinalException) {
                    throw (FinalException)e;
                }
                if (partitionId != null) {
                    TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(partitionId, finalFailureMessage));
                } else {
                    TRACE_LOGGER.warn(this.hostContext.withHost(finalFailureMessage));
                }
                throw new FinalException(LoggingUtils.wrapExceptionWithMessage(LoggingUtils.unwrapException(e, null), finalFailureMessage, action));
            }
            return e == null ? r : null;
        }, (Executor)this.hostContext.getExecutor());
        return retryChain;
    }

    private Void scan() {
        TRACE_LOGGER.debug(this.hostContext.withHost("Starting lease scan"));
        AtomicInteger ourLeasesCount = new AtomicInteger();
        ConcurrentHashMap leasesOwnedByOthers = new ConcurrentHashMap();
        BoolWrapper resultsAreComplete = new BoolWrapper(true);
        CompletionStage leaseToStealFuture = ((CompletableFuture)((CompletableFuture)this.hostContext.getLeaseManager().getAllLeases().thenApplyAsync(leaseList -> {
            ArrayList<CompletionStage> transformedLeases = new ArrayList<CompletionStage>();
            for (Lease l : leaseList) {
                Lease workingLease = l;
                if (workingLease != null) {
                    CompletionStage oneResult = ((CompletableFuture)((CompletableFuture)workingLease.isExpired().thenComposeAsync(expired -> expired != false ? this.hostContext.getLeaseManager().acquireLease(workingLease) : CompletableFuture.completedFuture(false), (Executor)this.hostContext.getExecutor())).thenApplyAsync(acquired -> {
                        if (acquired.booleanValue()) {
                            this.pump.addPump(workingLease);
                        }
                        if (workingLease.isOwnedBy(this.hostContext.getHostName())) {
                            ourLeasesCount.getAndIncrement();
                        } else {
                            leasesOwnedByOthers.put(workingLease.getPartitionId(), workingLease);
                        }
                        return workingLease;
                    }, (Executor)this.hostContext.getExecutor())).whenCompleteAsync((lease, e) -> {
                        if (e != null) {
                            resultsAreComplete.value = false;
                            Exception notifyWith = (Exception)LoggingUtils.unwrapException(e, null);
                            TRACE_LOGGER.warn(this.hostContext.withHost("Failure getting/acquiring lease, skipping"), (Throwable)notifyWith);
                            this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), notifyWith, "Checking Leases", "N/A");
                        }
                    }, (Executor)this.hostContext.getExecutor());
                    transformedLeases.add(oneResult);
                    continue;
                }
                TRACE_LOGGER.warn(this.hostContext.withHost("null lease during scan"));
            }
            return transformedLeases;
        }, (Executor)this.hostContext.getExecutor())).thenComposeAsync(transformedLeases -> {
            CompletableFuture<Object> result = null;
            if (transformedLeases.size() > 0) {
                CompletableFuture[] dummy = new CompletableFuture[transformedLeases.size()];
                result = CompletableFuture.allOf(transformedLeases.toArray(dummy));
            } else {
                TRACE_LOGGER.warn(this.hostContext.withHost("all leases were null during scan"));
                result = CompletableFuture.completedFuture(null);
            }
            return result;
        }, (Executor)this.hostContext.getExecutor())).thenApplyAsync(empty -> {
            TRACE_LOGGER.debug(this.hostContext.withHost("Lease scan steal check"));
            Lease stealThisLease = null;
            if (leasesOwnedByOthers.size() > 0 && resultsAreComplete.value) {
                stealThisLease = this.whichLeaseToSteal(leasesOwnedByOthers.values(), ourLeasesCount.get());
            }
            return stealThisLease;
        }, (Executor)this.hostContext.getExecutor());
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)leaseToStealFuture).thenComposeAsync(stealThisLease -> stealThisLease != null ? this.hostContext.getLeaseManager().acquireLease((Lease)stealThisLease) : CompletableFuture.completedFuture(false), (Executor)this.hostContext.getExecutor())).thenCombineAsync(leaseToStealFuture, (stealSucceeded, lease) -> {
            if (stealSucceeded.booleanValue()) {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition((Lease)lease, "Stole lease"));
                this.pump.addPump((Lease)lease);
            }
            return lease;
        }, (Executor)this.hostContext.getExecutor())).whenCompleteAsync((lease, e) -> {
            if (e != null) {
                Exception notifyWith = (Exception)LoggingUtils.unwrapException(e, null);
                if (lease != null) {
                    TRACE_LOGGER.warn(this.hostContext.withHost("Exception stealing lease for partition " + lease.getPartitionId()), (Throwable)notifyWith);
                    this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), notifyWith, "Stealing Lease", lease.getPartitionId());
                } else {
                    TRACE_LOGGER.warn(this.hostContext.withHost("Exception stealing lease"), (Throwable)notifyWith);
                    this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), notifyWith, "Stealing Lease", "N/A");
                }
            }
            this.onPartitionCheckCompleteTestHook();
            Object object = this.scanFutureSynchronizer;
            synchronized (object) {
                if (!this.scanFuture.isCancelled()) {
                    int seconds = this.hostContext.getPartitionManagerOptions().getLeaseRenewIntervalInSeconds();
                    this.scanFuture = this.hostContext.getExecutor().schedule(() -> this.scan(), (long)seconds, TimeUnit.SECONDS);
                    TRACE_LOGGER.debug(this.hostContext.withHost("Scheduling lease scanner in " + seconds));
                }
            }
        }, (Executor)this.hostContext.getExecutor());
        return null;
    }

    private Lease whichLeaseToSteal(Collection<Lease> stealableLeases, int haveLeaseCount) {
        HashMap<String, Integer> countsByOwner = this.countLeasesByOwner(stealableLeases);
        String biggestOwner = this.findBiggestOwner(countsByOwner);
        int biggestCount = countsByOwner.get(biggestOwner);
        Lease stealThisLease = null;
        if (biggestCount - haveLeaseCount >= 2) {
            for (Lease l : stealableLeases) {
                if (!l.isOwnedBy(biggestOwner)) continue;
                stealThisLease = l;
                TRACE_LOGGER.debug(this.hostContext.withHost("Proposed to steal lease for partition " + l.getPartitionId() + " from " + biggestOwner));
                break;
            }
        }
        return stealThisLease;
    }

    private String findBiggestOwner(HashMap<String, Integer> countsByOwner) {
        int biggestCount = 0;
        String biggestOwner = null;
        for (String owner : countsByOwner.keySet()) {
            if (countsByOwner.get(owner) <= biggestCount) continue;
            biggestCount = countsByOwner.get(owner);
            biggestOwner = owner;
        }
        return biggestOwner;
    }

    private HashMap<String, Integer> countLeasesByOwner(Iterable<Lease> leases) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Lease l : leases) {
            if (counts.containsKey(l.getOwner())) {
                Integer oldCount = (Integer)counts.get(l.getOwner());
                counts.put(l.getOwner(), oldCount + 1);
                continue;
            }
            counts.put(l.getOwner(), 1);
        }
        for (String owner : counts.keySet()) {
            TRACE_LOGGER.debug(this.hostContext.withHost("host " + owner + " owns " + counts.get(owner) + " leases"));
        }
        TRACE_LOGGER.debug(this.hostContext.withHost("total hosts in sorted list: " + counts.size()));
        return counts;
    }

    private class BoolWrapper {
        public boolean value;

        public BoolWrapper(boolean init) {
            this.value = init;
        }
    }

    class FinalException
    extends CompletionException {
        private static final long serialVersionUID = -4600271981700687166L;

        FinalException(CompletionException e) {
            super(e);
        }

        CompletionException getInner() {
            return (CompletionException)this.getCause();
        }
    }
}

