/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.errorprone.annotations.Immutable;

@Immutable
public class JavaFormatterOptions {
    static final int DEFAULT_MAX_LINE_LENGTH = 100;
    private final Style style;

    private JavaFormatterOptions(Style style) {
        this.style = style;
    }

    public int maxLineLength() {
        return 100;
    }

    public int indentationMultiplier() {
        return this.style.indentationMultiplier();
    }

    public static JavaFormatterOptions defaultOptions() {
        return JavaFormatterOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Style style = Style.GOOGLE;

        private Builder() {
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public JavaFormatterOptions build() {
            return new JavaFormatterOptions(this.style);
        }
    }

    public static enum Style {
        GOOGLE(1),
        AOSP(2);

        private final int indentationMultiplier;

        private Style(int indentationMultiplier) {
            this.indentationMultiplier = indentationMultiplier;
        }

        int indentationMultiplier() {
            return this.indentationMultiplier;
        }
    }
}

