/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.DataType;

public class FastPathDataType
implements AMQPType<Data>,
FastPathDescribedTypeConstructor<Data> {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(117L), Symbol.valueOf("amqp:data:binary")};
    private final DataType dataType;

    public FastPathDataType(EncoderImpl encoder) {
        this.dataType = new DataType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.dataType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.dataType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Data> getTypeClass() {
        return this.dataType.getTypeClass();
    }

    @Override
    public TypeEncoding<Data> getEncoding(Data val) {
        return this.dataType.getEncoding(val);
    }

    @Override
    public TypeEncoding<Data> getCanonicalEncoding() {
        return this.dataType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Data>> getAllEncodings() {
        return this.dataType.getAllEncodings();
    }

    @Override
    public Data readValue() {
        return new Data(this.getDecoder().readBinary());
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(Data data) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        buffer.put((byte)0);
        this.getEncoder().writeUnsignedLong(this.dataType.getDescriptor());
        this.getEncoder().writeBinary(data.getValue());
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathDataType type = new FastPathDataType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

