/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.codehaus.janino.ClassBodyEvaluator;
import org.logstash.ackedqueue.io.ByteBufferCleaner;

public final class LogstashJavaCompat {
    public static final boolean IS_JAVA_9_OR_GREATER = LogstashJavaCompat.isAtLeastJava9();

    public static ByteBufferCleaner setupBytebufferCleaner() {
        String fieldsCode;
        String ctorCode;
        String cleanerCode;
        ClassBodyEvaluator se = new ClassBodyEvaluator();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("java.nio.MappedByteBuffer");
        if (LogstashJavaCompat.isAtLeastJava9()) {
            imports.add("sun.misc.Unsafe");
            imports.add("java.lang.reflect.Field");
            cleanerCode = "unsafe.invokeCleaner(buffer);";
            ctorCode = "Field unsafeField = Unsafe.class.getDeclaredField(\"theUnsafe\");unsafeField.setAccessible(true);unsafe = (Unsafe) unsafeField.get(null);";
            fieldsCode = "private final Unsafe unsafe;";
        } else {
            imports.add("sun.misc.Cleaner");
            imports.add("sun.nio.ch.DirectBuffer");
            cleanerCode = "Cleaner c=((DirectBuffer)buffer).cleaner();if(c != null){c.clean();}";
            ctorCode = "";
            fieldsCode = "";
        }
        se.setImplementedInterfaces(new Class[]{ByteBufferCleaner.class});
        se.setClassName("ByteBufferCleanerImpl");
        se.setDefaultImports(imports.toArray(new String[0]));
        try {
            return (ByteBufferCleaner)se.createInstance((Reader)new StringReader(String.format("%s public ByteBufferCleanerImpl() throws Exception{%s} public void clean(MappedByteBuffer buffer){%s}", fieldsCode, ctorCode, cleanerCode)));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static boolean isAtLeastJava9() {
        String version;
        int end = (version = System.getProperty("java.version")).indexOf(46);
        return Integer.parseInt(version.substring(0, end > 0 ? end : version.length())) >= 9;
    }
}

