/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

@JRubyClass(name={"BufferedTokenizer"})
public class BufferedTokenizerExt
extends RubyObject {
    private static final IRubyObject MINUS_ONE = RubyUtil.RUBY.newFixnum(-1);
    private RubyArray input = RubyUtil.RUBY.newArray();
    private IRubyObject delimiter = RubyUtil.RUBY.newString("\n");
    private int sizeLimit;
    private boolean hasSizeLimit;
    private int inputSize;

    public BufferedTokenizerExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"initialize"}, optional=2)
    public IRubyObject init(ThreadContext context, IRubyObject[] args) {
        if (args.length >= 1) {
            this.delimiter = args[0];
        }
        if (args.length == 2) {
            this.sizeLimit = args[1].convertToInteger().getIntValue();
            this.hasSizeLimit = true;
        }
        this.inputSize = 0;
        return this;
    }

    @JRubyMethod
    public RubyArray extract(ThreadContext context, IRubyObject data) {
        RubyArray entities = ((RubyString)data).split(context, this.delimiter, MINUS_ONE);
        if (this.hasSizeLimit) {
            int entitiesSize = ((RubyString)entities.first()).size();
            if (this.inputSize + entitiesSize > this.sizeLimit) {
                throw new IllegalStateException("input buffer full");
            }
            this.inputSize += entitiesSize;
        }
        this.input.append(entities.shift(context));
        if (entities.isEmpty()) {
            return RubyUtil.RUBY.newArray();
        }
        entities.unshift(this.input.join(context));
        this.input.clear();
        this.input.append(entities.pop(context));
        this.inputSize = ((RubyString)this.input.first()).size();
        return entities;
    }

    @JRubyMethod
    public IRubyObject flush(ThreadContext context) {
        IRubyObject buffer = this.input.join(context);
        this.input.clear();
        return buffer;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject isEmpty(ThreadContext context) {
        return this.input.empty_p();
    }
}

