/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logstash.config.ir.graph.Vertex;

public class ShortestPath {
    public static List<Vertex> shortestPath(Vertex from, Vertex to) throws InvalidShortestPathArguments {
        return ShortestPath.shortestPath(from, Collections.singleton(to)).get(to);
    }

    public static Map<Vertex, List<Vertex>> shortestPath(Vertex from, Collection<Vertex> to) throws InvalidShortestPathArguments {
        return ShortestPath.shortestPath(from, to, false);
    }

    public static Map<Vertex, List<Vertex>> shortestReversePath(Vertex from, Collection<Vertex> to) throws InvalidShortestPathArguments {
        return ShortestPath.shortestPath(from, to, true);
    }

    public static Map<Vertex, List<Vertex>> shortestPath(Vertex from, Collection<Vertex> to, boolean reverseSearch) throws InvalidShortestPathArguments {
        HashMap<Vertex, Integer> vertexDistances = new HashMap<Vertex, Integer>();
        HashMap vertexPathPrevious = new HashMap();
        ArrayList<Vertex> pending = new ArrayList<Vertex>();
        Stream<Vertex> searchSpace = reverseSearch ? from.ancestors() : from.descendants();
        searchSpace.forEach(vertex -> {
            pending.add((Vertex)vertex);
            vertexDistances.put((Vertex)vertex, Integer.MAX_VALUE);
        });
        pending.add(from);
        vertexDistances.put(from, 0);
        Collection invalidVertices = to.stream().filter(v -> !pending.contains(v)).collect(Collectors.toList());
        if (!invalidVertices.isEmpty()) {
            throw new InvalidShortestPathArguments(invalidVertices);
        }
        while (!pending.isEmpty()) {
            Vertex current = pending.stream().min(Comparator.comparing(vertexDistances::get)).get();
            int currentDistance = (Integer)vertexDistances.get(current);
            pending.remove(current);
            Stream<Vertex> toProcess = reverseSearch ? current.incomingVertices() : current.outgoingVertices();
            toProcess.forEach(v -> {
                int altDistance = currentDistance + 1;
                Integer curDistance = (Integer)vertexDistances.get(v);
                if (altDistance < curDistance) {
                    vertexDistances.put((Vertex)v, altDistance);
                    vertexPathPrevious.put(v, current);
                }
            });
        }
        HashMap<Vertex, List<Vertex>> result = new HashMap<Vertex, List<Vertex>>(to.size());
        for (Vertex toVertex : to) {
            int toVertexDistance = (Integer)vertexDistances.get(toVertex);
            ArrayList<Vertex> path = new ArrayList<Vertex>(toVertexDistance + 1);
            Vertex pathCurrentVertex = toVertex;
            while (pathCurrentVertex != from) {
                path.add(pathCurrentVertex);
                pathCurrentVertex = (Vertex)vertexPathPrevious.get(pathCurrentVertex);
            }
            path.add(from);
            Collections.reverse(path);
            result.put(toVertex, path);
        }
        return result;
    }

    static class InvalidShortestPathArguments
    extends Exception {
        private static final long serialVersionUID = -1493537067800744231L;
        private final Collection<Vertex> invalidVertices;

        public InvalidShortestPathArguments(Collection<Vertex> invalidVertices) {
            this.invalidVertices = invalidVertices;
        }

        @Override
        public String getMessage() {
            String verticesMessage = this.invalidVertices.stream().map(Object::toString).collect(Collectors.joining(", "));
            return "Attempted to determine path for vertex that is not in the search space!" + verticesMessage;
        }
    }
}

