/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyTimestampExtLibrary;

@JRubyClass(name={"ConvergeResult"})
public class ConvergeResultExt
extends RubyObject {
    private IRubyObject expectedActionsCount;
    private ConcurrentHashMap<IRubyObject, ActionResultExt> actions;

    public ConvergeResultExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject expectedActionsCount) {
        this.expectedActionsCount = expectedActionsCount;
        this.actions = new ConcurrentHashMap();
        return this;
    }

    @JRubyMethod
    public IRubyObject add(ThreadContext context, IRubyObject action, IRubyObject actionResult) {
        return (IRubyObject)this.actions.put(action, ActionResultExt.create(context, null, action, actionResult));
    }

    @JRubyMethod(name={"failed_actions"})
    public IRubyObject failedActions(ThreadContext context) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, this.filterBySuccessfulState(context, (IRubyObject)context.fals));
    }

    @JRubyMethod(name={"successful_actions"})
    public IRubyObject successfulActions(ThreadContext context) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, this.filterBySuccessfulState(context, (IRubyObject)context.tru));
    }

    @JRubyMethod(name={"complete?"})
    public IRubyObject isComplete(ThreadContext context) {
        return this.total(context).eql(this.expectedActionsCount) ? context.tru : context.fals;
    }

    @JRubyMethod
    public IRubyObject total(ThreadContext context) {
        return RubyUtil.RUBY.newFixnum(this.actions.size());
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject isSuccess(ThreadContext context) {
        return this.filterBySuccessfulState(context, (IRubyObject)context.fals).isEmpty() && this.isComplete(context).isTrue() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"fails_count"})
    public IRubyObject failsCount(ThreadContext context) {
        return this.failedActions(context).callMethod(context, "size");
    }

    @JRubyMethod(name={"success_count"})
    public IRubyObject successCount(ThreadContext context) {
        return this.successfulActions(context).callMethod(context, "size");
    }

    private Map<IRubyObject, ActionResultExt> filterBySuccessfulState(ThreadContext context, IRubyObject predicate) {
        HashMap<IRubyObject, ActionResultExt> result = new HashMap<IRubyObject, ActionResultExt>();
        this.actions.entrySet().stream().filter(el -> ((ActionResultExt)((Object)((Object)el.getValue()))).isSuccessful(context).eql(predicate)).forEach(entry -> {
            ActionResultExt cfr_ignored_0 = (ActionResultExt)((Object)((Object)result.put((IRubyObject)entry.getKey(), (ActionResultExt)((Object)entry.getValue()))));
        });
        return result;
    }

    @JRubyClass(name={"SuccessfulAction"})
    public static final class SuccessfulActionExt
    extends ActionResultExt {
        public SuccessfulActionExt(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public SuccessfulActionExt initialize(ThreadContext context) {
            super.initialize(context);
            return this;
        }

        @Override
        protected boolean getSuccessFul() {
            return true;
        }
    }

    @JRubyClass(name={"FailedAction"})
    public static final class FailedActionExt
    extends ActionResultExt {
        private IRubyObject message;
        private IRubyObject backtrace;

        public FailedActionExt(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(optional=1)
        public FailedActionExt initialize(ThreadContext context, IRubyObject[] args) {
            super.initialize(context);
            this.message = args[0];
            this.backtrace = args.length > 1 ? args[1] : context.nil;
            return this;
        }

        @JRubyMethod(name={"message"})
        public IRubyObject getMessage() {
            return this.message;
        }

        @JRubyMethod(name={"backtrace"})
        public IRubyObject getBacktrace() {
            return this.backtrace;
        }

        @JRubyMethod(name={"from_exception"}, meta=true)
        public static ActionResultExt fromException(ThreadContext context, IRubyObject recv, IRubyObject exception) {
            IRubyObject[] args = new IRubyObject[]{exception.callMethod(context, "message"), exception.callMethod(context, "backtrace")};
            return new FailedActionExt(context.runtime, RubyUtil.FAILED_ACTION_CLASS).initialize(context, args);
        }

        @JRubyMethod(name={"from_action"}, meta=true)
        public static ActionResultExt fromAction(ThreadContext context, IRubyObject recv, IRubyObject action, IRubyObject actionResult) {
            IRubyObject[] args = new IRubyObject[]{RubyUtil.RUBY.newString(String.format("Could not execute action: %s, action_result: %s", action, actionResult))};
            return new FailedActionExt(context.runtime, RubyUtil.FAILED_ACTION_CLASS).initialize(context, args);
        }

        @Override
        protected boolean getSuccessFul() {
            return false;
        }
    }

    @JRubyClass(name={"ActionResult"})
    public static abstract class ActionResultExt
    extends RubyBasicObject {
        private IRubyObject executedAt;

        protected ActionResultExt(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(meta=true)
        public static ActionResultExt create(ThreadContext context, IRubyObject recv, IRubyObject action, IRubyObject actionResult) {
            ActionResultExt result;
            if (actionResult instanceof ActionResultExt) {
                result = (ActionResultExt)actionResult;
            } else if (actionResult.getMetaClass().isKindOfModule((RubyModule)context.runtime.getException())) {
                result = FailedActionExt.fromException(context, null, actionResult);
            } else if (actionResult.eql((IRubyObject)context.tru)) {
                result = new SuccessfulActionExt(context.runtime, RubyUtil.SUCCESSFUL_ACTION_CLASS).initialize(context);
            } else if (actionResult.eql((IRubyObject)context.fals)) {
                result = FailedActionExt.fromAction(context, (IRubyObject)RubyUtil.FAILED_ACTION_CLASS, action, actionResult);
            } else {
                throw context.runtime.newRaiseException(RubyUtil.LOGSTASH_ERROR, String.format("Don't know how to handle `%s` for `%s`", actionResult.getMetaClass(), action));
            }
            return result;
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context) {
            this.executedAt = JrubyTimestampExtLibrary.RubyTimestamp.ruby_now(context, null);
            return this;
        }

        @JRubyMethod(name={"executed_at"})
        public final IRubyObject getExecutedAt() {
            return this.executedAt;
        }

        @JRubyMethod(name={"successful?"})
        public final IRubyObject isSuccessful(ThreadContext context) {
            return this.getSuccessFul() ? context.tru : context.fals;
        }

        protected abstract boolean getSuccessFul();
    }
}

