/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

public class SingleShotLinearTimer {
    private volatile Runnable _task;
    private Thread _thread;
    private static final long NANOS_IN_MILLI = 1000000L;

    public synchronized void schedule(Runnable task, int timeoutMillisec) {
        if (task == null) {
            throw new IllegalArgumentException("Don't schedule a null task");
        }
        if (this._task != null) {
            throw new UnsupportedOperationException("Don't schedule more than one task");
        }
        if (timeoutMillisec < 0) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        this._task = task;
        this._thread = new Thread(new TimerThread(timeoutMillisec));
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void cancel() {
        this._task = null;
    }

    private class TimerThread
    implements Runnable {
        private final long _runTime;

        public TimerThread(long timeoutMillisec) {
            this._runTime = System.nanoTime() / 1000000L + timeoutMillisec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task;
                boolean wasInterrupted = false;
                try {
                    long now;
                    while ((now = System.nanoTime() / 1000000L) < this._runTime) {
                        if (SingleShotLinearTimer.this._task == null) {
                            break;
                        }
                        try {
                            TimerThread timerThread = this;
                            synchronized (timerThread) {
                                this.wait(this._runTime - now);
                            }
                        }
                        catch (InterruptedException e) {
                            wasInterrupted = true;
                        }
                    }
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if ((task = SingleShotLinearTimer.this._task) != null) {
                    task.run();
                }
            }
            finally {
                SingleShotLinearTimer.this._task = null;
            }
        }
    }
}

