/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamCopyingHiddenTokenFilter;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.mode.java.preproc.PdeEmitter;
import processing.mode.java.preproc.PdeLexer;
import processing.mode.java.preproc.PdeRecognizer;
import processing.mode.java.preproc.PreprocessorResult;
import processing.mode.java.preproc.TokenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdePreprocessor {
    private static final int ROOT_ID = 0;
    protected final String indent;
    private final String name;
    private TokenStreamCopyingHiddenTokenFilter filter;
    private boolean foundMain;
    private String advClassName = "";
    protected Mode mode;
    private static final Pattern PUBLIC_CLASS = Pattern.compile("(^|;)\\s*public\\s+class\\s+\\S+\\s+extends\\s+PApplet", 8);
    private static final Pattern FUNCTION_DECL = Pattern.compile("(^|;)\\s*((public|private|protected|final|static)\\s+)*(void|int|float|double|String|char|byte)(\\s*\\[\\s*\\])?\\s+[a-zA-Z0-9]+\\s*\\(", 8);

    public void setFoundMain(boolean foundMain) {
        this.foundMain = foundMain;
    }

    public boolean getFoundMain() {
        return this.foundMain;
    }

    public void setAdvClassName(String advClassName) {
        this.advClassName = advClassName;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public PdePreprocessor(String sketchName) {
        this(sketchName, Preferences.getInteger("editor.tabs.size"));
    }

    public PdePreprocessor(String sketchName, int tabSize) {
        this.name = sketchName;
        char[] indentChars = new char[tabSize];
        Arrays.fill(indentChars, ' ');
        this.indent = new String(indentChars);
    }

    CommonHiddenStreamToken getHiddenAfter(CommonHiddenStreamToken t) {
        return this.filter.getHiddenAfter(t);
    }

    CommonHiddenStreamToken getInitialHiddenToken() {
        return this.filter.getInitialHiddenToken();
    }

    private static int countNewlines(String s) {
        int count = 0;
        int pos = s.indexOf(10, 0);
        while (pos >= 0) {
            ++count;
            pos = s.indexOf(10, pos + 1);
        }
        return count;
    }

    private static void checkForUnterminatedMultilineComment(String program) throws SketchException {
        int length = program.length();
        for (int i = 0; i < length; ++i) {
            boolean terminated;
            if (program.charAt(i) == '/' && i < length - 1 && program.charAt(i + 1) == '/') {
                i += 2;
                while (i < length && program.charAt(i) != '\n') {
                    ++i;
                }
                continue;
            }
            if (program.charAt(i) == '/' && i < length - 1 && program.charAt(i + 1) == '*') {
                int startOfComment = i;
                i += 2;
                terminated = false;
                while (i < length - 1) {
                    if (program.charAt(i) == '*' && program.charAt(i + 1) == '/') {
                        i += 2;
                        terminated = true;
                        break;
                    }
                    ++i;
                }
                if (terminated) continue;
                throw new SketchException("Unclosed /* comment */", 0, PdePreprocessor.countNewlines(program.substring(0, startOfComment)));
            }
            if (program.charAt(i) == '\"') {
                int stringStart = i++;
                terminated = false;
                while (i < length) {
                    char c = program.charAt(i);
                    if (c == '\"') {
                        terminated = true;
                        break;
                    }
                    if (c == '\\') {
                        if (i == length - 1) break;
                        ++i;
                    } else if (c == '\n') break;
                    ++i;
                }
                if (terminated) continue;
                throw new SketchException("Unterminated string constant", 0, PdePreprocessor.countNewlines(program.substring(0, stringStart)));
            }
            if (program.charAt(i) != '\'') continue;
            if (++i >= length) {
                throw new SketchException("Unterminated character constant", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
            }
            if (program.charAt(i) == '\\') {
                ++i;
            }
            if (++i >= length) {
                throw new SketchException("Unterminated character constant", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
            }
            if (program.charAt(i) == '\'') continue;
            throw new SketchException("Badly formed character constant", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
        }
    }

    public PreprocessorResult write(Writer out, String program) throws SketchException, RecognitionException, TokenStreamException {
        return this.write(out, program, null);
    }

    public PreprocessorResult write(Writer out, String program, String[] codeFolderPackages) throws SketchException, RecognitionException, TokenStreamException {
        String[] pieces;
        ArrayList<String> programImports = new ArrayList<String>();
        ArrayList<String> codeFolderImports = new ArrayList<String>();
        this.foundMain = false;
        if (!program.endsWith("\n")) {
            program = program + "\n";
        }
        PdePreprocessor.checkForUnterminatedMultilineComment(program);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            program = PdePreprocessor.substituteUnicode(program);
        }
        String importRegexp = "(?:^|;)\\s*(import\\s+)((?:static\\s+)?\\S+)(\\s*;)";
        while ((pieces = PApplet.match((String)program, (String)"(?:^|;)\\s*(import\\s+)((?:static\\s+)?\\S+)(\\s*;)")) != null) {
            String piece = pieces[1] + pieces[2] + pieces[3];
            int len = piece.length();
            programImports.add(pieces[2]);
            int idx = program.indexOf(piece);
            program = program.substring(0, idx) + program.substring(idx + len);
        }
        if (codeFolderPackages != null) {
            for (String item : codeFolderPackages) {
                codeFolderImports.add(item + ".*");
            }
        }
        PrintWriter stream = new PrintWriter(out);
        int headerOffset = this.writeImports(stream, programImports, codeFolderImports);
        return new PreprocessorResult(this.mode, headerOffset + 2, this.write(program, stream), programImports);
    }

    static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] <= '\u007f') continue;
            ++unicodeCount;
        }
        if (unicodeCount == 0) {
            return program;
        }
        int index = 0;
        char[] p2 = new char[p.length + unicodeCount * 5];
        for (int i = 0; i < p.length; ++i) {
            if (p[i] < '\u0080') {
                p2[index++] = p[i];
                continue;
            }
            if (p[i] == '\u00a0') {
                p2[index++] = 32;
                continue;
            }
            char c = p[i];
            p2[index++] = 92;
            p2[index++] = 117;
            char[] str = Integer.toHexString(c).toCharArray();
            for (int m = 0; m < 4 - str.length; ++m) {
                p2[index++] = 48;
            }
            System.arraycopy(str, 0, p2, index, str.length);
            index += str.length;
        }
        return new String(p2, 0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String write(String program, PrintWriter stream) throws SketchException, RecognitionException, TokenStreamException {
        PdeRecognizer parser = this.createParser(program);
        if (PUBLIC_CLASS.matcher(program).find()) {
            try {
                PrintStream saved = System.err;
                try {
                    System.setErr(new PrintStream(new ByteArrayOutputStream()));
                    parser.javaProgram();
                }
                finally {
                    System.setErr(saved);
                }
                this.setMode(Mode.JAVA);
            }
            catch (Exception e) {
                parser = this.createParser(program);
                parser.pdeProgram();
            }
        } else if (FUNCTION_DECL.matcher(program).find()) {
            this.setMode(Mode.ACTIVE);
            parser.activeProgram();
        } else {
            parser.pdeProgram();
        }
        ASTFactory factory = new ASTFactory();
        AST parserAST = parser.getAST();
        AST rootNode = factory.create(0, "AST ROOT");
        rootNode.setFirstChild(parserAST);
        this.makeSimpleMethodsPublic(rootNode);
        CommonAST.setVerboseStringConversion((boolean)true, (String[])parser.getTokenNames());
        String className = this.mode == Mode.JAVA ? this.getFirstClassName(parserAST) : this.name;
        if (className == null) {
            return null;
        }
        this.writeDeclaration(stream, className);
        new PdeEmitter(this, stream).print(rootNode);
        this.writeFooter(stream, className);
        if (Preferences.getBoolean("preproc.output_parse_tree")) {
            this.writeParseTree("parseTree.xml", parserAST);
        }
        return className;
    }

    private PdeRecognizer createParser(String program) {
        PdeLexer lexer = new PdeLexer(new StringReader(program));
        lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        this.filter = new TokenStreamCopyingHiddenTokenFilter(lexer);
        this.filter.hide(167);
        this.filter.hide(168);
        this.filter.hide(166);
        this.filter.copy(63);
        this.filter.copy(97);
        this.filter.copy(98);
        this.filter.copy(100);
        this.filter.copy(101);
        this.filter.copy(74);
        this.filter.copy(67);
        this.filter.copy(66);
        this.filter.copy(111);
        this.filter.copy(110);
        this.filter.copy(73);
        this.filter.copy(75);
        this.filter.copy(76);
        this.filter.copy(77);
        PdeRecognizer parser = new PdeRecognizer(this, this.filter);
        parser.setASTNodeClass("antlr.ExtendedCommonASTWithHiddenTokens");
        return parser;
    }

    private void makeSimpleMethodsPublic(AST node) {
        if (node.getType() == 9) {
            AST oldFirstMod;
            AST mods = node.getFirstChild();
            for (AST mod = oldFirstMod = mods.getFirstChild(); mod != null; mod = mod.getNextSibling()) {
                int t = mod.getType();
                if (t != 88 && t != 90 && t != 89) continue;
                return;
            }
            if (mods.getNextSibling().getType() == 57) {
                return;
            }
            CommonHiddenStreamToken publicToken = new CommonHiddenStreamToken(89, "public"){
                {
                    this.setHiddenAfter(new CommonHiddenStreamToken(166, " "));
                }
            };
            CommonASTWithHiddenTokens publicNode = new CommonASTWithHiddenTokens((Token)publicToken);
            publicNode.setNextSibling(oldFirstMod);
            mods.setFirstChild((AST)publicNode);
        } else {
            for (AST kid = node.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                this.makeSimpleMethodsPublic(kid);
            }
        }
    }

    protected void writeParseTree(String filename, AST ast) {
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(filename));
            stream.println("<?xml version=\"1.0\"?>");
            stream.println("<document>");
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            if (ast != null) {
                ((CommonAST)ast).xmlSerialize((Writer)writer);
            }
            writer.flush();
            stream.println("</document>");
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int writeImports(PrintWriter out, List<String> programImports, List<String> codeFolderImports) {
        int count = this.writeImportList(out, this.getCoreImports());
        count += this.writeImportList(out, programImports);
        count += this.writeImportList(out, codeFolderImports);
        return count += this.writeImportList(out, this.getDefaultImports());
    }

    protected int writeImportList(PrintWriter out, List<String> imports) {
        return this.writeImportList(out, imports.toArray(new String[0]));
    }

    protected int writeImportList(PrintWriter out, String[] imports) {
        int count = 0;
        if (imports != null && imports.length != 0) {
            for (String item : imports) {
                out.println("import " + item + "; ");
                ++count;
            }
            out.println();
            ++count;
        }
        return count;
    }

    protected void writeDeclaration(PrintWriter out, String className) {
        if (this.mode == Mode.JAVA) {
            out.println();
            out.println();
        } else if (this.mode == Mode.ACTIVE) {
            out.println("public class " + className + " extends PApplet {");
            out.println();
        } else if (this.mode == Mode.STATIC) {
            out.println("public class " + className + " extends PApplet {");
            out.println(this.indent + "public void setup() {");
        }
    }

    protected void writeFooter(PrintWriter out, String className) {
        if (this.mode == Mode.STATIC) {
            out.println(this.indent + "noLoop();");
            out.println("} ");
        }
        if (this.mode == Mode.STATIC || this.mode == Mode.ACTIVE) {
            if (!this.foundMain) {
                out.println(this.indent + "static public void main(String args[]) {");
                out.print(this.indent + this.indent + "PApplet.main(new String[] { ");
                if (Preferences.getBoolean("export.application.fullscreen")) {
                    out.print("\"--present\", ");
                    String farbe = Preferences.get("run.present.bgcolor");
                    out.print("\"--bgcolor=" + farbe + "\", ");
                    if (Preferences.getBoolean("export.application.stop")) {
                        farbe = Preferences.get("run.present.stop.color");
                        out.print("\"--stop-color=" + farbe + "\", ");
                    } else {
                        out.print("\"--hide-stop\", ");
                    }
                } else {
                    String farbe = Preferences.get("run.window.bgcolor");
                    out.print("\"--bgcolor=" + farbe + "\", ");
                }
                out.println("\"" + className + "\" });");
                out.println(this.indent + "}");
            }
            out.println("}");
        }
    }

    public String[] getCoreImports() {
        return new String[]{"processing.core.*", "processing.xml.*"};
    }

    public String[] getDefaultImports() {
        String prefsLine = Preferences.get("preproc.imports.list");
        return PApplet.splitTokens((String)prefsLine, (String)", ");
    }

    String getFirstClassName(AST ast) {
        String t = this.advClassName;
        this.advClassName = "";
        return t;
    }

    public void debugAST(AST ast, boolean includeHidden) {
        System.err.println("------------------");
        this.debugAST(ast, includeHidden, 0);
    }

    private void debugAST(AST ast, boolean includeHidden, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.err.print("    ");
        }
        if (includeHidden) {
            System.err.print(this.debugHiddenBefore(ast));
        }
        if (ast.getType() > 0 && !ast.getText().equals(TokenUtil.nameOf(ast))) {
            System.err.print(TokenUtil.nameOf(ast) + "/");
        }
        System.err.print(ast.getText().replace("\n", "\\n"));
        if (includeHidden) {
            System.err.print(this.debugHiddenAfter(ast));
        }
        System.err.println();
        for (AST kid = ast.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            this.debugAST(kid, includeHidden, indent + 1);
        }
    }

    private String debugHiddenAfter(AST ast) {
        if (!(ast instanceof CommonASTWithHiddenTokens)) {
            return "";
        }
        return this.debugHiddenTokens(((CommonASTWithHiddenTokens)ast).getHiddenAfter());
    }

    private String debugHiddenBefore(AST ast) {
        if (!(ast instanceof CommonASTWithHiddenTokens)) {
            return "";
        }
        CommonHiddenStreamToken child = null;
        CommonHiddenStreamToken parent = ((CommonASTWithHiddenTokens)ast).getHiddenBefore();
        if (parent == null) {
            return "";
        }
        while ((parent = (child = parent).getHiddenBefore()) != null) {
        }
        return this.debugHiddenTokens(child);
    }

    private String debugHiddenTokens(CommonHiddenStreamToken t) {
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            if (sb.length() == 0) {
                sb.append("[");
            }
            sb.append(t.getText().replace("\n", "\\n"));
            t = this.filter.getHiddenAfter(t);
        }
        if (sb.length() > 0) {
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        STATIC,
        ACTIVE,
        JAVA;

    }
}

