/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.NotEmptyException;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDistribStateManager
implements DistribStateManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    LinkedHashMap<String, VersionedData> dataMap = new LinkedHashMap();

    public SnapshotDistribStateManager(DistribStateManager other, AutoScalingConfig config) throws Exception {
        List tree = other.listTree("/");
        log.debug("- copying {} resources from {}", (Object)tree.size(), (Object)other.getClass().getSimpleName());
        for (String path : tree) {
            this.dataMap.put(path, other.getData(path));
        }
        if (config != null) {
            VersionedData vd = new VersionedData(config.getZkVersion(), Utils.toJSON((Object)config), CreateMode.PERSISTENT, "0");
            this.dataMap.put("/autoscaling.json", vd);
        }
    }

    public SnapshotDistribStateManager(Map<String, Object> snapshot) {
        snapshot.forEach((path, value) -> {
            Map map = (Map)value;
            Number version = map.getOrDefault("version", 0);
            String owner = (String)map.get("owner");
            String modeStr = map.getOrDefault("mode", CreateMode.PERSISTENT.toString());
            CreateMode mode = CreateMode.valueOf((String)modeStr);
            byte[] bytes = null;
            if (map.containsKey("data")) {
                bytes = Base64.base64ToByteArray((String)((String)map.get("data")));
            }
            this.dataMap.put((String)path, new VersionedData(version.intValue(), bytes, mode, owner));
        });
        log.debug("- loaded snapshot of {} resources", (Object)this.dataMap.size());
    }

    public Map<String, Object> getSnapshot() {
        LinkedHashMap<String, Object> snapshot = new LinkedHashMap<String, Object>();
        this.dataMap.forEach((path, vd) -> {
            HashMap data = new HashMap();
            vd.toMap(data);
            snapshot.put((String)path, data);
        });
        return snapshot;
    }

    public boolean hasData(String path) throws IOException, KeeperException, InterruptedException {
        return this.dataMap.containsKey(path);
    }

    public List<String> listData(String path) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        return this.listData(path, null);
    }

    public List<String> listTree(String path) {
        return this.dataMap.keySet().stream().filter(p -> p.startsWith(path)).collect(Collectors.toList());
    }

    public List<String> listData(String path, Watcher watcher) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        String prefix = path + "/";
        return this.dataMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).map(e -> {
            String suffix = ((String)e.getKey()).substring(prefix.length());
            int idx = suffix.indexOf(47);
            if (idx == -1) {
                return suffix;
            }
            return suffix.substring(0, idx);
        }).collect(Collectors.toList());
    }

    public VersionedData getData(String path, Watcher watcher) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        if (!this.dataMap.containsKey(path)) {
            throw new NoSuchElementException(path);
        }
        return this.dataMap.get(path);
    }

    public void makePath(String path) throws AlreadyExistsException, IOException, KeeperException, InterruptedException {
        throw new UnsupportedOperationException("makePath");
    }

    public void makePath(String path, byte[] data, CreateMode createMode, boolean failOnExists) throws AlreadyExistsException, IOException, KeeperException, InterruptedException {
        throw new UnsupportedOperationException("makePath");
    }

    public String createData(String path, byte[] data, CreateMode mode) throws AlreadyExistsException, IOException, KeeperException, InterruptedException {
        throw new UnsupportedOperationException("createData");
    }

    public void removeData(String path, int version) throws NoSuchElementException, IOException, NotEmptyException, KeeperException, InterruptedException, BadVersionException {
        throw new UnsupportedOperationException("removeData");
    }

    public void setData(String path, byte[] data, int version) throws BadVersionException, NoSuchElementException, IOException, KeeperException, InterruptedException {
        throw new UnsupportedOperationException("setData");
    }

    public List<OpResult> multi(Iterable<Op> ops) throws BadVersionException, NoSuchElementException, AlreadyExistsException, IOException, KeeperException, InterruptedException {
        throw new UnsupportedOperationException("multi");
    }

    public AutoScalingConfig getAutoScalingConfig(Watcher watcher) throws InterruptedException, IOException {
        VersionedData vd = this.dataMap.get("/autoscaling.json");
        Map<String, Integer> map = new HashMap();
        if (vd != null && vd.getData() != null && vd.getData().length > 0) {
            map = (Map)Utils.fromJSON((byte[])vd.getData());
            map.put("zkVersion", vd.getVersion());
        }
        return new AutoScalingConfig(map);
    }

    public void close() throws IOException {
    }
}

