/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.Map;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetQuery;

class FacetQueryParser
extends FacetParser<FacetQuery> {
    public FacetQueryParser(FacetParser parent, String key) {
        super(parent, key);
        this.facet = new FacetQuery();
    }

    @Override
    public FacetQuery parse(Object arg) throws SyntaxError {
        this.parseCommonParams(arg);
        String qstring = null;
        if (arg instanceof String) {
            qstring = (String)arg;
        } else if (arg instanceof Map) {
            Map m = (Map)arg;
            qstring = this.getString(m, "q", null);
            if (qstring == null) {
                qstring = this.getString(m, "query", null);
            }
            this.parseSubs(m.get("facet"));
        } else if (arg != null) {
            throw this.err("Expected string/map for facet query, received " + arg.getClass().getSimpleName() + "=" + arg);
        }
        if (qstring != null) {
            QParser parser = QParser.getParser(qstring, this.getSolrRequest());
            parser.setIsFilter(true);
            ((FacetQuery)this.facet).q = parser.getQuery();
        }
        return (FacetQuery)this.facet;
    }
}

