/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Filterator<E>
implements Iterator<E> {
    Class<E> includeFilter;
    Iterator<? extends Object> iterator;
    E lookAhead;
    boolean ready;

    public Filterator(Iterator<?> iterator, Class<E> includeFilter) {
        this.iterator = iterator;
        this.includeFilter = includeFilter;
    }

    @Override
    public boolean hasNext() {
        if (this.ready) {
            return true;
        }
        try {
            this.lookAhead = this.next();
            this.ready = true;
            return true;
        }
        catch (NoSuchElementException e) {
            this.ready = false;
            return false;
        }
    }

    @Override
    public E next() {
        if (this.ready) {
            E o = this.lookAhead;
            this.ready = false;
            return o;
        }
        while (this.iterator.hasNext()) {
            Object o = this.iterator.next();
            if (!this.includeFilter.isInstance(o)) continue;
            return this.includeFilter.cast(o);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

