/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrResourceNotFoundException;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkSolrResourceLoader
extends SolrResourceLoader {
    private final String configSetZkPath;
    private ZkController zkController;
    private ZkIndexSchemaReader zkIndexSchemaReader;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkSolrResourceLoader(Path instanceDir, String configSet, ZkController zooKeeperController) {
        super(instanceDir);
        this.zkController = zooKeeperController;
        this.configSetZkPath = "/configs/" + configSet;
    }

    public ZkSolrResourceLoader(Path instanceDir, String configSet, ClassLoader parent, Properties coreProperties, ZkController zooKeeperController) {
        super(instanceDir, parent, coreProperties);
        this.zkController = zooKeeperController;
        this.configSetZkPath = "/configs/" + configSet;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        InputStream is;
        String file = ".".equals(resource) ? this.configSetZkPath : this.configSetZkPath + "/" + resource;
        int maxTries = 10;
        KeeperException.SessionExpiredException exception = null;
        while (maxTries-- > 0) {
            try {
                if (this.zkController.pathExists(file)) {
                    Stat stat = new Stat();
                    byte[] bytes = this.zkController.getZkClient().getData(file, null, stat, true);
                    return new ZkByteArrayInputStream(bytes, stat);
                }
                break;
            }
            catch (KeeperException.SessionExpiredException e) {
                exception = e;
                if (this.zkController.getCoreContainer().isShutDown()) continue;
                try {
                    Thread.sleep(1000L);
                    log.debug("Sleeping for 1s before retrying fetching resource=" + resource);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Could not load resource=" + resource, ie);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Error opening " + file, e);
            }
            catch (Exception e) {
                throw new IOException("Error opening " + file, e);
            }
        }
        if (exception != null) {
            throw new IOException("We re-tried 10 times but was still unable to fetch resource=" + resource + " from ZK", exception);
        }
        try {
            is = this.classLoader.getResourceAsStream(resource.replace(File.separatorChar, '/'));
        }
        catch (Exception e) {
            throw new IOException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new SolrResourceNotFoundException("Can't find resource '" + resource + "' in classpath or '" + this.configSetZkPath + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    @Override
    public String getConfigDir() {
        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "ZkSolrResourceLoader does not support getConfigDir() - likely, what you are trying to do is not supported in ZooKeeper mode");
    }

    @Override
    public String[] listConfigDir() {
        List list;
        try {
            list = this.zkController.getZkClient().getChildren(this.configSetZkPath, null, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return list.toArray(new String[0]);
    }

    public String getConfigSetZkPath() {
        return this.configSetZkPath;
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public void setZkIndexSchemaReader(ZkIndexSchemaReader zkIndexSchemaReader) {
        this.zkIndexSchemaReader = zkIndexSchemaReader;
    }

    public ZkIndexSchemaReader getZkIndexSchemaReader() {
        return this.zkIndexSchemaReader;
    }

    public static class ZkByteArrayInputStream
    extends ByteArrayInputStream {
        private final Stat stat;

        public ZkByteArrayInputStream(byte[] buf, Stat stat) {
            super(buf);
            this.stat = stat;
        }

        public Stat getStat() {
            return this.stat;
        }
    }
}

