/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.MaintainCategoryRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryRoutedAlias
implements RoutedAlias {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String COLLECTION_INFIX = "__CRA__";
    public static final String UNINITIALIZED = "NEW_CATEGORY_ROUTED_ALIAS_WAITING_FOR_DATA__TEMP";
    public static final String ROUTER_MAX_CARDINALITY = "router.maxCardinality";
    public static final Set<String> REQUIRED_ROUTER_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("name", "router.name", "router.field", "router.maxCardinality")));
    public static final String ROUTER_MUST_MATCH = "router.mustMatch";
    public static final Set<String> OPTIONAL_ROUTER_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("router.maxCardinality", "router.mustMatch")));
    private Aliases parsedAliases;
    private final String aliasName;
    private final Map<String, String> aliasMetadata;
    private final Integer maxCardinality;
    private final Pattern mustMatch;

    CategoryRoutedAlias(String aliasName, Map<String, String> aliasMetadata) {
        this.aliasName = aliasName;
        this.aliasMetadata = aliasMetadata;
        this.maxCardinality = this.parseMaxCardinality(aliasMetadata.get(ROUTER_MAX_CARDINALITY));
        String mustMatch = this.aliasMetadata.get(ROUTER_MUST_MATCH);
        this.mustMatch = mustMatch == null ? null : this.compileMustMatch(mustMatch);
    }

    @Override
    public boolean updateParsedCollectionAliases(ZkController zkController) {
        Aliases aliases = zkController.getZkStateReader().getAliases();
        if (this.parsedAliases != aliases) {
            if (this.parsedAliases != null) {
                log.debug("Observing possibly updated alias: {}", (Object)this.getAliasName());
            }
            this.parsedAliases = aliases;
            return true;
        }
        return false;
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public String getRouteField() {
        return this.aliasMetadata.get("router.field");
    }

    @Override
    public void validateRouteValue(AddUpdateCommand cmd) throws SolrException {
        Object fieldValue;
        if (this.parsedAliases == null) {
            this.updateParsedCollectionAliases(cmd.getReq().getCore().getCoreContainer().getZkController());
        }
        if ((fieldValue = cmd.getSolrInputDocument().getFieldValue(this.getRouteField())) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Route value is null");
        }
        String dataValue = String.valueOf(fieldValue);
        String candidateCollectionName = this.buildCollectionNameFromValue(dataValue);
        List<String> cols = this.getCollectionList(this.parsedAliases);
        if (cols.contains(candidateCollectionName)) {
            return;
        }
        int infix = candidateCollectionName.indexOf(COLLECTION_INFIX);
        int valueStart = infix + COLLECTION_INFIX.length();
        if (candidateCollectionName.substring(valueStart).contains(COLLECTION_INFIX)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No portion of the route value may resolve to the 7 character sequence __CRA__");
        }
        if (this.mustMatch != null && !this.mustMatch.matcher(dataValue).matches()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Route value " + dataValue + " does not match " + ROUTER_MUST_MATCH + ": " + this.mustMatch);
        }
        if (cols.stream().filter(x -> !x.contains(UNINITIALIZED)).count() >= (long)this.maxCardinality.intValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Max cardinality " + this.maxCardinality + " reached for Category Routed Alias: " + this.getAliasName());
        }
    }

    private String safeKeyValue(String dataValue) {
        return dataValue.trim().replaceAll("\\W", "_");
    }

    String buildCollectionNameFromValue(String value) {
        return this.aliasName + COLLECTION_INFIX + this.safeKeyValue(value);
    }

    @Override
    public String createCollectionsIfRequired(AddUpdateCommand cmd) {
        SolrQueryRequest req = cmd.getReq();
        SolrCore core = req.getCore();
        CoreContainer coreContainer = core.getCoreContainer();
        CollectionsHandler collectionsHandler = coreContainer.getCollectionsHandler();
        String dataValue = String.valueOf(cmd.getSolrInputDocument().getFieldValue(this.getRouteField()));
        String candidateCollectionName = this.buildCollectionNameFromValue(dataValue);
        try {
            do {
                if (this.getCollectionList(this.parsedAliases).contains(candidateCollectionName)) {
                    return candidateCollectionName;
                }
                MaintainCategoryRoutedAliasCmd.remoteInvoke(collectionsHandler, this.getAliasName(), candidateCollectionName);
                collectionsHandler.getCoreContainer().getZkController().getZkStateReader().aliasesManager.update();
            } while (this.updateParsedCollectionAliases(coreContainer.getZkController()));
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "We need to create a new category routed collection but for unknown reasons were unable to do so.");
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private Integer parseMaxCardinality(String maxCardinality) {
        try {
            return Integer.valueOf(maxCardinality);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.maxCardinality must be a valid Integer, instead got: " + maxCardinality);
        }
    }

    private Pattern compileMustMatch(String mustMatch) {
        try {
            return Pattern.compile(mustMatch);
        }
        catch (PatternSyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.mustMatch must be a valid regular expression, instead got: " + mustMatch);
        }
    }

    private List<String> getCollectionList(Aliases p) {
        return (List)p.getCollectionAliasListMap().get(this.aliasName);
    }

    @Override
    public String computeInitialCollectionName() {
        return this.buildCollectionNameFromValue(UNINITIALIZED);
    }

    @Override
    public Map<String, String> getAliasMetadata() {
        return this.aliasMetadata;
    }

    @Override
    public Set<String> getRequiredParams() {
        return REQUIRED_ROUTER_PARAMS;
    }

    @Override
    public Set<String> getOptionalParams() {
        return OPTIONAL_ROUTER_PARAMS;
    }
}

