/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.Set;
import org.apache.solr.util.stats.MetricUtils;

public interface SolrInfoBean {
    public String getName();

    public String getDescription();

    public Category getCategory();

    default public Map<String, Object> getMetricsSnapshot() {
        if (this.getMetricRegistry() == null || this.getMetricNames() == null) {
            return null;
        }
        return MetricUtils.convertMetrics(this.getMetricRegistry(), this.getMetricNames());
    }

    default public Set<String> getMetricNames() {
        return null;
    }

    default public MetricRegistry getMetricRegistry() {
        return null;
    }

    default public void registerMetricName(String name) {
        Set<String> names = this.getMetricNames();
        if (names != null) {
            names.add(name);
        }
    }

    public static enum Group {
        jvm,
        jetty,
        node,
        core,
        collection,
        shard,
        cluster,
        overseer;

    }

    public static enum Category {
        CONTAINER,
        ADMIN,
        CORE,
        QUERY,
        UPDATE,
        CACHE,
        HIGHLIGHTER,
        QUERYPARSER,
        SPELLCHECKER,
        SEARCHER,
        REPLICATION,
        TLOG,
        INDEX,
        DIRECTORY,
        HTTP,
        SECURITY,
        OTHER;

    }
}

