/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.database.DataManager;
import org.traccar.model.BaseModel;

public class BaseObjectManager<T extends BaseModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseObjectManager.class);
    private final DataManager dataManager;
    private Map<Long, T> items;
    private Class<T> baseClass;

    protected BaseObjectManager(DataManager dataManager, Class<T> baseClass) {
        this.dataManager = dataManager;
        this.baseClass = baseClass;
        this.refreshItems();
    }

    protected final DataManager getDataManager() {
        return this.dataManager;
    }

    protected final Class<T> getBaseClass() {
        return this.baseClass;
    }

    public T getById(long itemId) {
        return (T)((BaseModel)this.items.get(itemId));
    }

    public void refreshItems() {
        if (this.dataManager != null) {
            try {
                Collection<T> databaseItems = this.dataManager.getObjects(this.baseClass);
                if (this.items == null) {
                    this.items = new ConcurrentHashMap<Long, T>(databaseItems.size());
                }
                HashSet<Long> databaseItemIds = new HashSet<Long>();
                for (BaseModel item : databaseItems) {
                    databaseItemIds.add(item.getId());
                    if (this.items.containsKey(item.getId())) {
                        this.updateCachedItem(item);
                        continue;
                    }
                    this.addNewItem(item);
                }
                for (Long cachedItemId : this.items.keySet()) {
                    if (databaseItemIds.contains(cachedItemId)) continue;
                    this.removeCachedItem(cachedItemId);
                }
            }
            catch (SQLException error) {
                LOGGER.warn("Error refreshing items", (Throwable)error);
            }
        }
    }

    protected void addNewItem(T item) {
        this.items.put(((BaseModel)item).getId(), item);
    }

    public void addItem(T item) throws SQLException {
        this.dataManager.addObject((BaseModel)item);
        this.addNewItem(item);
    }

    protected void updateCachedItem(T item) {
        this.items.put(((BaseModel)item).getId(), item);
    }

    public void updateItem(T item) throws SQLException {
        this.dataManager.updateObject((BaseModel)item);
        this.updateCachedItem(item);
    }

    protected void removeCachedItem(long itemId) {
        this.items.remove(itemId);
    }

    public void removeItem(long itemId) throws SQLException {
        T item = this.getById(itemId);
        if (item != null) {
            this.dataManager.removeObject(this.baseClass, itemId);
            this.removeCachedItem(itemId);
        }
    }

    public final Collection<T> getItems(Set<Long> itemIds) {
        LinkedList<T> result = new LinkedList<T>();
        for (long itemId : itemIds) {
            result.add(this.getById(itemId));
        }
        return result;
    }

    public Set<Long> getAllItems() {
        return this.items.keySet();
    }
}

