/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import java.util.HashMap;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;

public class CssAttr
extends CssCheckableValue {
    public static HashMap<CssIdent, Integer> typeMap;
    public static final int type = 20;
    ApplContext ac;
    int computed_type = -1;
    CssValue value = null;
    CssValue value_type = null;
    CssValue fallback_value = null;
    String _ts = null;

    @Override
    public final int getRawType() {
        return 20;
    }

    @Override
    public final int getType() {
        if (this.computed_type == -1) {
            return 20;
        }
        return this.computed_type;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", s, ac);
    }

    @Override
    public void setValue(BigDecimal d) {
    }

    public void setValue(CssExpression exp, ApplContext ac) throws InvalidParamException {
        int count = exp.getCount();
        if (count > 3 || count > 1 && ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), "attr()", ac);
        }
        this.value = val;
        this.computed_type = 1;
        exp.next();
        while (!exp.end()) {
            val = exp.getValue();
            switch (op) {
                case ' ': {
                    if (this.fallback_value != null || this.value_type != null) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    if (val.getType() == 0) {
                        this.computed_type = this._checkType((CssIdent)val);
                        this.value_type = val;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), "attr()", ac);
                }
                case ',': {
                    this.fallback_value = val;
                    if (this.fallback_value.getType() == this.computed_type) break;
                    int fb_type = this.fallback_value.getType();
                    if (fb_type == 5) {
                        this.fallback_value.getCheckableValue().checkEqualsZero(ac, "");
                    }
                    if (!(fb_type != 4 && fb_type != 5 || this.computed_type != 6 && this.computed_type != 7 && this.computed_type != 9 && this.computed_type != 5 && this.computed_type != 8)) break;
                    throw new InvalidParamException("typevaluemismatch", this.fallback_value, this.value_type, ac);
                }
                default: {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
            }
            op = exp.getOperator();
            exp.next();
        }
    }

    private int _checkType(CssIdent ident) throws InvalidParamException {
        Integer t = typeMap.get(ident);
        if (t == null) {
            throw new InvalidParamException("invalidtype", ident.toString(), "attr()", this.ac);
        }
        return t;
    }

    @Override
    public Object get() {
        return this.toString();
    }

    public String toString() {
        if (this._ts == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("attr(").append(this.value);
            if (this.value_type != null) {
                sb.append(' ').append(this.value_type);
            }
            if (this.fallback_value != null) {
                sb.append(", ").append(this.fallback_value);
            }
            sb.append(')');
            this._ts = sb.toString();
        }
        return this._ts;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public boolean isStrictlyPositive() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssAttr && this.toString().equals(((CssAttr)value).toString());
    }

    @Override
    public void checkPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void checkInteger(ApplContext ac, String callername) throws InvalidParamException {
    }

    @Override
    public void warnPositiveness(ApplContext ac, CssProperty property) {
    }

    @Override
    public CssLength getLength() throws InvalidParamException {
        if (this.computed_type == 6) {
            // empty if block
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        if (this.computed_type == 4) {
            // empty if block
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssNumber getNumber() throws InvalidParamException {
        if (this.computed_type == 5) {
            // empty if block
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssTime getTime() throws InvalidParamException {
        if (this.computed_type == 8) {
            // empty if block
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssAngle getAngle() throws InvalidParamException {
        if (this.computed_type == 7) {
            // empty if block
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssFrequency getFrequency() throws InvalidParamException {
        if (this.computed_type == 9) {
            // empty if block
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.warnEqualsZero(ac, callername);
    }

    @Override
    public void warnEqualsZero(ApplContext ac, String callername) {
        if (!this.isZero()) {
            ac.getFrame().addWarning("dynamic", new String[]{this.toString(), callername});
        }
    }

    static {
        String[] _frequency_tokens;
        String[] _time_tokens;
        String[] _angle_tokens;
        String[] _length_tokens;
        typeMap = new HashMap();
        typeMap.put(CssIdent.getIdent("color"), 3);
        typeMap.put(CssIdent.getIdent("string"), 1);
        typeMap.put(CssIdent.getIdent("url"), 2);
        typeMap.put(CssIdent.getIdent("integer"), 5);
        typeMap.put(CssIdent.getIdent("number"), 5);
        typeMap.put(CssIdent.getIdent("%"), 4);
        for (String s : _length_tokens = new String[]{"length", "em", "ex", "ch", "rem", "vw", "vh", "vmin", "vmax", "mm", "cm", "q", "in", "pt", "pc", "px"}) {
            typeMap.put(CssIdent.getIdent(s), 6);
        }
        for (String s : _angle_tokens = new String[]{"angle", "deg", "rad", "grad", "turn"}) {
            typeMap.put(CssIdent.getIdent(s), 7);
        }
        for (String s : _time_tokens = new String[]{"time", "ms", "s"}) {
            typeMap.put(CssIdent.getIdent(s), 8);
        }
        for (String s : _frequency_tokens = new String[]{"frequency", "Hz", "kHz"}) {
            typeMap.put(CssIdent.getIdent(s), 9);
        }
    }
}

