/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Desktop;
import java.net.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;

public class DesktopUtils {
    private static BrowserInvoker DEFAULT_INVOKER = BrowserInvoker.desktop;
    private static BrowserInvoker invoker;
    private static BrowserLauncher launcher;
    private static Logger log;

    public static boolean openUrlInBrowser(URI uri) {
        try {
            switch (DesktopUtils.getInvoker()) {
                case desktop: {
                    if (!Desktop.isDesktopSupported()) break;
                    Desktop.getDesktop().browse(uri);
                    return true;
                }
                case browserlauncher: {
                    DesktopUtils.getBrowserLauncher().openURLinBrowser(uri.toString());
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            invoker = BrowserInvoker.none;
        }
        return false;
    }

    public static boolean openUrlInBrowser(String uri) {
        try {
            return DesktopUtils.openUrlInBrowser(new URI(uri));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            invoker = BrowserInvoker.none;
            return false;
        }
    }

    public static boolean openUrlInBrowser(org.apache.commons.httpclient.URI uri) {
        try {
            return DesktopUtils.openUrlInBrowser(uri.toString());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            invoker = BrowserInvoker.none;
            return false;
        }
    }

    public static boolean canOpenUrlInBrowser() {
        switch (DesktopUtils.getInvoker()) {
            case desktop: {
                return Desktop.isDesktopSupported();
            }
            case browserlauncher: {
                return true;
            }
            case none: {
                return false;
            }
        }
        return false;
    }

    private static BrowserInvoker getInvoker() {
        if (invoker == null) {
            try {
                invoker = BrowserInvoker.valueOf(Model.getSingleton().getOptionsParam().getConfig().getString("TBA", DEFAULT_INVOKER.name()));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                invoker = DEFAULT_INVOKER;
            }
        }
        return invoker;
    }

    private static BrowserLauncher getBrowserLauncher() throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        if (launcher == null) {
            DesktopUtils.createBrowserLauncher();
        }
        return launcher;
    }

    private static synchronized void createBrowserLauncher() throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        if (launcher == null) {
            launcher = new BrowserLauncher();
        }
    }

    static {
        DEFAULT_INVOKER = Desktop.isDesktopSupported() ? BrowserInvoker.desktop : BrowserInvoker.browserlauncher;
        invoker = null;
        launcher = null;
        log = Logger.getLogger(DesktopUtils.class);
    }

    private static enum BrowserInvoker {
        desktop,
        browserlauncher,
        none;

    }
}

