/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Producer;
import org.apache.camel.builder.ExpressionClauseSupport;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NotifyBuilder.class);
    private final CamelContext context;
    private final EventNotifier eventNotifier;
    private final List<EventPredicateHolder> predicates = new ArrayList<EventPredicateHolder>();
    private CountDownLatch latch = new CountDownLatch(1);
    private final List<EventPredicate> stack = new ArrayList<EventPredicate>();
    private EventOperation operation;
    private boolean created;
    private int wereSentToIndex;
    private volatile boolean matches;

    public NotifyBuilder(CamelContext context) {
        this.context = context;
        this.eventNotifier = new ExchangeNotifier();
        try {
            ServiceHelper.startService(this.eventNotifier);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        context.getManagementStrategy().addEventNotifier(this.eventNotifier);
    }

    public NotifyBuilder from(final String endpointUri) {
        this.stack.add(new EventPredicateSupport(){

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public boolean onExchange(Exchange exchange) {
                return EndpointHelper.matchEndpoint(NotifyBuilder.this.context, exchange.getFromEndpoint().getEndpointUri(), endpointUri);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "from(" + endpointUri + ")";
            }
        });
        return this;
    }

    public NotifyBuilder fromRoute(final String routeId) {
        this.stack.add(new EventPredicateSupport(){

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public boolean onExchange(Exchange exchange) {
                String id = EndpointHelper.getRouteIdFromEndpoint(exchange.getFromEndpoint());
                if (id == null) {
                    id = exchange.getFromRouteId();
                }
                return EndpointHelper.matchPattern(id, routeId);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "fromRoute(" + routeId + ")";
            }
        });
        return this;
    }

    private NotifyBuilder fromRoutesOnly() {
        this.stack.add(0, new EventPredicateSupport(){

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public boolean onExchange(Exchange exchange) {
                if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint() instanceof DirectEndpoint) {
                    return true;
                }
                return EndpointHelper.matchPattern(exchange.getFromRouteId(), "*");
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "";
            }
        });
        return this;
    }

    public NotifyBuilder filter(final Predicate predicate) {
        this.stack.add(new EventPredicateSupport(){

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public boolean onExchange(Exchange exchange) {
                return predicate.matches(exchange);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "filter(" + predicate + ")";
            }
        });
        return this;
    }

    public ExpressionClauseSupport<NotifyBuilder> filter() {
        final ExpressionClauseSupport<NotifyBuilder> clause = new ExpressionClauseSupport<NotifyBuilder>(this);
        this.stack.add(new EventPredicateSupport(){

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public boolean onExchange(Exchange exchange) {
                Expression exp = clause.createExpression(exchange.getContext());
                return exp.evaluate(exchange, Boolean.class);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "filter(" + clause + ")";
            }
        });
        return clause;
    }

    public NotifyBuilder wereSentTo(final String endpointUri) {
        this.stack.add(this.wereSentToIndex++, new EventPredicateSupport(){
            private ConcurrentMap<String, String> sentTo = new ConcurrentHashMap<String, String>();

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public boolean onExchangeSent(Exchange exchange, Endpoint endpoint, long timeTaken) {
                if (EndpointHelper.matchEndpoint(NotifyBuilder.this.context, endpoint.getEndpointUri(), endpointUri)) {
                    this.sentTo.put(exchange.getExchangeId(), exchange.getExchangeId());
                }
                return this.onExchange(exchange);
            }

            @Override
            public boolean onExchange(Exchange exchange) {
                String sent = (String)this.sentTo.get(exchange.getExchangeId());
                return sent != null;
            }

            @Override
            public boolean matches() {
                return true;
            }

            @Override
            public void reset() {
                this.sentTo.clear();
            }

            public String toString() {
                return "wereSentTo(" + endpointUri + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenReceived(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() >= number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenReceived(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenDone(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private final AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() >= number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenDone(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenDoneByIndex(final int index) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();
            private String id;
            private AtomicBoolean done = new AtomicBoolean();

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (this.current.get() == index) {
                    this.id = exchange.getExchangeId();
                }
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (exchange.getExchangeId().equals(this.id)) {
                    this.done.set(true);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (exchange.getExchangeId().equals(this.id)) {
                    this.done.set(true);
                }
                return true;
            }

            @Override
            public boolean matches() {
                return this.done.get();
            }

            @Override
            public void reset() {
                this.current.set(0);
                this.id = null;
                this.done.set(false);
            }

            public String toString() {
                return "whenDoneByIndex(" + index + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenCompleted(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() >= number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenCompleted(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenFailed(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() >= number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenFailed(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenExactlyDone(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() == number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenExactlyDone(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenExactlyCompleted(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() == number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenExactlyCompleted(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenExactlyFailed(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                this.current.incrementAndGet();
                return true;
            }

            @Override
            public boolean matches() {
                return this.current.get() == number;
            }

            @Override
            public void reset() {
                this.current.set(0);
            }

            public String toString() {
                return "whenExactlyFailed(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenAnyReceivedMatches(Predicate predicate) {
        return this.doWhenAnyMatches(predicate, true);
    }

    public NotifyBuilder whenAnyDoneMatches(Predicate predicate) {
        return this.doWhenAnyMatches(predicate, false);
    }

    private NotifyBuilder doWhenAnyMatches(final Predicate predicate, final boolean received) {
        this.stack.add(new EventPredicateSupport(){
            private final AtomicBoolean matches = new AtomicBoolean();

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received && !this.matches.get()) {
                    this.matches.set(predicate.matches(exchange));
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received && !this.matches.get()) {
                    this.matches.set(predicate.matches(exchange));
                }
                return true;
            }

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received && !this.matches.get()) {
                    this.matches.set(predicate.matches(exchange));
                }
                return true;
            }

            @Override
            public boolean matches() {
                return this.matches.get();
            }

            @Override
            public void reset() {
                this.matches.set(false);
            }

            public String toString() {
                if (received) {
                    return "whenAnyReceivedMatches(" + predicate + ")";
                }
                return "whenAnyDoneMatches(" + predicate + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenAllReceivedMatches(Predicate predicate) {
        return this.doWhenAllMatches(predicate, true);
    }

    public NotifyBuilder whenAllDoneMatches(Predicate predicate) {
        return this.doWhenAllMatches(predicate, false);
    }

    private NotifyBuilder doWhenAllMatches(final Predicate predicate, final boolean received) {
        this.stack.add(new EventPredicateSupport(){
            private final AtomicBoolean matches = new AtomicBoolean(true);

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received && this.matches.get()) {
                    this.matches.set(predicate.matches(exchange));
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received && this.matches.get()) {
                    this.matches.set(predicate.matches(exchange));
                }
                return true;
            }

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received && this.matches.get()) {
                    this.matches.set(predicate.matches(exchange));
                }
                return true;
            }

            @Override
            public boolean matches() {
                return this.matches.get();
            }

            @Override
            public void reset() {
                this.matches.set(true);
            }

            public String toString() {
                if (received) {
                    return "whenAllReceivedMatches(" + predicate + ")";
                }
                return "whenAllDoneMatches(" + predicate + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenDoneSatisfied(MockEndpoint mock) {
        return this.doWhenSatisfied(mock, false);
    }

    public NotifyBuilder whenReceivedSatisfied(MockEndpoint mock) {
        return this.doWhenSatisfied(mock, true);
    }

    private NotifyBuilder doWhenSatisfied(final MockEndpoint mock, final boolean received) {
        this.stack.add(new EventPredicateSupport(){
            private Producer producer;

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            private void sendToMock(Exchange exchange) {
                try {
                    if (this.producer == null) {
                        this.producer = mock.createProducer();
                    }
                    this.producer.process(exchange);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public boolean matches() {
                try {
                    return mock.await(0L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void reset() {
                mock.reset();
            }

            public String toString() {
                if (received) {
                    return "whenReceivedSatisfied(" + mock + ")";
                }
                return "whenDoneSatisfied(" + mock + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenReceivedNotSatisfied(MockEndpoint mock) {
        return this.doWhenNotSatisfied(mock, true);
    }

    public NotifyBuilder whenDoneNotSatisfied(MockEndpoint mock) {
        return this.doWhenNotSatisfied(mock, false);
    }

    private NotifyBuilder doWhenNotSatisfied(final MockEndpoint mock, final boolean received) {
        this.stack.add(new EventPredicateSupport(){
            private Producer producer;

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            private void sendToMock(Exchange exchange) {
                try {
                    if (this.producer == null) {
                        this.producer = mock.createProducer();
                    }
                    this.producer.process(exchange);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public boolean matches() {
                try {
                    return !mock.await(0L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void reset() {
                mock.reset();
            }

            public String toString() {
                if (received) {
                    return "whenReceivedNotSatisfied(" + mock + ")";
                }
                return "whenDoneNotSatisfied(" + mock + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, true, false);
    }

    public NotifyBuilder whenBodiesDone(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, false, false);
    }

    public NotifyBuilder whenExactBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, true, true);
    }

    public NotifyBuilder whenExactBodiesDone(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, false, true);
    }

    private NotifyBuilder doWhenBodies(final List<?> bodies, final boolean received, final boolean exact) {
        this.stack.add(new EventPredicateSupport(){
            private volatile boolean matches;
            private final AtomicInteger current = new AtomicInteger();

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received) {
                    this.matchBody(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received) {
                    this.matchBody(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received) {
                    this.matchBody(exchange);
                }
                return true;
            }

            private void matchBody(Exchange exchange) {
                if (this.current.incrementAndGet() > bodies.size()) {
                    return;
                }
                Object actual = exchange.getIn().getBody();
                Object expected = bodies.get(this.current.get() - 1);
                this.matches = ObjectHelper.equal(expected, actual);
            }

            @Override
            public boolean matches() {
                if (exact) {
                    return this.matches && this.current.get() == bodies.size();
                }
                return this.matches && this.current.get() >= bodies.size();
            }

            @Override
            public void reset() {
                this.matches = false;
                this.current.set(0);
            }

            public String toString() {
                if (received) {
                    return "" + (exact ? "whenExactBodiesReceived(" : "whenBodiesReceived(") + bodies + ")";
                }
                return "" + (exact ? "whenExactBodiesDone(" : "whenBodiesDone(") + bodies + ")";
            }
        });
        return this;
    }

    public NotifyBuilder and() {
        this.doCreate(EventOperation.and);
        return this;
    }

    public NotifyBuilder or() {
        this.doCreate(EventOperation.or);
        return this;
    }

    public NotifyBuilder not() {
        this.doCreate(EventOperation.not);
        return this;
    }

    public NotifyBuilder create() {
        this.doCreate(EventOperation.and);
        this.created = true;
        return this;
    }

    public boolean matches() {
        if (!this.created) {
            throw new IllegalStateException("NotifyBuilder has not been created. Invoke the create() method before matching.");
        }
        return this.matches;
    }

    public boolean matches(long timeout, TimeUnit timeUnit) {
        if (!this.created) {
            throw new IllegalStateException("NotifyBuilder has not been created. Invoke the create() method before matching.");
        }
        try {
            this.latch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return this.matches();
    }

    public boolean matchesMockWaitTime() {
        if (!this.created) {
            throw new IllegalStateException("NotifyBuilder has not been created. Invoke the create() method before matching.");
        }
        long timeout = 0L;
        for (Endpoint endpoint : this.context.getEndpoints()) {
            long waitTime;
            if (!(endpoint instanceof MockEndpoint) || (waitTime = ((MockEndpoint)endpoint).getResultWaitTime()) <= 0L) continue;
            timeout = Math.max(timeout, waitTime);
        }
        if (timeout == 0L) {
            timeout = 10000L;
        }
        return this.matches(timeout, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        for (EventPredicateHolder predicate : this.predicates) {
            predicate.reset();
        }
        this.latch = new CountDownLatch(1);
        this.matches = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (EventPredicateHolder eventPredicateHolder : this.predicates) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(eventPredicateHolder.toString());
        }
        return ObjectHelper.after(sb.toString(), "().");
    }

    private void doCreate(EventOperation newOperation) {
        if (this.operation == null) {
            EventOperation eventOperation = this.operation = newOperation == EventOperation.or ? EventOperation.or : EventOperation.and;
        }
        if (!this.stack.isEmpty()) {
            this.fromRoutesOnly();
            boolean found = false;
            for (EventPredicate predicate : this.stack) {
                if (predicate.isAbstract()) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("NotifyBuilder must contain at least one non-abstract predicate (such as whenDone)");
            }
            CompoundEventPredicate compound = new CompoundEventPredicate(this.stack);
            this.stack.clear();
            this.predicates.add(new EventPredicateHolder(this.operation, compound));
        }
        this.operation = newOperation;
        this.wereSentToIndex = 0;
    }

    private final class CompoundEventPredicate
    implements EventPredicate {
        private List<EventPredicate> predicates = new ArrayList<EventPredicate>();

        private CompoundEventPredicate(List<EventPredicate> predicates) {
            this.predicates.addAll(predicates);
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean matches() {
            for (EventPredicate predicate : this.predicates) {
                boolean answer = predicate.matches();
                LOG.trace("matches() {} -> {}", (Object)predicate, (Object)answer);
                if (answer) continue;
                return false;
            }
            return true;
        }

        @Override
        public void reset() {
            for (EventPredicate predicate : this.predicates) {
                LOG.trace("reset() {}", (Object)predicate);
                predicate.reset();
            }
        }

        @Override
        public boolean onExchangeCreated(Exchange exchange) {
            for (EventPredicate predicate : this.predicates) {
                boolean answer = predicate.onExchangeCreated(exchange);
                LOG.trace("onExchangeCreated() {} -> {}", (Object)predicate, (Object)answer);
                if (answer) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean onExchangeCompleted(Exchange exchange) {
            for (EventPredicate predicate : this.predicates) {
                boolean answer = predicate.onExchangeCompleted(exchange);
                LOG.trace("onExchangeCompleted() {} -> {}", (Object)predicate, (Object)answer);
                if (answer) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean onExchangeFailed(Exchange exchange) {
            for (EventPredicate predicate : this.predicates) {
                boolean answer = predicate.onExchangeFailed(exchange);
                LOG.trace("onExchangeFailed() {} -> {}", (Object)predicate, (Object)answer);
                if (answer) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean onExchangeSent(Exchange exchange, Endpoint endpoint, long timeTaken) {
            for (EventPredicate predicate : this.predicates) {
                boolean answer = predicate.onExchangeSent(exchange, endpoint, timeTaken);
                LOG.trace("onExchangeSent() {} {} -> {}", endpoint, predicate, answer);
                if (answer) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (EventPredicate eventPredicate : this.predicates) {
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(eventPredicate.toString());
            }
            return sb.toString();
        }
    }

    private final class EventPredicateHolder {
        private final EventOperation operation;
        private final EventPredicate predicate;

        private EventPredicateHolder(EventOperation operation, EventPredicate predicate) {
            this.operation = operation;
            this.predicate = predicate;
        }

        public EventOperation getOperation() {
            return this.operation;
        }

        public EventPredicate getPredicate() {
            return this.predicate;
        }

        public void reset() {
            this.predicate.reset();
        }

        public String toString() {
            return this.operation.name() + "()." + this.predicate;
        }
    }

    private abstract class EventPredicateSupport
    implements EventPredicate {
        private EventPredicateSupport() {
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public boolean onExchangeCreated(Exchange exchange) {
            return this.onExchange(exchange);
        }

        @Override
        public boolean onExchangeCompleted(Exchange exchange) {
            return this.onExchange(exchange);
        }

        @Override
        public boolean onExchangeFailed(Exchange exchange) {
            return this.onExchange(exchange);
        }

        @Override
        public boolean onExchangeSent(Exchange exchange, Endpoint endpoint, long timeTaken) {
            return true;
        }

        public boolean onExchange(Exchange exchange) {
            return true;
        }
    }

    private static interface EventPredicate {
        public boolean matches();

        public void reset();

        public boolean isAbstract();

        public boolean onExchangeCreated(Exchange var1);

        public boolean onExchangeCompleted(Exchange var1);

        public boolean onExchangeFailed(Exchange var1);

        public boolean onExchangeSent(Exchange var1, Endpoint var2, long var3);
    }

    private static enum EventOperation {
        and,
        or,
        not;

    }

    private final class ExchangeNotifier
    extends EventNotifierSupport {
        private ExchangeNotifier() {
        }

        @Override
        public void notify(EventObject event) throws Exception {
            if (event instanceof ExchangeCreatedEvent) {
                this.onExchangeCreated((ExchangeCreatedEvent)event);
            } else if (event instanceof ExchangeCompletedEvent) {
                this.onExchangeCompleted((ExchangeCompletedEvent)event);
            } else if (event instanceof ExchangeFailedEvent) {
                this.onExchangeFailed((ExchangeFailedEvent)event);
            } else if (event instanceof ExchangeSentEvent) {
                this.onExchangeSent((ExchangeSentEvent)event);
            }
            this.computeMatches();
        }

        @Override
        public boolean isEnabled(EventObject event) {
            return true;
        }

        private void onExchangeCreated(ExchangeCreatedEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeCreated(event.getExchange());
            }
        }

        private void onExchangeCompleted(ExchangeCompletedEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeCompleted(event.getExchange());
            }
        }

        private void onExchangeFailed(ExchangeFailedEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeFailed(event.getExchange());
            }
        }

        private void onExchangeSent(ExchangeSentEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeSent(event.getExchange(), event.getEndpoint(), event.getTimeTaken());
            }
        }

        private synchronized void computeMatches() {
            Boolean answer = null;
            for (EventPredicateHolder holder : NotifyBuilder.this.predicates) {
                EventOperation operation = holder.getOperation();
                if (EventOperation.and == operation) {
                    if (holder.getPredicate().matches()) {
                        answer = true;
                        continue;
                    }
                    answer = false;
                    break;
                }
                if (EventOperation.or == operation) {
                    if (!holder.getPredicate().matches()) continue;
                    answer = true;
                    continue;
                }
                if (EventOperation.not != operation) continue;
                if (holder.getPredicate().matches()) {
                    answer = false;
                    break;
                }
                answer = true;
            }
            if (answer != null) {
                NotifyBuilder.this.matches = answer;
                if (NotifyBuilder.this.matches) {
                    NotifyBuilder.this.latch.countDown();
                }
            }
        }

        @Override
        protected void doStart() throws Exception {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreRouteEvents(true);
            this.setIgnoreServiceEvents(true);
        }

        @Override
        protected void doStop() throws Exception {
        }
    }
}

