/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.epubpackage;

import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.epubpackage.MetadataElement;
import com.adobe.epubcheck.ctc.epubpackage.PackageManifest;
import com.adobe.epubcheck.ctc.epubpackage.PackageMetadata;
import com.adobe.epubcheck.ctc.epubpackage.PackageSpine;
import com.adobe.epubcheck.ctc.epubpackage.SpineItem;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.PathUtil;
import java.io.File;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;

public class EpubPackage {
    private String packageMainFilePath;
    private ZipFile zip;
    private Document packDoc;
    private String packageMainPath = "";
    private PackageManifest manifest = new PackageManifest();
    private PackageSpine spine = new PackageSpine();
    private PackageMetadata metadata = new PackageMetadata();
    private EPUBVersion version;
    private final String fileName;

    public String getFileName() {
        return this.fileName;
    }

    public Document getPackDoc() {
        return this.packDoc;
    }

    void setPackDoc(Document packDoc) {
        this.packDoc = packDoc;
    }

    public PackageMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(PackageMetadata metadata) {
        this.metadata = metadata;
    }

    public EPUBVersion getVersion() {
        return this.version;
    }

    public void setVersion(EPUBVersion version) {
        this.version = version;
    }

    public EpubPackage(String packageMainFile, ZipFile zip, Document doc) {
        this.setPackageMainFile(packageMainFile);
        this.setZip(zip);
        this.setPackDoc(doc);
        if (packageMainFile.lastIndexOf(47) > 0) {
            this.setPackageMainPath(packageMainFile.substring(0, packageMainFile.lastIndexOf(47)));
        }
        this.setManifest(new PackageManifest());
        this.setSpine(new PackageSpine());
        File file = new File(zip.getName());
        this.fileName = file.getName();
    }

    public String getPackageMainFile() {
        return this.packageMainFilePath;
    }

    public void setPackageMainFile(String packageMainFile) {
        this.packageMainFilePath = packageMainFile;
    }

    public String getPackageMainPath() {
        return this.packageMainPath;
    }

    void setPackageMainPath(String packageMainPath) {
        this.packageMainPath = packageMainPath;
    }

    public PackageManifest getManifest() {
        return this.manifest;
    }

    public void setManifest(PackageManifest manifest) {
        this.manifest = manifest;
    }

    public PackageSpine getSpine() {
        return this.spine;
    }

    public void setSpine(PackageSpine spine) {
        this.spine = spine;
    }

    public ZipFile getZip() {
        return this.zip;
    }

    void setZip(ZipFile zip) {
        this.zip = zip;
    }

    public boolean isSpineItem(String id) {
        if (id == null || id.equals("")) {
            return false;
        }
        for (SpineItem item : this.spine.getItems()) {
            if (!id.equals(item.getIdref())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGlobalFixed(EpubPackage epack) {
        for (MetadataElement me : epack.getMetadata().getMetaElements()) {
            String property;
            if ("rendition:layout".equals(me.getName())) {
                return "pre-paginated".equals(me.getValue());
            }
            if (!"meta".equals(me.getName()) || !"rendition:layout".equals(property = me.getAttribute("property"))) continue;
            return "pre-paginated".equals(me.getValue());
        }
        return false;
    }

    public String getManifestItemFileName(ManifestItem mi) {
        if (mi != null) {
            return this.getManifestItemFileName(mi.getHref());
        }
        return "";
    }

    public String getManifestItemFileName(String entryName) {
        if (entryName == null) {
            return "";
        }
        String fileToParse = this.getPackageMainPath() != null && this.getPackageMainPath().length() > 0 ? PathUtil.resolveRelativeReference(this.getPackageMainFile(), entryName) : entryName;
        int hash = fileToParse.lastIndexOf("#");
        if (hash > 0) {
            fileToParse = fileToParse.substring(0, hash);
        }
        return fileToParse;
    }
}

