/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);

    @Nullable
    public static Integer parseInteger(String text2) {
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text2.substring(2), 4, 32);
                return (int)value;
            }
            if (text2.startsWith(BIN_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text2.substring(2), 1, 32);
                return (int)value;
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                long value = PsiLiteralUtil.parseDigits(text2, 3, 32);
                return (int)value;
            }
            long l = Long.parseLong(text2, 10);
            if (text2.equals(_2_IN_31)) {
                return (int)l;
            }
            long converted = (int)l;
            return l == converted ? Integer.valueOf((int)l) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Long parseLong(String text2) {
        if (StringUtil.endsWithChar(text2, 'L') || StringUtil.endsWithChar(text2, 'l')) {
            text2 = text2.substring(0, text2.length() - 1);
        }
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 4, 64);
            }
            if (text2.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                return PsiLiteralUtil.parseDigits(text2, 3, 64);
            }
            if (_2_IN_63.equals(text2)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text2, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text2) {
        try {
            return Float.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text2) {
        try {
            return Double.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseDigits(String text2, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text2.length();
        if (textLength == 0) {
            throw new NumberFormatException(text2);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text2.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text2);
        }
        int lastDigit = Character.digit(text2.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text2);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @NotNull
    public static String stringForCharLiteral(@NotNull String charLiteral) {
        if (charLiteral == null) {
            PsiLiteralUtil.$$$reportNull$$$0(0);
        }
        if ("'\"'".equals(charLiteral)) {
            if ("\"\\\"\"" == null) {
                PsiLiteralUtil.$$$reportNull$$$0(1);
            }
            return "\"\\\"\"";
        }
        if ("'\\''".equals(charLiteral)) {
            if ("\"'\"" == null) {
                PsiLiteralUtil.$$$reportNull$$$0(2);
            }
            return "\"'\"";
        }
        String string = '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
        if (string == null) {
            PsiLiteralUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isUnsafeLiteral(PsiLiteralExpression expression2) {
        PsiElement literal = expression2.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type2 = ((PsiJavaToken)literal).getTokenType();
        return (type2 == JavaTokenType.CHARACTER_LITERAL || type2 == JavaTokenType.STRING_LITERAL) && expression2.getValue() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stringForCharLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringForCharLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

