/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerStage;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckArguments;", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "resolve"})
public final class CheckArguments
extends CheckerStage {
    public static final CheckArguments INSTANCE;

    @Override
    public void check(@NotNull Candidate candidate2, @NotNull CheckerSink sink, @NotNull CallInfo callInfo) {
        Map<FirExpression, FirValueParameter> argumentMapping;
        Intrinsics.checkParameterIsNotNull((Object)candidate2, (String)"candidate");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
        Map<FirExpression, FirValueParameter> map2 = candidate2.getArgumentMapping();
        if (map2 == null) {
            throw (Throwable)new IllegalStateException("Argument should be already mapped while checking arguments!");
        }
        Map<FirExpression, FirValueParameter> map3 = argumentMapping = map2;
        boolean bl = false;
        Iterator<Map.Entry<FirExpression, FirValueParameter>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<FirExpression, FirValueParameter> entry;
            Map.Entry<FirExpression, FirValueParameter> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            FirExpression argument = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            FirValueParameter parameter2 = entry2.getValue();
            ArgumentsKt.resolveArgument(candidate2, argument, parameter2, false, callInfo.getTypeProvider(), sink);
        }
        if (candidate2.getSystem().getHasContradiction()) {
            sink.reportApplicability(CandidateApplicability.INAPPLICABLE);
        }
    }

    private CheckArguments() {
    }

    static {
        CheckArguments checkArguments;
        INSTANCE = checkArguments = new CheckArguments();
    }
}

