/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import java.util.HashSet;
import java.util.Set;

public class RetryUtils {
    static final Set<String> THROTTLING_ERROR_CODES = new HashSet<String>(9);
    static final Set<String> CLOCK_SKEW_ERROR_CODES = new HashSet<String>(6);
    static final Set<String> RETRYABLE_ERROR_CODES = new HashSet<String>(1);
    static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);

    @Deprecated
    public static boolean isRetryableServiceException(AmazonServiceException exception) {
        return RetryUtils.isRetryableServiceException((SdkBaseException)exception);
    }

    public static boolean isRetryableServiceException(SdkBaseException exception) {
        if (!RetryUtils.isAse(exception)) {
            return false;
        }
        AmazonServiceException ase = RetryUtils.toAse(exception);
        return RETRYABLE_STATUS_CODES.contains(ase.getStatusCode()) || RETRYABLE_ERROR_CODES.contains(ase.getErrorCode());
    }

    @Deprecated
    public static boolean isThrottlingException(AmazonServiceException exception) {
        return RetryUtils.isThrottlingException((SdkBaseException)exception);
    }

    public static boolean isThrottlingException(SdkBaseException exception) {
        if (!RetryUtils.isAse(exception)) {
            return false;
        }
        AmazonServiceException ase = RetryUtils.toAse(exception);
        return THROTTLING_ERROR_CODES.contains(ase.getErrorCode()) || ase.getStatusCode() == 429;
    }

    @Deprecated
    public static boolean isRequestEntityTooLargeException(AmazonServiceException exception) {
        return RetryUtils.isRequestEntityTooLargeException((SdkBaseException)exception);
    }

    public static boolean isRequestEntityTooLargeException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RetryUtils.toAse(exception).getStatusCode() == 413;
    }

    @Deprecated
    public static boolean isClockSkewError(AmazonServiceException exception) {
        return RetryUtils.isClockSkewError((SdkBaseException)exception);
    }

    public static boolean isClockSkewError(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && CLOCK_SKEW_ERROR_CODES.contains(RetryUtils.toAse(exception).getErrorCode());
    }

    private static boolean isAse(SdkBaseException e) {
        return e instanceof AmazonServiceException;
    }

    private static AmazonServiceException toAse(SdkBaseException e) {
        return (AmazonServiceException)e;
    }

    static {
        THROTTLING_ERROR_CODES.add("Throttling");
        THROTTLING_ERROR_CODES.add("ThrottlingException");
        THROTTLING_ERROR_CODES.add("ThrottledException");
        THROTTLING_ERROR_CODES.add("ProvisionedThroughputExceededException");
        THROTTLING_ERROR_CODES.add("SlowDown");
        THROTTLING_ERROR_CODES.add("TooManyRequestsException");
        THROTTLING_ERROR_CODES.add("RequestLimitExceeded");
        THROTTLING_ERROR_CODES.add("BandwidthLimitExceeded");
        THROTTLING_ERROR_CODES.add("RequestThrottled");
        CLOCK_SKEW_ERROR_CODES.add("RequestTimeTooSkewed");
        CLOCK_SKEW_ERROR_CODES.add("RequestExpired");
        CLOCK_SKEW_ERROR_CODES.add("InvalidSignatureException");
        CLOCK_SKEW_ERROR_CODES.add("SignatureDoesNotMatch");
        CLOCK_SKEW_ERROR_CODES.add("AuthFailure");
        CLOCK_SKEW_ERROR_CODES.add("RequestInTheFuture");
        RETRYABLE_ERROR_CODES.add("PriorRequestNotComplete");
        RETRYABLE_STATUS_CODES.add(500);
        RETRYABLE_STATUS_CODES.add(502);
        RETRYABLE_STATUS_CODES.add(503);
        RETRYABLE_STATUS_CODES.add(504);
    }
}

