/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.Annotations;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTable;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTypeTable;
import org.jd.core.v1.model.classfile.attribute.AttributeParameterAnnotations;
import org.jd.core.v1.model.classfile.attribute.LocalVariable;
import org.jd.core.v1.model.classfile.attribute.LocalVariableType;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameters;
import org.jd.core.v1.model.javasyntax.expression.AbstractNopExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.Frame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableSet;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.PrimitiveLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.RootFrame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AnnotationConverter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateLocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateParameterVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.GenerateParameterSuffixNameVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBlackListNamesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateTypeVisitor;

public class LocalVariableMaker {
    protected LocalVariableSet localVariableSet = new LocalVariableSet();
    protected HashSet<String> names = new HashSet();
    protected HashSet<String> blackListNames = new HashSet();
    protected Frame currentFrame = new RootFrame();
    protected AbstractLocalVariable[] localVariableCache;
    protected ObjectTypeMaker objectTypeMaker;
    protected SignatureParser signatureParser;
    protected FormalParameters formalParameters;
    protected PopulateBlackListNamesVisitor populateBlackListNamesVisitor = new PopulateBlackListNamesVisitor(this.blackListNames);
    protected UpdateTypeInParameterVisitor updateTypeInParameterVisitor = new UpdateTypeInParameterVisitor();
    protected CreateParameterVisitor createParameterVisitor;
    protected CreateLocalVariableVisitor createLocalVariableVisitor;
    protected UpdateTypeInReturnVisitor updateTypeInReturnVisitor;

    public LocalVariableMaker(ObjectTypeMaker objectTypeMaker, SignatureParser signatureParser, ClassFileConstructorOrMethodDeclaration comdwln, boolean constructor, List<Type> parameterTypes, Type returnedType) {
        ClassFile classFile = comdwln.getClassFile();
        Method method = comdwln.getMethod();
        this.objectTypeMaker = objectTypeMaker;
        this.signatureParser = signatureParser;
        this.createParameterVisitor = new CreateParameterVisitor(objectTypeMaker);
        this.createLocalVariableVisitor = new CreateLocalVariableVisitor(objectTypeMaker);
        this.updateTypeInReturnVisitor = new UpdateTypeInReturnVisitor(returnedType);
        if (classFile.getFields() != null) {
            for (Field field : classFile.getFields()) {
                String descriptor = field.getDescriptor();
                if (descriptor.charAt(descriptor.length() - 1) == ';') {
                    objectTypeMaker.make(descriptor).accept(this.populateBlackListNamesVisitor);
                }
                this.blackListNames.add(field.getName());
            }
        }
        objectTypeMaker.make(classFile.getInternalTypeName()).accept(this.populateBlackListNamesVisitor);
        if (classFile.getSuperTypeName() != null) {
            objectTypeMaker.make(classFile.getSuperTypeName()).accept(this.populateBlackListNamesVisitor);
        }
        if (classFile.getInterfaceTypeNames() != null) {
            for (String interfaceTypeName : classFile.getInterfaceTypeNames()) {
                objectTypeMaker.make(interfaceTypeName).accept(this.populateBlackListNamesVisitor);
            }
        }
        if (parameterTypes != null) {
            for (Type type : parameterTypes) {
                type.accept(this.populateBlackListNamesVisitor);
            }
        }
        this.initLocalVariablesFromAttributes(method);
        int firstVariableIndex = 0;
        if ((method.getAccessFlags() & 8) == 0) {
            if (this.localVariableSet.root(0) == null) {
                this.localVariableSet.add(0, new ObjectLocalVariable(objectTypeMaker, 0, 0, objectTypeMaker.make(classFile.getInternalTypeName()), "this"));
                this.blackListNames.add("this");
            }
            firstVariableIndex = 1;
        }
        if (constructor) {
            if ((classFile.getAccessFlags() & 0x4000) != 0) {
                if (this.localVariableSet.root(1) == null) {
                    this.localVariableSet.add(1, new ObjectLocalVariable(objectTypeMaker, 1, 0, ObjectType.TYPE_STRING, "this$enum$name"));
                    this.blackListNames.add("this$enum$name");
                }
                if (this.localVariableSet.root(2) == null) {
                    this.localVariableSet.add(2, new PrimitiveLocalVariable(2, 0, PrimitiveType.TYPE_INT, "this$enum$index"));
                    this.blackListNames.add("this$enum$index");
                }
            } else if (classFile.getOuterClassFile() != null && (classFile.getAccessFlags() & 8) == 0 && this.localVariableSet.root(1) == null) {
                this.localVariableSet.add(1, new ObjectLocalVariable(objectTypeMaker, 1, 0, objectTypeMaker.make(classFile.getOuterClassFile().getInternalTypeName()), "this$0"));
                this.blackListNames.add("this$0");
            }
        }
        if (parameterTypes != null && !parameterTypes.isEmpty()) {
            int lastParameterIndex = parameterTypes.size() - 1;
            boolean varargs = (method.getAccessFlags() & 0x80) != 0;
            this.initLocalVariablesFromParameterTypes(classFile, parameterTypes, varargs, firstVariableIndex, lastParameterIndex);
            this.formalParameters = new FormalParameters();
            AttributeParameterAnnotations rvpa = (AttributeParameterAnnotations)method.getAttribute("RuntimeVisibleParameterAnnotations");
            AttributeParameterAnnotations ripa = (AttributeParameterAnnotations)method.getAttribute("RuntimeInvisibleParameterAnnotations");
            if (rvpa == null && ripa == null) {
                int parameterIndex = 0;
                int variableIndex = firstVariableIndex;
                while (parameterIndex <= lastParameterIndex) {
                    AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
                    this.formalParameters.add(new FormalParameter(lv.getType(), varargs && parameterIndex == lastParameterIndex, lv.getName()));
                    if (PrimitiveType.TYPE_LONG.equals(lv.getType()) || PrimitiveType.TYPE_DOUBLE.equals(lv.getType())) {
                        ++variableIndex;
                    }
                    ++parameterIndex;
                    ++variableIndex;
                }
            } else {
                Annotations[] visiblesArray = rvpa == null ? null : rvpa.getParameterAnnotations();
                Annotations[] invisiblesArray = ripa == null ? null : ripa.getParameterAnnotations();
                AnnotationConverter annotationConverter = new AnnotationConverter(objectTypeMaker);
                int parameterIndex = 0;
                int variableIndex = firstVariableIndex;
                while (parameterIndex <= lastParameterIndex) {
                    AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
                    Annotations visibles = visiblesArray == null || visiblesArray.length <= parameterIndex ? null : visiblesArray[parameterIndex];
                    Annotations invisibles = invisiblesArray == null || invisiblesArray.length <= parameterIndex ? null : invisiblesArray[parameterIndex];
                    BaseAnnotationReference annotationReferences = annotationConverter.convert(visibles, invisibles);
                    this.formalParameters.add(new FormalParameter(annotationReferences, lv.getType(), varargs && parameterIndex == lastParameterIndex, lv.getName()));
                    if (PrimitiveType.TYPE_LONG.equals(lv.getType()) || PrimitiveType.TYPE_DOUBLE.equals(lv.getType())) {
                        ++variableIndex;
                    }
                    ++parameterIndex;
                    ++variableIndex;
                }
            }
        }
        this.localVariableCache = this.localVariableSet.initialize(this.currentFrame);
    }

    protected void initLocalVariablesFromAttributes(Method method) {
        AttributeCode code = (AttributeCode)method.getAttribute("Code");
        if (code != null) {
            AttributeLocalVariableTypeTable localVariableTypeTable;
            AttributeLocalVariableTable localVariableTable = (AttributeLocalVariableTable)code.getAttribute("LocalVariableTable");
            if (localVariableTable != null) {
                for (LocalVariable localVariable : localVariableTable.getLocalVariableTable()) {
                    int dimension;
                    int index = localVariable.getIndex();
                    int startPc = index == 0 ? 0 : localVariable.getStartPc();
                    String descriptor = localVariable.getDescriptor();
                    String name = localVariable.getName();
                    AbstractLocalVariable lv = descriptor.charAt(descriptor.length() - 1) == ';' ? new ObjectLocalVariable(this.objectTypeMaker, index, startPc, this.objectTypeMaker.make(descriptor), name) : ((dimension = SignatureParser.countDimension(descriptor)) == 0 ? new PrimitiveLocalVariable(index, startPc, descriptor, name) : new ObjectLocalVariable(this.objectTypeMaker, index, startPc, this.signatureParser.parseTypeSignature(descriptor.substring(dimension)).createType(dimension), name));
                    this.localVariableSet.add(index, lv);
                    this.blackListNames.add(name);
                    this.names.add(name);
                }
            }
            if ((localVariableTypeTable = (AttributeLocalVariableTypeTable)code.getAttribute("LocalVariableTypeTable")) != null) {
                UpdateTypeVisitor updateTypeVisitor = new UpdateTypeVisitor(this.localVariableSet);
                for (LocalVariableType lv : localVariableTypeTable.getLocalVariableTypeTable()) {
                    updateTypeVisitor.setLocalVariableType(lv);
                    this.signatureParser.parseTypeSignature(lv.getSignature()).accept(updateTypeVisitor);
                }
            }
        }
    }

    protected void initLocalVariablesFromParameterTypes(ClassFile classFile, List<Type> parameterTypes, boolean varargs, int firstVariableIndex, int lastParameterIndex) {
        HashMap<Type, Boolean> typeMap = new HashMap<Type, Boolean>();
        for (int parameterIndex = 0; parameterIndex <= lastParameterIndex; ++parameterIndex) {
            Type type = parameterTypes.get(parameterIndex);
            if (typeMap.containsKey(type)) {
                typeMap.put(type, Boolean.TRUE);
                continue;
            }
            typeMap.put(type, Boolean.FALSE);
        }
        String parameterNamePrefix = "param";
        if (classFile.getOuterClassFile() != null) {
            int innerTypeDepth = 1;
            ObjectType type = this.objectTypeMaker.make(classFile.getOuterClassFile().getInternalTypeName());
            while (type != null && type.getClass() == InnerObjectType.class) {
                ++innerTypeDepth;
                type = ((InnerObjectType)type).getOuterType();
            }
            parameterNamePrefix = parameterNamePrefix + innerTypeDepth;
        }
        StringBuilder sb = new StringBuilder();
        GenerateParameterSuffixNameVisitor generateParameterSuffixNameVisitor = new GenerateParameterSuffixNameVisitor();
        int parameterIndex = 0;
        int variableIndex = firstVariableIndex;
        while (parameterIndex <= lastParameterIndex) {
            Type type = parameterTypes.get(parameterIndex);
            AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
            if (lv == null) {
                sb.setLength(0);
                sb.append(parameterNamePrefix);
                if (parameterIndex == lastParameterIndex && varargs) {
                    sb.append("VarArgs");
                } else {
                    if (type.getDimension() > 0) {
                        sb.append("ArrayOf");
                    }
                    type.accept(generateParameterSuffixNameVisitor);
                    sb.append(generateParameterSuffixNameVisitor.getSuffix());
                }
                int length = sb.length();
                int counter = 1;
                if (((Boolean)typeMap.get(type)).booleanValue()) {
                    sb.append(counter++);
                }
                String name = sb.toString();
                while (this.blackListNames.contains(name)) {
                    sb.setLength(length);
                    sb.append(counter++);
                    name = sb.toString();
                }
                this.blackListNames.add(name);
                this.createParameterVisitor.init(variableIndex, name);
                type.accept(this.createParameterVisitor);
                AbstractLocalVariable alv = this.createParameterVisitor.getLocalVariable();
                alv.setDeclared(true);
                this.localVariableSet.add(variableIndex, alv);
            }
            if (PrimitiveType.TYPE_LONG.equals(type) || PrimitiveType.TYPE_DOUBLE.equals(type)) {
                ++variableIndex;
            }
            ++parameterIndex;
            ++variableIndex;
        }
    }

    public AbstractLocalVariable getLocalVariable(int index, int offset) {
        AbstractLocalVariable lv = this.localVariableCache[index];
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
            if (lv == null) {
                lv = new ObjectLocalVariable(this.objectTypeMaker, index, offset, ObjectType.TYPE_OBJECT, "SYNTHETIC_LOCAL_VARIABLE_" + index, true);
            }
        } else if (lv.getFrame() != this.currentFrame) {
            Frame frame = this.searchCommonParentFrame(lv.getFrame(), this.currentFrame);
            frame.mergeLocalVariable(lv);
            if (lv.getFrame() != frame) {
                lv.getFrame().removeLocalVariable(lv);
                frame.addLocalVariable(lv);
            }
        }
        lv.setToOffset(offset);
        return lv;
    }

    public AbstractLocalVariable getPrimitiveLocalVariableInAssignment(int index, int offset, Expression value) {
        AbstractLocalVariable lv = this.localVariableSet.remove(index, offset);
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
        }
        if (lv == null) {
            this.createLocalVariableVisitor.init(index, offset);
            if (value.getClass() == ClassFileLocalVariableReferenceExpression.class) {
                ((ClassFileLocalVariableReferenceExpression)value).getLocalVariable().accept(this.createLocalVariableVisitor);
            } else {
                value.getType().accept(this.createLocalVariableVisitor);
            }
            lv = this.createLocalVariableVisitor.getLocalVariable();
        } else if (value.getClass() == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable valueLocalVariable = ((ClassFileLocalVariableReferenceExpression)value).getLocalVariable();
            PrimitiveLocalVariable valuePrimitiveLocalVariable = (PrimitiveLocalVariable)valueLocalVariable;
            if (lv.isAssignable(valuePrimitiveLocalVariable)) {
                lv.leftReduce(valuePrimitiveLocalVariable);
                valuePrimitiveLocalVariable.rightReduce(lv);
            } else {
                this.createLocalVariableVisitor.init(index, offset);
                valuePrimitiveLocalVariable.accept(this.createLocalVariableVisitor);
                lv = this.createLocalVariableVisitor.getLocalVariable();
            }
        } else {
            Type valueType = value.getType();
            if (lv.isAssignable(valueType)) {
                lv.leftReduce(valueType);
            } else {
                this.createLocalVariableVisitor.init(index, offset);
                valueType.accept(this.createLocalVariableVisitor);
                lv = this.createLocalVariableVisitor.getLocalVariable();
            }
        }
        lv.setToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getObjectLocalVariableInAssignment(int index, int offset, Expression value) {
        AbstractLocalVariable lv = this.localVariableSet.remove(index, offset);
        Class<?> valueClass = value.getClass();
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
        }
        if (lv == null) {
            this.createLocalVariableVisitor.init(index, offset);
            if (valueClass == ClassFileLocalVariableReferenceExpression.class) {
                ((ClassFileLocalVariableReferenceExpression)value).getLocalVariable().accept(this.createLocalVariableVisitor);
            } else {
                value.getType().accept(this.createLocalVariableVisitor);
            }
            lv = this.createLocalVariableVisitor.getLocalVariable();
        } else if (valueClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable alv = ((ClassFileLocalVariableReferenceExpression)value).getLocalVariable();
            if (lv.isAssignable(alv)) {
                lv.leftReduce(alv);
                alv.rightReduce(lv);
            } else {
                this.createLocalVariableVisitor.init(index, offset);
                alv.accept(this.createLocalVariableVisitor);
                lv = this.createLocalVariableVisitor.getLocalVariable();
            }
        } else if (valueClass == NullExpression.class) {
            Type type = lv.getType();
            if (type.getDimension() == 0 && type.isPrimitive()) {
                this.createLocalVariableVisitor.init(index, offset);
                value.getType().accept(this.createLocalVariableVisitor);
                lv = this.createLocalVariableVisitor.getLocalVariable();
            } else {
                ((NullExpression)value).setType(lv.getType());
            }
        } else {
            Type valueType = value.getType();
            if (lv.isAssignable(valueType)) {
                lv.leftReduce(valueType);
            } else {
                this.createLocalVariableVisitor.init(index, offset);
                valueType.accept(this.createLocalVariableVisitor);
                lv = this.createLocalVariableVisitor.getLocalVariable();
            }
            if (valueClass == NewExpression.class) {
                this.currentFrame.addNewExpression((NewExpression)value, lv);
            }
        }
        lv.setToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getExceptionLocalVariable(int index, int offset, ObjectType type) {
        AbstractLocalVariable lv;
        if (index == -1) {
            lv = new ObjectLocalVariable(this.objectTypeMaker, index, offset, type, null, true);
            this.currentFrame.setExceptionLocalVariable(lv);
        } else {
            lv = this.currentFrame.getLocalVariable(index);
            if (lv == null) {
                lv = this.localVariableSet.remove(index, offset);
                if (lv == null) {
                    lv = new ObjectLocalVariable(this.objectTypeMaker, index, offset, type, null, true);
                } else {
                    lv.setDeclared(true);
                }
                this.currentFrame.addLocalVariable(lv);
            } else {
                lv.setDeclared(true);
            }
        }
        return lv;
    }

    public void updateTypeInParameter(Expression expression, Type type) {
        this.updateTypeInParameterVisitor.setType(type);
        expression.accept(this.updateTypeInParameterVisitor);
    }

    public void updateTypeInReturn(Expression expression) {
        expression.accept(this.updateTypeInReturnVisitor);
    }

    public void removeLocalVariable(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        if (index < this.localVariableCache.length) {
            this.localVariableCache[index] = null;
            this.currentFrame.removeLocalVariable(lv);
        }
    }

    protected void store(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        if (index >= this.localVariableCache.length) {
            AbstractLocalVariable[] tmp = this.localVariableCache;
            this.localVariableCache = new AbstractLocalVariable[index * 2];
            System.arraycopy(tmp, 0, this.localVariableCache, 0, tmp.length);
        }
        this.localVariableCache[index] = lv;
        if (lv.getFrame() == null) {
            this.currentFrame.addLocalVariable(lv);
        }
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    public void make() {
        this.currentFrame.createNames(this.blackListNames);
        this.currentFrame.createDeclarations();
    }

    public BaseFormalParameter getFormalParameters() {
        return this.formalParameters;
    }

    public void pushFrame(Statements statements) {
        Frame parent = this.currentFrame;
        this.currentFrame = new Frame(this.currentFrame, statements);
        parent.addChild(this.currentFrame);
    }

    public void popFrame() {
        this.currentFrame.close();
        this.currentFrame = this.currentFrame.getParent();
    }

    protected Frame searchCommonParentFrame(Frame frame1, Frame frame2) {
        HashSet<Frame> set = new HashSet<Frame>();
        while (frame1 != null) {
            set.add(frame1);
            frame1 = frame1.getParent();
        }
        while (frame2 != null) {
            if (set.contains(frame2)) {
                return frame2;
            }
            frame2 = frame2.getParent();
        }
        return null;
    }

    protected static class UpdateTypeInReturnVisitor
    extends AbstractNopExpressionVisitor {
        protected Type returnedType;

        public UpdateTypeInReturnVisitor(Type returnedType) {
            this.returnedType = returnedType;
        }

        @Override
        public void visit(LocalVariableReferenceExpression expression) {
            ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable().rightReduce(this.returnedType);
        }
    }

    protected static class UpdateTypeInParameterVisitor
    extends AbstractNopExpressionVisitor {
        protected Type type;

        protected UpdateTypeInParameterVisitor() {
        }

        public void setType(Type type) {
            this.type = type;
        }

        @Override
        public void visit(LocalVariableReferenceExpression expression) {
            ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable().rightReduce(this.type);
        }
    }
}

