/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.kawa.io.InPort;
import gnu.text.SourceLocator;
import gnu.text.SourceMapper;
import java.io.File;
import java.io.IOException;

public class SourceError
extends SourceLocator.Simple {
    public SourceError next;
    public char severity;
    public String code;
    public String message;
    public Throwable fakeException;

    public SourceError(char severity, String filename, int line, int column, String message) {
        this.severity = severity;
        this.filename = filename;
        this.position = SourceMapper.simpleEncode(line, column);
        this.message = message;
    }

    public SourceError(char severity, SourceLocator location2, String message) {
        this(severity, location2.getFileName(), location2.getLineNumber(), location2.getColumnNumber(), message);
    }

    public SourceError(InPort port, char severity, String message) {
        this(severity, port.getName(), SourceError.adjustFromPort(port.getLineNumber()), SourceError.adjustFromPort(port.getColumnNumber()), message);
    }

    private static int adjustFromPort(int portPosition) {
        return portPosition >= 0 ? portPosition + 1 : portPosition;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripDirectories) {
        StringBuilder buffer = new StringBuilder();
        this.appendTo(buffer, stripDirectories, null);
        return buffer.toString();
    }

    public void appendTo(Appendable out, boolean stripDirectories, String newLine) {
        try {
            String fname;
            if (this.filename == null) {
                fname = "<unknown>";
            } else {
                fname = this.filename;
                if (stripDirectories) {
                    fname = new File(fname).getName();
                }
            }
            out.append(fname);
            int line = this.getStartLine();
            int column = this.getStartColumn();
            if (line > 0 || column > 0) {
                out.append(':');
                out.append(Integer.toString(line));
                if (column > 0) {
                    out.append(':');
                    out.append(Integer.toString(column));
                }
            }
            out.append(": ");
            if (this.severity == 'w') {
                out.append("warning - ");
            } else if (this.severity == 'i') {
                out.append("note - ");
            }
            out.append(this.message);
            if (this.code != null) {
                out.append(" [");
                out.append(this.code);
                out.append("]");
            }
            if (this.fakeException != null) {
                StackTraceElement[] stackTrace = this.fakeException.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    out.append(newLine != null ? newLine : "\n");
                    out.append("    ");
                    out.append(stackTrace[i].toString());
                }
            }
            if (newLine != null) {
                out.append(newLine);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void print(Appendable out) {
        this.appendTo(out, false, null);
    }

    public void println(Appendable out, boolean stripDirectories) {
        this.appendTo(out, stripDirectories, System.getProperty("line.separator", "\n"));
    }
}

