/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.Transient;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.collector.SnmpTrapReceiver;
import onl.netfishers.netshot.collector.SyslogServer;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.TaskLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class DeviceDriver
implements Comparable<DeviceDriver> {
    static Logger logger = LoggerFactory.getLogger(DeviceDriver.class);
    private static TaskLogger JS_SNMP_LOGGER = new TaskLogger(){
        Logger snmpLogger = LoggerFactory.getLogger(SnmpTrapReceiver.class);

        @Override
        public void warn(String message) {
            this.snmpLogger.warn("[JSWARN] {}", (Object)message);
        }

        @Override
        public void trace(String message) {
            this.snmpLogger.warn("[JSTRACE] {}", (Object)message);
        }

        @Override
        public void info(String message) {
            this.snmpLogger.warn("[JSINFO] {}", (Object)message);
        }

        @Override
        public void error(String message) {
            this.snmpLogger.warn("[JSERROR] {}", (Object)message);
        }

        @Override
        public void debug(String message) {
            this.snmpLogger.warn("[JSDEBUG] {}", (Object)message);
        }
    };
    private static TaskLogger JS_SYSLOG_LOGGER = new TaskLogger(){
        Logger syslogServer = LoggerFactory.getLogger(SyslogServer.class);

        @Override
        public void warn(String message) {
            this.syslogServer.warn("[JSWARN] {}", (Object)message);
        }

        @Override
        public void trace(String message) {
            this.syslogServer.warn("[JSTRACE] {}", (Object)message);
        }

        @Override
        public void info(String message) {
            this.syslogServer.warn("[JSINFO] {}", (Object)message);
        }

        @Override
        public void error(String message) {
            this.syslogServer.warn("[JSERROR] {}", (Object)message);
        }

        @Override
        public void debug(String message) {
            this.syslogServer.warn("[JSDEBUG] {}", (Object)message);
        }
    };
    private static String JSLOADER;
    private static Map<String, DeviceDriver> drivers;
    private String name;
    private String author;
    private String description;
    private String version;
    private int priority;
    Set<AttributeDefinition> attributes;
    private Set<DriverProtocol> protocols;
    private Set<String> cliMainModes;
    private boolean canAnalyzeTraps;
    private boolean canAnalyzeSyslog;
    private boolean canSnmpAutodiscover;
    private ScriptEngine engine;

    public static List<DeviceDriver> getAllDrivers() {
        ArrayList<DeviceDriver> allDrivers = new ArrayList<DeviceDriver>(drivers.values());
        Collections.sort(allDrivers);
        return allDrivers;
    }

    public static DeviceDriver getDriverByName(String name) {
        if (name == null) {
            return null;
        }
        return drivers.get(name);
    }

    public static Map<String, DeviceDriver> getDrivers() {
        return drivers;
    }

    public static void refreshDrivers() throws Exception {
        HashMap<String, DeviceDriver> drivers = new HashMap<String, DeviceDriver>();
        String addPath = Netshot.getConfig("netshot.drivers.path");
        if (addPath != null) {
            File folder = new File(addPath);
            if (folder != null && folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".js");
                    }
                })) {
                    logger.info("Found user device driver file {}.", (Object)file);
                    try {
                        FileInputStream stream = new FileInputStream(file);
                        DeviceDriver driver = new DeviceDriver(stream);
                        if (drivers.containsKey(driver.getName())) {
                            logger.warn("Skipping user device driver file {}, because a similar driver is already loaded.", (Object)file);
                            continue;
                        }
                        drivers.put(driver.getName(), driver);
                    }
                    catch (Exception e) {
                        logger.error("Error while loading user device driver {}.", (Object)file, (Object)e);
                    }
                }
            } else {
                logger.error("Unable to open {} to find device drivers.", (Object)addPath);
            }
        }
        String driverPathName = "drivers/";
        URL driverUrl = DeviceDriver.class.getResource("/" + driverPathName);
        if (driverUrl != null && "file".equals(driverUrl.getProtocol())) {
            logger.debug("Scanning folder {} for device drivers (.js).", (Object)driverUrl);
            File folder = new File(driverUrl.toURI());
            if (folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".js");
                    }
                })) {
                    logger.info("Found Netshot device driver file {}.", (Object)file);
                    try {
                        InputStream stream = DeviceDriver.class.getResourceAsStream("/" + driverPathName + file.getName());
                        DeviceDriver driver = new DeviceDriver(stream);
                        if (drivers.containsKey(driver.getName())) {
                            logger.warn("Skipping Netshot device driver file {}, because a similar driver is already loaded.", (Object)file);
                            continue;
                        }
                        drivers.put(driver.getName(), driver);
                    }
                    catch (Exception e1) {
                        logger.error("Error while loading the device driver {}.", (Object)file, (Object)e1);
                    }
                }
            }
        }
        if (driverUrl != null && "jar".equals(driverUrl.getProtocol())) {
            String path = driverUrl.getFile();
            path = path.substring(0, path.lastIndexOf(33));
            File file = new File(new URI(path));
            try {
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().startsWith(driverPathName)) continue;
                    logger.info("Found Netshot device driver file {} (in jar).", (Object)file);
                    try {
                        InputStream stream = jar.getInputStream(je);
                        DeviceDriver driver = new DeviceDriver(stream);
                        if (drivers.containsKey(driver.getName())) {
                            logger.warn("Skipping Netshot device driver file {}, because a similar driver is already loaded.", (Object)file);
                            continue;
                        }
                        drivers.put(driver.getName(), driver);
                    }
                    catch (Exception e1) {
                        logger.error("Error while loading the device driver {} from jar file.", (Object)file, (Object)e1);
                    }
                }
                jar.close();
            }
            catch (Exception e) {
                logger.error("While looking for device drivers in {}.", (Object)path, (Object)e);
            }
        }
        DeviceDriver.drivers = drivers;
    }

    protected DeviceDriver() {
        this.attributes = new HashSet<AttributeDefinition>();
        this.protocols = new HashSet<DriverProtocol>();
        this.cliMainModes = new HashSet<String>();
        this.canAnalyzeTraps = true;
        this.canAnalyzeSyslog = true;
        this.canSnmpAutodiscover = true;
    }

    /*
     * Exception decompiling
     */
    protected DeviceDriver(InputStream in) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean analyzeSyslog(String message, Network4Address ip) {
        if (!this.canAnalyzeSyslog) {
            return false;
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_analyzeSyslog", message, JS_SYSLOG_LOGGER);
            if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof ScriptException && e.getMessage() != null && e.getMessage().contains("No analyzeSyslog function.")) {
                logger.info("The driver {} has no analyzeSyslog function. Won't be called again.", (Object)this.name);
                this.canAnalyzeSyslog = false;
            }
            logger.error("Error while running _analyzeSyslog function on driver {}.", (Object)this.name, (Object)e);
        }
        return false;
    }

    public boolean analyzeTrap(Map<String, String> data, Network4Address ip) {
        if (!this.canAnalyzeTraps) {
            return false;
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_analyzeTrap", data, JS_SNMP_LOGGER);
            if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof ScriptException && e.getMessage() != null && e.getMessage().contains("No analyzeTrap function.")) {
                logger.info("The driver {} has no analyzeTrap function. Won't be called again.", (Object)this.name);
                this.canAnalyzeTraps = false;
            }
            logger.error("Error while running _analyzeTrap function on driver {}.", (Object)this.name, (Object)e);
        }
        return false;
    }

    @XmlElement
    public Set<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @XmlElement
    public String getAuthor() {
        return this.author;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    @XmlElement
    public Set<DriverProtocol> getProtocols() {
        return this.protocols;
    }

    @XmlElement
    public Set<String> getCliMainModes() {
        return this.cliMainModes;
    }

    @XmlElement
    public String getVersion() {
        return this.version;
    }

    @XmlElement
    public int getPriority() {
        return this.priority;
    }

    @Transient
    public ScriptEngine getEngine() {
        return this.engine;
    }

    protected void setProtocols(Set<DriverProtocol> protocols) {
        this.protocols = protocols;
    }

    public boolean snmpAutoDiscover(Task task, String sysObjectId, String sysDesc, TaskLogger taskLogger) {
        if (!this.canSnmpAutodiscover) {
            return false;
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_snmpAutoDiscover", sysObjectId, sysDesc, taskLogger);
            if (result != null && result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            if (e instanceof ScriptException && e.getMessage() != null && e.getMessage().contains("No snmpAutoDiscover function.")) {
                logger.info("The driver {} has no snmpAutoDiscover function.", (Object)this.name);
                this.canSnmpAutodiscover = false;
            }
            logger.error("Error while running _identify function on driver {}.", (Object)this.name, (Object)e);
        }
        return false;
    }

    protected void testFunction(String function) throws IllegalArgumentException {
        try {
            ((Invocable)((Object)this.engine)).invokeFunction(function, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The function %s doesn't exist.", function));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeviceDriver [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.author != null) {
            builder.append("author=");
            builder.append(this.author);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        builder.append("version=");
        builder.append(this.version);
        builder.append(", ");
        builder.append("priority=");
        builder.append(Integer.toString(this.priority));
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDriver)) {
            return false;
        }
        DeviceDriver other = (DeviceDriver)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public int compareTo(DeviceDriver o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            return -1;
        }
        int r = Integer.compare(this.priority, o.priority);
        if (r != 0) {
            return -r;
        }
        return this.name.compareTo(o.name);
    }

    static {
        try {
            logger.info("Reading the JavaScript driver loader code from the resource JS file.");
            String path = "interfaces/driver-loader.js";
            InputStream in = DeviceDriver.class.getResourceAsStream("/" + path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            reader.close();
            in.close();
            JSLOADER = buffer.toString();
            logger.debug("The JavaScript driver loader code has been read from the resource JS file.");
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Unable to read the Javascript driver loader.", e);
            System.err.println("NETSHOT FATAL ERROR");
            e.printStackTrace();
            System.exit(1);
        }
        drivers = new HashMap<String, DeviceDriver>();
    }

    public static enum DriverProtocol {
        TELNET("telnet"),
        SSH("ssh"),
        SNMP("snmp");

        private String protocol;

        private DriverProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String value() {
            return this.protocol;
        }
    }
}

