/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script.helper;

import java.io.IOException;
import java.util.regex.Matcher;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.work.TaskLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsCliHelper {
    private static Logger logger = LoggerFactory.getLogger(JsCliHelper.class);
    private Cli cli;
    private DeviceCliAccount account;
    private TaskLogger taskLogger;
    private TaskLogger cliLogger;
    private boolean errored = false;

    private static String toHexAscii(String text) {
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (i % 16 == 0 && i > 0) {
                hex.append("\n");
            }
            hex.append(" ").append(String.format("%02x", text.charAt(i)));
        }
        return hex.toString();
    }

    public JsCliHelper(Cli cli, DeviceCliAccount account, TaskLogger taskLogger, TaskLogger cliLogger) {
        this.cli = cli;
        this.account = account;
        this.taskLogger = taskLogger;
        this.cliLogger = cliLogger;
    }

    public String removeEcho(String text, String command) {
        String output = text;
        String headCommand = command;
        if (output.startsWith(headCommand = headCommand.replaceFirst("[\\r\\n]+$", ""))) {
            output = output.substring(headCommand.length());
            output = output.replaceFirst("^ *[\\r\\n]+", "");
            return output;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(String command, String[] expects, int timeout) {
        this.errored = false;
        if (command == null) {
            command = "";
        }
        if (this.cliLogger != null) {
            this.cliLogger.trace("About to send the following command: '" + command + "'");
            this.cliLogger.trace("In hex: " + JsCliHelper.toHexAscii(command));
        }
        command = command.replaceAll("\\$\\$NetshotUsername\\$\\$", Matcher.quoteReplacement(this.account.getUsername()));
        command = command.replaceAll("\\$\\$NetshotPassword\\$\\$", Matcher.quoteReplacement(this.account.getPassword()));
        command = command.replaceAll("\\$\\$NetshotSuperPassword\\$\\$", Matcher.quoteReplacement(this.account.getSuperPassword()));
        int oldTimeout = this.cli.getCommandTimeout();
        if (timeout > 0) {
            this.cli.setCommandTimeout(timeout);
        }
        try {
            logger.debug("Command to be sent: '{}'.", (Object)command);
            String result = this.cli.send(command, expects);
            if (this.cliLogger != null) {
                this.cliLogger.trace("Received the following output: '" + result + "'");
                this.cliLogger.trace("In hex: " + JsCliHelper.toHexAscii(result));
            }
            String string = result;
            return string;
        }
        catch (IOException e) {
            logger.error("CLI I/O error.", e);
            this.taskLogger.error("I/O error: " + e.getMessage());
            if (e instanceof Cli.WithBufferIOException) {
                String buffer = ((Cli.WithBufferIOException)e).getReceivedBuffer().toString();
                if (this.cliLogger != null) {
                    this.cliLogger.trace("Received buffer: '" + buffer + "'");
                    this.cliLogger.trace("In hex: " + JsCliHelper.toHexAscii(buffer));
                }
            }
            this.errored = true;
        }
        finally {
            this.cli.setCommandTimeout(oldTimeout);
        }
        return null;
    }

    public String send(String command, String[] expects) throws IOException {
        return this.send(command, expects, -1);
    }

    public String send(String[] expects) throws IOException {
        return this.send(null, expects, -1);
    }

    public String getLastCommand() {
        return this.cli.getLastCommand();
    }

    public String getLastExpectMatch() {
        return this.cli.getLastExpectMatch().group();
    }

    public String getLastExpectMatchGroup(int group) {
        try {
            return this.cli.getLastExpectMatch().group(group);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLastExpectMatchPattern() {
        return this.cli.getLastExpectMatchPattern();
    }

    public int getLastExpectMatchIndex() {
        return this.cli.getLastExpectMatchIndex();
    }

    public String getLastFullOutput() {
        return this.cli.getLastFullOutput();
    }

    public boolean isErrored() {
        return this.errored;
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

