/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http2.AlpnNegotiatorBase;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.Http2ClientFilter;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;

class AlpnClientNegotiatorImpl
extends AlpnNegotiatorBase
implements AlpnClientNegotiator {
    private static final Logger LOGGER = Grizzly.logger(AlpnClientNegotiatorImpl.class);
    private final Http2ClientFilter filter;

    public AlpnClientNegotiatorImpl(Http2ClientFilter filter) {
        this.filter = filter;
    }

    @Override
    public String[] getProtocols(SSLEngine sslEngine) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Alpn getProtocols. Connection={0}, protocols={1}", new Object[]{AlpnSupport.getConnection(sslEngine), Arrays.toString(SUPPORTED_PROTOCOLS)});
        }
        return (String[])SUPPORTED_PROTOCOLS.clone();
    }

    @Override
    public void protocolSelected(SSLEngine sslEngine, String selectedProtocol) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Alpn protocolSelected. Connection={0}, protocol={1}", new Object[]{AlpnSupport.getConnection(sslEngine), selectedProtocol});
        }
        Connection connection = AlpnSupport.getConnection(sslEngine);
        if ("h2".equals(selectedProtocol)) {
            Http2Session http2Session = this.filter.createClientHttp2Session(connection);
            http2Session.getHttp2State().setDirectUpgradePhase();
            http2Session.sendPreface();
        } else {
            Http2State.create(connection).setNeverHttp2();
        }
    }
}

