/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 * vec2(-0.1, -1.2)) => vec2(-0.0, -0.0)
 * (0.0 * vec2(-0.42, 0.48)) => vec2(-0.0, 0.0)
 * (-1.33 * vec2(-0.1, -1.2)) => vec2(0.133, 1.5960001)
 * (-1.33 * vec2(-0.42, 0.48)) => vec2(0.5586, -0.6384)
 * (0.85 * vec2(-0.1, -1.2)) => vec2(-0.085, -1.0200001)
 * (0.85 * vec2(-0.42, 0.48)) => vec2(-0.357, 0.408)
 */
#version 150

void main()
{
  float[distance((0.0 * vec2(-0.1, -1.2)), vec2(-0.0, -0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 * vec2(-0.42, 0.48)), vec2(-0.0, 0.0)) <= 0.0 ? 1 : -1] array1;
  float[distance((-1.33 * vec2(-0.1, -1.2)), vec2(0.133, 1.5960001)) <= 1.6015321e-05 ? 1 : -1] array2;
  float[distance((-1.33 * vec2(-0.42, 0.48)), vec2(0.5586, -0.6384)) <= 8.482856e-06 ? 1 : -1] array3;
  float[distance((0.85 * vec2(-0.1, -1.2)), vec2(-0.085, -1.0200001)) <= 1.0235356e-05 ? 1 : -1] array4;
  float[distance((0.85 * vec2(-0.42, 0.48)), vec2(-0.357, 0.408)) <= 5.421374e-06 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
