/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.VariantAbstractQuery;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;

public class VariantFormQuery
extends VariantAbstractQuery {
    private static final String WWW_APP_URL_ENCODED = "application/x-www-form-urlencoded";

    @Override
    public void setMessage(HttpMessage msg) {
        String contentType = msg.getRequestHeader().getHeader("Content-Type");
        if (contentType != null && contentType.startsWith(WWW_APP_URL_ENCODED)) {
            this.setParameters(2, Model.getSingleton().getSession().getParameters(msg, HtmlParameter.Type.form));
        }
    }

    @Override
    protected void buildMessage(HttpMessage msg, String query) {
        msg.getRequestBody().setBody(query);
    }

    @Override
    protected String getEscapedValue(HttpMessage msg, String value) {
        String encoded = "";
        if (value != null) {
            encoded = AbstractPlugin.getURLEncode(value);
        }
        return encoded;
    }

    @Override
    protected String getUnescapedValue(String value) {
        return value != null ? AbstractPlugin.getURLDecode(value) : "";
    }
}

