'\"
'\" Generated from file 'nns\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "nns" n 1\&.1 tcllib "Name service facility"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
nns \- Name service facility, Commandline Client Application
.SH SYNOPSIS
\fBnns\fR \fBbind\fR ?\fB-host\fR \fIhost\fR? ?\fB-port\fR \fIport\fR? \fIname\fR \fIdata\fR
.sp
\fBnns\fR \fBsearch\fR ?\fB-host\fR \fIhost\fR? ?\fB-port\fR \fIport\fR? ?\fB-continuous\fR? ?\fIpattern\fR?
.sp
\fBnns\fR \fBident\fR ?\fB-host\fR \fIhost\fR? ?\fB-port\fR \fIport\fR?
.sp
\fBnns\fR \fBwho\fR
.sp
.BE
.SH DESCRIPTION
.PP
Please read \fIName service facility, introduction\fR first\&.
.PP
The application described by this document, \fBnns\fR, is a simple
command line client for the nano name service facility provided by the
Tcllib packages \fBnameserv\fR, and \fBnameserv::server\fR\&.
Beyond that the application's sources also serve as an example of how
to use the client package \fBnameserv\fR\&. All abilities of a
client are covered, from configuration to registration of names to
searching\&.
.PP
This name service facility has nothing to do with the Internet's
\fIDomain Name System\fR, otherwise known as \fIDNS\fR\&. If the
reader is looking for a package dealing with that please see either of
the packages \fBdns\fR and \fBresolv\fR, both found in Tcllib
too\&.
.SS "USE CASES"
\fBnns\fR was written with the following two main use cases in
mind\&.
.PP
.IP [1]
Registration of a name/data pair in the name service\&.
.IP [2]
Searching the name service for entries matching a glob pattern\&.
.PP
.PP
Beyond the above we also want to be able to identify the client, and
get information about the name service\&.
.SS "COMMAND LINE"
.TP
\fBnns\fR \fBbind\fR ?\fB-host\fR \fIhost\fR? ?\fB-port\fR \fIport\fR? \fIname\fR \fIdata\fR
This form registers the \fIname\fR/\fIdata\fR pair in the specified
name service\&. In this form the command will \fInot\fR exit to keep
the registration alive\&. The user has to kill it explicitly, either by
sending a signal, or through the job-control facilities of the shell
in use\&. It will especially survive the loss of the connection to the
name service and reestablish the \fIname\fR/\fIdata\fR pair when the
connection is restored\&.
.sp
The options to specify the name service will be explained later, in
section \fBOPTIONS\fR\&.
.TP
\fBnns\fR \fBsearch\fR ?\fB-host\fR \fIhost\fR? ?\fB-port\fR \fIport\fR? ?\fB-continuous\fR? ?\fIpattern\fR?
This form searches the specified name service for entries matching the
glob-\fIpattern\fR and prints them to stdout, with each entry on its
own line\&. If no pattern is specified it defaults to \fB*\fR,
matching everything\&.
.sp
The options to specify the name service will be explained later, in
section \fBOPTIONS\fR\&.
.sp
If the option \fB-continuous\fR is specified the client will not
exit after performing the search, but start to continuously monitor
the service for changes to the set of matching entries, appropriately
updating the display as changes arrive\&. In that form it will
especially also survive the loss of the connection to the name service
and reestablish the search when the connection is restored\&.
.TP
\fBnns\fR \fBident\fR ?\fB-host\fR \fIhost\fR? ?\fB-port\fR \fIport\fR?
This form asks the specified name service for the version and features
of the name service protocol it supports and prints the results to
stdout\&.
.sp
The options to specify the name service will be explained later, in
section \fBOPTIONS\fR\&.
.TP
\fBnns\fR \fBwho\fR
This form prints name, version, and protocol version of the
application to stdout\&.
.PP
.SS OPTIONS
This section describes all the options available to the user of the
application
.PP
.TP
\fB-host\fR name|ipaddress
If this option is not specified it defaults to \fBlocalhost\fR\&. It
specifies the name or ip-address of the host the name service to talk
to is running on\&.
.TP
\fB-port\fR number
If this option is not specified it defaults to \fB38573\fR\&. It
specifies the TCP port the name service to talk to is listening on for
requests\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fInameserv\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
nameserv(n), nameserv::common(n)
.SH KEYWORDS
application, client, name service
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi