/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.apache.camel.Exchange;
import org.apache.camel.ValidationException;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultValidationErrorHandler
implements ValidatorErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValidationErrorHandler.class);
    private List<SAXParseException> warnings = new ArrayList<SAXParseException>();
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private List<SAXParseException> fatalErrors = new ArrayList<SAXParseException>();

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation warning: " + e, e);
        }
        this.warnings.add(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation error: " + e, e);
        }
        this.errors.add(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation fatalError: " + e, e);
        }
        this.fatalErrors.add(e);
    }

    @Override
    public void reset() {
        this.warnings.clear();
        this.errors.clear();
        this.fatalErrors.clear();
    }

    public boolean isValid() {
        return this.errors.isEmpty() && this.fatalErrors.isEmpty();
    }

    @Override
    public void handleErrors(Exchange exchange, Schema schema, Result result) throws ValidationException {
        if (!this.isValid()) {
            throw new SchemaValidationException(exchange, schema, this.fatalErrors, this.errors, this.warnings);
        }
    }

    public void handleErrors(Exchange exchange, Object schema) throws ValidationException {
        if (!this.isValid()) {
            throw new SchemaValidationException(exchange, schema, this.fatalErrors, this.errors, this.warnings);
        }
    }
}

