/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CacheFilePriority;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbMpoolFile;

public class CacheFile {
    private DbMpoolFile mpf;

    CacheFile(DbMpoolFile dbMpoolFile) {
        this.mpf = dbMpoolFile;
    }

    public CacheFilePriority getPriority() throws DatabaseException {
        return CacheFilePriority.fromFlag(this.mpf.get_priority());
    }

    public void setPriority(CacheFilePriority cacheFilePriority) throws DatabaseException {
        this.mpf.set_priority(cacheFilePriority.getFlag());
    }

    public long getMaximumSize() throws DatabaseException {
        return this.mpf.get_maxsize();
    }

    public void setMaximumSize(long l) throws DatabaseException {
        this.mpf.set_maxsize(l);
    }

    public boolean getNoFile() throws DatabaseException {
        return (this.mpf.get_flags() & 1) != 0;
    }

    public void setNoFile(boolean bl) throws DatabaseException {
        this.mpf.set_flags(1, bl);
    }

    public boolean getUnlink() throws DatabaseException {
        return (this.mpf.get_flags() & 2) != 0;
    }

    public void setUnlink(boolean bl) throws DatabaseException {
        this.mpf.set_flags(2, bl);
    }
}

