/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.internal.file.ImmutableDirectoryTree;
import org.gradle.api.internal.file.collections.DirectoryTrees;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.FileUtils;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

@ThreadSafe
public class FileSystemSubset {
    private final ImmutableCollection<File> files;
    private final ImmutableCollection<ImmutableDirectoryTree> trees;

    public static Builder builder() {
        return new Builder();
    }

    public FileSystemSubset(ImmutableCollection<File> files, ImmutableCollection<ImmutableDirectoryTree> trees) {
        this.files = files;
        this.trees = trees;
    }

    public Iterable<? extends File> getRoots() {
        return FileUtils.calculateRoots((Iterable)Iterables.concat(this.files, (Iterable)Iterables.transform(this.trees, (Function)new Function<DirectoryTree, File>(){

            public File apply(DirectoryTree input) {
                return input.getDir();
            }
        })));
    }

    public FileSystemSubset unfiltered() {
        return new FileSystemSubset((ImmutableCollection<File>)ImmutableList.copyOf(this.getRoots()), (ImmutableCollection<ImmutableDirectoryTree>)ImmutableList.of());
    }

    public boolean isEmpty() {
        return this.files.isEmpty() && this.trees.isEmpty();
    }

    public boolean contains(File file) {
        File absoluteFile = file.getAbsoluteFile();
        for (File candidateFile : this.files) {
            if (!FileUtils.doesPathStartWith((String)file.getAbsolutePath(), (String)candidateFile.getPath())) continue;
            return true;
        }
        for (DirectoryTree tree : this.trees) {
            if (!tree.getDir().getAbsoluteFile().equals(absoluteFile) && !DirectoryTrees.contains((FileSystem)FileSystems.getDefault(), tree, absoluteFile)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Files: ").append(this.files);
        sb.append(" Trees: ").append(this.trees);
        return sb.toString();
    }

    @ThreadSafe
    public static class Builder {
        private final ImmutableSet.Builder<File> files = ImmutableSet.builder();
        private final ImmutableSet.Builder<ImmutableDirectoryTree> trees = ImmutableSet.builder();
        private final Lock lock = new ReentrantLock();

        private Builder() {
        }

        public Builder add(FileSystemSubset fileSystemSubset) {
            this.lock.lock();
            try {
                this.files.addAll((Iterable)fileSystemSubset.files);
                this.trees.addAll((Iterable)fileSystemSubset.trees);
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Builder add(File file) {
            this.lock.lock();
            try {
                this.files.add((Object)file.getAbsoluteFile());
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Builder add(DirectoryTree directoryTree) {
            this.lock.lock();
            try {
                this.trees.add((Object)ImmutableDirectoryTree.of(directoryTree));
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder add(File dir, PatternSet patternSet) {
            this.lock.lock();
            try {
                this.trees.add((Object)ImmutableDirectoryTree.of(dir, patternSet));
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        public FileSystemSubset build() {
            this.lock.lock();
            try {
                FileSystemSubset fileSystemSubset = new FileSystemSubset((ImmutableCollection<File>)this.files.build(), (ImmutableCollection<ImmutableDirectoryTree>)this.trees.build());
                return fileSystemSubset;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

