/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;

public abstract class DependentsSet {
    public static DependentsSet dependentClasses(String ... dependentClasses) {
        if (dependentClasses.length == 0) {
            return DependentsSet.empty();
        }
        return new DefaultDependentsSet((Set)ImmutableSet.copyOf((Object[])dependentClasses), Collections.emptySet());
    }

    public static DependentsSet dependentClasses(Set<String> dependentClasses) {
        return DependentsSet.dependents(dependentClasses, Collections.emptySet());
    }

    public static DependentsSet dependents(Set<String> dependentClasses, Set<GeneratedResource> dependentResources) {
        if (dependentClasses.isEmpty() && dependentResources.isEmpty()) {
            return DependentsSet.empty();
        }
        return new DefaultDependentsSet((Set)ImmutableSet.copyOf(dependentClasses), (Set)ImmutableSet.copyOf(dependentResources));
    }

    public static DependentsSet dependencyToAll() {
        return DependencyToAll.INSTANCE;
    }

    public static DependentsSet dependencyToAll(String reason) {
        return new DependencyToAll(reason);
    }

    public static DependentsSet empty() {
        return EmptyDependentsSet.INSTANCE;
    }

    public abstract Set<String> getDependentClasses();

    public abstract Set<GeneratedResource> getDependentResources();

    public abstract boolean isDependencyToAll();

    @Nullable
    public abstract String getDescription();

    private DependentsSet() {
    }

    private static class DependencyToAll
    extends DependentsSet {
        private static final DependencyToAll INSTANCE = new DependencyToAll();
        private final String reason;

        private DependencyToAll(String reason) {
            this.reason = reason;
        }

        private DependencyToAll() {
            this((String)null);
        }

        @Override
        public Set<String> getDependentClasses() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent classes information.");
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            throw new UnsupportedOperationException("This instance of dependents set does not have dependent resources information.");
        }

        @Override
        public boolean isDependencyToAll() {
            return true;
        }

        @Override
        public String getDescription() {
            return this.reason;
        }
    }

    private static class DefaultDependentsSet
    extends DependentsSet {
        private final Set<String> dependentClasses;
        private final Set<GeneratedResource> dependentResources;

        private DefaultDependentsSet(Set<String> dependentClasses, Set<GeneratedResource> dependentResources) {
            this.dependentClasses = dependentClasses;
            this.dependentResources = dependentResources;
        }

        @Override
        public Set<String> getDependentClasses() {
            return this.dependentClasses;
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            return this.dependentResources;
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    private static class EmptyDependentsSet
    extends DependentsSet {
        private static final EmptyDependentsSet INSTANCE = new EmptyDependentsSet();

        private EmptyDependentsSet() {
        }

        @Override
        public Set<String> getDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            return Collections.emptySet();
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }
    }
}

