/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.javac.JavaClassWithClassId;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.ResolveHelperKt;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ2\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0011j\b\u0012\u0004\u0012\u00020\b`\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ResolveHelper;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;Lcom/sun/source/tree/CompilationUnitTree;)V", "findImport", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "pathSegments", "", "", "findInnerOrNested", "javaClass", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkedSupertypes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findJavaOrKotlinClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findPackage", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "getJavaClassFromPathSegments", "findVisibleInnerOrNestedClass", "cli"})
public final class ResolveHelper {
    private final JavacWrapper javac;
    private final CompilationUnitTree compilationUnit;

    @Nullable
    public final JavaClass getJavaClassFromPathSegments(@NotNull JavaClass javaClass, @NotNull List<String> pathSegments) {
        Intrinsics.checkParameterIsNotNull((Object)javaClass, (String)"javaClass");
        Intrinsics.checkParameterIsNotNull(pathSegments, (String)"pathSegments");
        return pathSegments.size() == 1 ? javaClass : this.findInnerOrNested(javaClass, CollectionsKt.drop((Iterable)pathSegments, (int)1));
    }

    @Nullable
    public final JavaClass findImport(@NotNull List<String> pathSegments) {
        Intrinsics.checkParameterIsNotNull(pathSegments, (String)"pathSegments");
        Iterable $this$forEachIndexed$iv = pathSegments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            JavaClass javaClass;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                throw (Throwable)new ArithmeticException("Index overflow has happened.");
            }
            int n2 = n;
            String string = (String)item$iv;
            int index2 = n2;
            boolean bl2 = false;
            if (index2 == CollectionsKt.getLastIndex(pathSegments)) {
                return null;
            }
            String packageFqName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(pathSegments, (int)(index2 + 1)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            FqName fqName2 = this.findPackage(packageFqName);
            if (fqName2 == null) continue;
            FqName fqName3 = fqName2;
            boolean bl3 = false;
            boolean bl4 = false;
            FqName pack = fqName3;
            boolean bl5 = false;
            List className2 = CollectionsKt.takeLast(pathSegments, (int)(index2 + 1));
            JavaClass javaClass2 = this.findJavaOrKotlinClass(new ClassId(pack, Name.identifier((String)CollectionsKt.first((List)className2))));
            if (javaClass2 != null) {
                JavaClass javaClass3 = javaClass2;
                boolean bl6 = false;
                boolean bl7 = false;
                JavaClass javaClass4 = javaClass3;
                boolean bl8 = false;
                javaClass = this.getJavaClassFromPathSegments(javaClass4, className2);
            } else {
                javaClass = null;
            }
            return javaClass;
        }
        return null;
    }

    @Nullable
    public final JavaClass findJavaOrKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        JavaClass javaClass = JavacWrapper.findClass$default(this.javac, classId, null, 2, null);
        if (javaClass == null) {
            javaClass = this.javac.getKotlinClassifier(classId);
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JavaClass findInnerOrNested(@NotNull JavaClass javaClass, @NotNull Name name, @NotNull HashSet<JavaClass> checkedSupertypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)javaClass, (String)"javaClass");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(checkedSupertypes, (String)"checkedSupertypes");
        JavaClass javaClass2 = this.findVisibleInnerOrNestedClass(javaClass, name);
        if (javaClass2 != null) {
            JavaClass javaClass3 = javaClass2;
            boolean bl = false;
            boolean bl2 = false;
            JavaClass it = javaClass3;
            boolean bl3 = false;
            checkedSupertypes.addAll((Collection<JavaClass>)ResolveHelperKt.collectAllSupertypes(javaClass));
            return it;
        }
        Iterable $this$mapNotNull$iv = javaClass.getSupertypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JavaClass javaClass4;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JavaClassifierType it = (JavaClassifierType)element$iv$iv;
            boolean bl4 = false;
            JavaClassifier javaClassifier = it.getClassifier();
            if (!(javaClassifier instanceof JavaClass)) {
                javaClassifier = null;
            }
            if ((JavaClass)javaClassifier != null) {
                JavaClass javaClass5;
                boolean bl5 = false;
                boolean bl6 = false;
                JavaClass supertype = javaClass5;
                boolean bl7 = false;
                javaClass4 = !checkedSupertypes.contains(supertype) ? this.findInnerOrNested(supertype, name, checkedSupertypes) : null;
            } else {
                javaClass4 = null;
            }
            if (javaClass4 == null) continue;
            JavaClass javaClass6 = javaClass4;
            boolean bl8 = false;
            boolean bl9 = false;
            JavaClass it$iv$iv = javaClass6;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (JavaClass)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public static /* synthetic */ JavaClass findInnerOrNested$default(ResolveHelper resolveHelper, JavaClass javaClass, Name name, HashSet hashSet, int n, Object object) {
        if ((n & 4) != 0) {
            boolean bl = false;
            hashSet = new HashSet();
        }
        return resolveHelper.findInnerOrNested(javaClass, name, hashSet);
    }

    @Nullable
    public final FqName findPackage(@NotNull String packageName) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Object object = packageName;
        boolean bl = false;
        FqName fqName3 = fqName2 = !StringsKt.isBlank((CharSequence)object) ? new FqName(packageName) : FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName");
        FqName fqName4 = this.javac.hasKotlinPackage(fqName3);
        if (fqName4 != null) {
            object = fqName4;
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            return it;
        }
        JavaPackage javaPackage = JavacWrapper.findPackage$default(this.javac, fqName2, null, 2, null);
        return javaPackage != null ? javaPackage.getFqName() : null;
    }

    private final JavaClass findVisibleInnerOrNestedClass(@NotNull JavaClass $receiver, Name name) {
        JavaClass javaClass;
        JavaClass javaClass2 = $receiver.findInnerClass(name);
        if (javaClass2 != null) {
            JavaClass javaClass3 = javaClass2;
            boolean bl = false;
            boolean bl2 = false;
            JavaClass innerOrNestedClass = javaClass3;
            boolean bl3 = false;
            Visibility visibility = innerOrNestedClass.getVisibility();
            if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PRIVATE)) {
                javaClass = null;
            } else if (Intrinsics.areEqual((Object)visibility, (Object)JavaVisibilities.PACKAGE_VISIBILITY)) {
                JavaClass javaClass4 = innerOrNestedClass;
                if (!(javaClass4 instanceof JavaClassWithClassId)) {
                    javaClass4 = null;
                }
                JavaClassWithClassId javaClassWithClassId = (JavaClassWithClassId)javaClass4;
                ClassId classId = javaClassWithClassId != null ? javaClassWithClassId.getClassId() : null;
                Object object = classId;
                String string = object != null && (object = ((ClassId)object).getPackageFqName()) != null ? ((FqName)object).asString() : null;
                Object object2 = this.compilationUnit.getPackageName();
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "";
                }
                javaClass = Intrinsics.areEqual((Object)string, (Object)object2) ? (JavaClassWithClassId)innerOrNestedClass : null;
            } else {
                javaClass = innerOrNestedClass;
            }
        } else {
            javaClass = null;
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    private final JavaClass findInnerOrNested(@NotNull JavaClass $receiver, List<String> pathSegments) {
        Iterable $this$fold$iv = pathSegments;
        boolean $i$f$fold = false;
        JavaClass accumulator$iv = $receiver;
        for (Object element$iv : $this$fold$iv) {
            void it;
            String string = (String)element$iv;
            JavaClass javaClass = accumulator$iv;
            boolean bl = false;
            Name name = Name.identifier((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(it)");
            if (ResolveHelper.findInnerOrNested$default(this, javaClass, name, null, 4, null) != null) continue;
            return null;
        }
        return accumulator$iv;
    }

    public ResolveHelper(@NotNull JavacWrapper javac2, @NotNull CompilationUnitTree compilationUnit) {
        Intrinsics.checkParameterIsNotNull((Object)javac2, (String)"javac");
        Intrinsics.checkParameterIsNotNull((Object)compilationUnit, (String)"compilationUnit");
        this.javac = javac2;
        this.compilationUnit = compilationUnit;
    }
}

