/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.ConstructorSelector;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.JavaReflectionUtil;

class ParamsMatchingConstructorSelector
implements ConstructorSelector {
    private final CrossBuildInMemoryCache<Class<?>, ClassGenerator.GeneratedClass<?>> constructorCache;
    private final ClassGenerator classGenerator;

    public ParamsMatchingConstructorSelector(ClassGenerator classGenerator, CrossBuildInMemoryCache<Class<?>, ClassGenerator.GeneratedClass<?>> constructorCache) {
        this.constructorCache = constructorCache;
        this.classGenerator = classGenerator;
    }

    @Override
    public void vetoParameters(ClassGenerator.GeneratedConstructor<?> constructor, Object[] parameters) {
    }

    @Override
    public <T> ClassGenerator.GeneratedConstructor<? extends T> forType(Class<T> type) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This constructor selector requires the construction parameters");
    }

    @Override
    public <T> ClassGenerator.GeneratedConstructor<? extends T> forParams(final Class<T> type, Object[] params) {
        ClassGenerator.GeneratedClass generatedClass = (ClassGenerator.GeneratedClass)this.constructorCache.get(type, new Transformer<ClassGenerator.GeneratedClass<?>, Class<?>>(){

            public ClassGenerator.GeneratedClass<?> transform(Class<?> aClass) {
                return ParamsMatchingConstructorSelector.this.classGenerator.generate(type);
            }
        });
        if (!(generatedClass.getOuterType() == null || params.length != 0 && generatedClass.getOuterType().isInstance(params[0]))) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append((CharSequence)" is a non-static inner class.");
            throw new IllegalArgumentException(formatter.toString());
        }
        List constructors = generatedClass.getConstructors();
        if (constructors.size() == 1) {
            return (ClassGenerator.GeneratedConstructor)Cast.uncheckedCast(constructors.get(0));
        }
        ClassGenerator.GeneratedConstructor match = null;
        for (ClassGenerator.GeneratedConstructor constructor : constructors) {
            int fromParam;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length < params.length) continue;
            int toParam = 0;
            for (fromParam = 0; fromParam < params.length; ++fromParam) {
                Object param = params[fromParam];
                while (param != null && toParam < parameterTypes.length) {
                    Class toType = parameterTypes[toParam];
                    if (toType.isPrimitive()) {
                        toType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(toType);
                    }
                    if (toType.isInstance(param)) break;
                    ++toParam;
                }
                if (toParam == parameterTypes.length) break;
                ++toParam;
            }
            if (fromParam != params.length) continue;
            if (match == null || parameterTypes.length < match.getParameterTypes().length) {
                match = constructor;
                continue;
            }
            if (parameterTypes.length != match.getParameterTypes().length) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Multiple constructors of ");
            formatter.appendType(type);
            formatter.append((CharSequence)" match parameters: ");
            formatter.appendValues(params);
            throw new IllegalArgumentException(formatter.toString());
        }
        if (match != null) {
            return (ClassGenerator.GeneratedConstructor)Cast.uncheckedCast(match);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No constructors of ");
        formatter.appendType(type);
        formatter.append((CharSequence)" match parameters: ");
        formatter.appendValues(params);
        throw new IllegalArgumentException(formatter.toString());
    }
}

