/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public abstract class ImplementationSnapshot
implements ValueSnapshot {
    private static final String GENERATED_LAMBDA_CLASS_SUFFIX = "$$Lambda$";
    private final String typeName;

    public static ImplementationSnapshot of(Class<?> type, ClassLoaderHierarchyHasher classLoaderHasher) {
        String className = type.getName();
        return ImplementationSnapshot.of(className, classLoaderHasher.getClassLoaderHash(type.getClassLoader()), type.isSynthetic() && ImplementationSnapshot.isLambdaClassName(className));
    }

    public static ImplementationSnapshot of(String className, @Nullable HashCode classLoaderHash) {
        return ImplementationSnapshot.of(className, classLoaderHash, ImplementationSnapshot.isLambdaClassName(className));
    }

    private static ImplementationSnapshot of(String typeName, @Nullable HashCode classLoaderHash, boolean lambda) {
        if (classLoaderHash == null) {
            return new UnknownClassloaderImplementationSnapshot(typeName);
        }
        if (lambda) {
            return new LambdaImplementationSnapshot(typeName);
        }
        return new DefaultImplementationSnapshot(typeName, classLoaderHash);
    }

    private static boolean isLambdaClassName(String className) {
        return className.contains(GENERATED_LAMBDA_CLASS_SUFFIX);
    }

    protected ImplementationSnapshot(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Nullable
    public abstract HashCode getClassLoaderHash();

    public abstract boolean isUnknown();

    @Nullable
    public abstract String getUnknownReason();

    public ValueSnapshot snapshot(@Nullable Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (this.isSameSnapshot(other)) {
            return this;
        }
        return other;
    }

    protected abstract boolean isSameSnapshot(@Nullable Object var1);

    public static class SerializerImpl
    implements Serializer<ImplementationSnapshot> {
        public ImplementationSnapshot read(Decoder decoder) throws Exception {
            ImplementationSnapshotSerializer serializer = ImplementationSnapshotSerializer.values()[decoder.readSmallInt()];
            return serializer.read(decoder);
        }

        public void write(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
            ImplementationSnapshotSerializer serializer = this.determineSerializer(implementationSnapshot);
            encoder.writeSmallInt(serializer.ordinal());
            serializer.write(encoder, implementationSnapshot);
        }

        private ImplementationSnapshotSerializer determineSerializer(ImplementationSnapshot implementationSnapshot) {
            if (implementationSnapshot instanceof DefaultImplementationSnapshot) {
                return ImplementationSnapshotSerializer.DEFAULT;
            }
            if (implementationSnapshot instanceof UnknownClassloaderImplementationSnapshot) {
                return ImplementationSnapshotSerializer.UNKNOWN_CLASSLOADER;
            }
            if (implementationSnapshot instanceof LambdaImplementationSnapshot) {
                return ImplementationSnapshotSerializer.LAMBDA;
            }
            throw new IllegalArgumentException("Unknown implementation snapshot type: " + implementationSnapshot.getClass().getName());
        }

        private static enum ImplementationSnapshotSerializer implements Serializer<ImplementationSnapshot>
        {
            DEFAULT{

                @Override
                protected ImplementationSnapshot doRead(String typeName, Decoder decoder) throws Exception {
                    HashCode classLoaderHash = (HashCode)this.hashCodeSerializer.read(decoder);
                    return new DefaultImplementationSnapshot(typeName, classLoaderHash);
                }

                @Override
                public void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
                    this.hashCodeSerializer.write(encoder, (Object)implementationSnapshot.getClassLoaderHash());
                }
            }
            ,
            UNKNOWN_CLASSLOADER{

                @Override
                protected ImplementationSnapshot doRead(String typeName, Decoder decoder) {
                    return new UnknownClassloaderImplementationSnapshot(typeName);
                }
            }
            ,
            LAMBDA{

                @Override
                protected ImplementationSnapshot doRead(String typeName, Decoder decoder) {
                    return new LambdaImplementationSnapshot(typeName);
                }
            };

            protected final Serializer<HashCode> hashCodeSerializer = new HashCodeSerializer();

            public void write(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
                encoder.writeString((CharSequence)implementationSnapshot.getTypeName());
                this.writeAdditionalData(encoder, implementationSnapshot);
            }

            public ImplementationSnapshot read(Decoder decoder) throws Exception {
                String typeName = decoder.readString();
                return this.doRead(typeName, decoder);
            }

            protected abstract ImplementationSnapshot doRead(String var1, Decoder var2) throws Exception;

            protected void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
            }
        }
    }

    private static class UnknownClassloaderImplementationSnapshot
    extends ImplementationSnapshot {
        public UnknownClassloaderImplementationSnapshot(String typeName) {
            super(typeName);
        }

        public void appendToHasher(Hasher hasher) {
            hasher.markAsInvalid(this.getUnknownReason());
        }

        @Override
        protected boolean isSameSnapshot(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownClassloaderImplementationSnapshot that = (UnknownClassloaderImplementationSnapshot)o;
            return this.getTypeName().equals(that.getTypeName());
        }

        @Override
        public HashCode getClassLoaderHash() {
            return null;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        @Nullable
        public String getUnknownReason() {
            return "was loaded with an unknown classloader (class '" + this.getTypeName() + "').";
        }

        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return this.getTypeName().hashCode();
        }

        public String toString() {
            return this.getTypeName() + "@<Unknown classloader>";
        }
    }

    private static class LambdaImplementationSnapshot
    extends ImplementationSnapshot {
        public LambdaImplementationSnapshot(String typeName) {
            super(typeName);
        }

        public void appendToHasher(Hasher hasher) {
            hasher.markAsInvalid(this.getUnknownReason());
        }

        @Override
        protected boolean isSameSnapshot(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LambdaImplementationSnapshot that = (LambdaImplementationSnapshot)o;
            return this.getTypeName().equals(that.getTypeName());
        }

        @Override
        public HashCode getClassLoaderHash() {
            return null;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        @Nullable
        public String getUnknownReason() {
            return "was implemented by the Java lambda '" + this.getTypeName() + "'. Using Java lambdas is not supported, use an (anonymous) inner class instead.";
        }

        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return this.getTypeName().hashCode();
        }

        public String toString() {
            return this.getTypeName();
        }
    }

    private static class DefaultImplementationSnapshot
    extends ImplementationSnapshot {
        private final HashCode classLoaderHash;

        public DefaultImplementationSnapshot(String typeName, HashCode classLoaderHash) {
            super(typeName);
            this.classLoaderHash = classLoaderHash;
        }

        public void appendToHasher(Hasher hasher) {
            hasher.putString((CharSequence)ImplementationSnapshot.class.getName());
            hasher.putString((CharSequence)this.getTypeName());
            hasher.putHash(this.classLoaderHash);
        }

        @Override
        protected boolean isSameSnapshot(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultImplementationSnapshot that = (DefaultImplementationSnapshot)o;
            if (!this.getTypeName().equals(that.getTypeName())) {
                return false;
            }
            return this.classLoaderHash.equals((Object)that.classLoaderHash);
        }

        @Override
        public HashCode getClassLoaderHash() {
            return this.classLoaderHash;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        @Nullable
        public String getUnknownReason() {
            return null;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultImplementationSnapshot that = (DefaultImplementationSnapshot)o;
            if (this == o) {
                return true;
            }
            if (!this.getTypeName().equals(that.getTypeName())) {
                return false;
            }
            return this.classLoaderHash.equals((Object)that.classLoaderHash);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.classLoaderHash.hashCode();
            return result;
        }

        public String toString() {
            return this.getTypeName() + "@" + this.classLoaderHash;
        }
    }
}

