/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import opennlp.tools.util.Span;
import org.apache.lucene.analysis.opennlp.tools.NLPSentenceDetectorOp;
import org.apache.lucene.analysis.util.CharArrayIterator;

public final class OpenNLPSentenceBreakIterator
extends BreakIterator {
    private CharacterIterator text;
    private int currentSentence;
    private int[] sentenceStarts;
    private NLPSentenceDetectorOp sentenceOp;

    public OpenNLPSentenceBreakIterator(NLPSentenceDetectorOp sentenceOp) {
        this.sentenceOp = sentenceOp;
    }

    @Override
    public int current() {
        return this.text.getIndex();
    }

    @Override
    public int first() {
        this.currentSentence = 0;
        this.text.setIndex(this.text.getBeginIndex());
        return this.current();
    }

    @Override
    public int last() {
        if (this.sentenceStarts.length > 0) {
            this.currentSentence = this.sentenceStarts.length - 1;
            this.text.setIndex(this.text.getEndIndex());
        } else {
            this.currentSentence = 0;
            this.text.setIndex(this.text.getBeginIndex());
        }
        return this.current();
    }

    @Override
    public int next() {
        if (this.text.getIndex() == this.text.getEndIndex() || 0 == this.sentenceStarts.length) {
            return -1;
        }
        if (this.currentSentence < this.sentenceStarts.length - 1) {
            this.text.setIndex(this.sentenceStarts[++this.currentSentence]);
            return this.current();
        }
        return this.last();
    }

    @Override
    public int following(int pos) {
        if (pos < this.text.getBeginIndex() || pos > this.text.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        if (0 == this.sentenceStarts.length) {
            this.text.setIndex(this.text.getBeginIndex());
            return -1;
        }
        if (pos >= this.sentenceStarts[this.sentenceStarts.length - 1]) {
            this.text.setIndex(this.text.getEndIndex());
            this.currentSentence = this.sentenceStarts.length - 1;
            return -1;
        }
        this.currentSentence = (this.sentenceStarts.length - 1) / 2;
        this.moveToSentenceAt(pos, 0, this.sentenceStarts.length - 2);
        this.text.setIndex(this.sentenceStarts[++this.currentSentence]);
        return this.current();
    }

    private void moveToSentenceAt(int pos, int minSentence, int maxSentence) {
        if (minSentence != maxSentence) {
            if (pos < this.sentenceStarts[this.currentSentence]) {
                int newMaxSentence = this.currentSentence - 1;
                this.currentSentence = minSentence + (this.currentSentence - minSentence) / 2;
                this.moveToSentenceAt(pos, minSentence, newMaxSentence);
            } else if (pos >= this.sentenceStarts[this.currentSentence + 1]) {
                int newMinSentence = this.currentSentence + 1;
                this.currentSentence = maxSentence - (maxSentence - this.currentSentence) / 2;
                this.moveToSentenceAt(pos, newMinSentence, maxSentence);
            }
        } else {
            assert (this.currentSentence == minSentence);
            assert (pos >= this.sentenceStarts[this.currentSentence]);
            assert (this.currentSentence == this.sentenceStarts.length - 1 && pos <= this.text.getEndIndex() || pos < this.sentenceStarts[this.currentSentence + 1]);
        }
    }

    @Override
    public int previous() {
        if (this.text.getIndex() == this.text.getBeginIndex()) {
            return -1;
        }
        if (0 == this.sentenceStarts.length) {
            this.text.setIndex(this.text.getBeginIndex());
            return -1;
        }
        if (this.text.getIndex() == this.text.getEndIndex()) {
            this.text.setIndex(this.sentenceStarts[this.currentSentence]);
        } else {
            this.text.setIndex(this.sentenceStarts[--this.currentSentence]);
        }
        return this.current();
    }

    @Override
    public int preceding(int pos) {
        if (pos < this.text.getBeginIndex() || pos > this.text.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        if (0 == this.sentenceStarts.length) {
            this.text.setIndex(this.text.getBeginIndex());
            this.currentSentence = 0;
            return -1;
        }
        if (pos < this.sentenceStarts[0]) {
            this.text.setIndex(this.text.getBeginIndex());
            this.currentSentence = 0;
            return -1;
        }
        this.currentSentence = this.sentenceStarts.length / 2;
        this.moveToSentenceAt(pos, 0, this.sentenceStarts.length - 1);
        if (0 == this.currentSentence) {
            this.text.setIndex(this.text.getBeginIndex());
            return -1;
        }
        this.text.setIndex(this.sentenceStarts[--this.currentSentence]);
        return this.current();
    }

    @Override
    public int next(int n) {
        this.currentSentence += n;
        if (n < 0) {
            if (this.text.getIndex() == this.text.getEndIndex()) {
                ++this.currentSentence;
            }
            if (this.currentSentence < 0) {
                this.currentSentence = 0;
                this.text.setIndex(this.text.getBeginIndex());
                return -1;
            }
            this.text.setIndex(this.sentenceStarts[this.currentSentence]);
        } else if (n > 0) {
            if (this.currentSentence >= this.sentenceStarts.length) {
                this.currentSentence = this.sentenceStarts.length - 1;
                this.text.setIndex(this.text.getEndIndex());
                return -1;
            }
            this.text.setIndex(this.sentenceStarts[this.currentSentence]);
        }
        return this.current();
    }

    @Override
    public CharacterIterator getText() {
        return this.text;
    }

    @Override
    public void setText(CharacterIterator newText) {
        this.text = newText;
        this.text.setIndex(this.text.getBeginIndex());
        this.currentSentence = 0;
        Span[] spans = this.sentenceOp.splitSentences(this.characterIteratorToString());
        this.sentenceStarts = new int[spans.length];
        for (int i = 0; i < spans.length; ++i) {
            this.sentenceStarts[i] = spans[i].getStart() + this.text.getBeginIndex();
        }
    }

    private String characterIteratorToString() {
        String fullText;
        if (this.text instanceof CharArrayIterator) {
            CharArrayIterator charArrayIterator = (CharArrayIterator)this.text;
            fullText = new String(charArrayIterator.getText(), charArrayIterator.getStart(), charArrayIterator.getLength());
        } else {
            StringBuilder builder = new StringBuilder();
            char ch = this.text.first();
            while (ch != '\uffff') {
                builder.append(ch);
                ch = this.text.next();
            }
            fullText = builder.toString();
            this.text.setIndex(this.text.getBeginIndex());
        }
        return fullText;
    }
}

