/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.ConditionalMapWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Suggester
implements MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final EnumMap<Hint, Object> hints = new EnumMap(Hint.class);
    Policy.Session session;
    SolrRequest operation;
    boolean force;
    protected List<Violation> originalViolations = new ArrayList<Violation>();
    private boolean isInitialized = false;
    LinkedHashMap<Clause, double[]> deviations;
    LinkedHashMap<Clause, double[]> lastBestDeviation;
    static Predicate<Pair<Object, Object>> equalsPredicate = valPair -> Objects.equals(valPair.first(), valPair.second());

    void _init(Policy.Session session) {
        this.session = session.copy();
    }

    boolean isLessDeviant() {
        if (this.lastBestDeviation == null && this.deviations == null) {
            return false;
        }
        if (this.deviations == null) {
            return true;
        }
        if (this.lastBestDeviation == null) {
            return false;
        }
        if (this.lastBestDeviation.size() < this.deviations.size()) {
            return true;
        }
        for (Map.Entry<Clause, double[]> currentDeviation : this.deviations.entrySet()) {
            double[] lastDeviation = this.lastBestDeviation.get(currentDeviation.getKey());
            if (lastDeviation == null) {
                return false;
            }
            int result = Preference.compareWithTolerance(currentDeviation.getValue()[0], lastDeviation[0], 1.0f);
            if (result < 0) {
                return true;
            }
            if (result <= 0) continue;
            return false;
        }
        return false;
    }

    public Suggester hint(Hint hint, Object value) {
        hint.validator.accept(value);
        if (hint.multiValued) {
            List<Object> values = value instanceof Collection ? (List<Object>)value : Collections.singletonList(value);
            ((Set)this.hints.computeIfAbsent(hint, h -> new HashSet())).addAll(values);
        } else if (value == null) {
            this.hints.put(hint, null);
        } else if (value instanceof Map || value instanceof Number) {
            this.hints.put(hint, value);
        } else {
            this.hints.put(hint, (Object)String.valueOf(value));
        }
        return this;
    }

    public CollectionParams.CollectionAction getAction() {
        return null;
    }

    public Suggester forceOperation(boolean force) {
        this.force = force;
        return this;
    }

    protected boolean isNodeSuitableForReplicaAddition(Row targetRow, Row srcRow) {
        if (!targetRow.isLive) {
            return false;
        }
        if (!this.isAllowed(targetRow.node, Hint.TARGET_NODE)) {
            return false;
        }
        if (!this.isAllowed(targetRow.getVal("freedisk"), Hint.MINFREEDISK)) {
            return false;
        }
        if (srcRow != null) {
            for (Violation v1 : this.originalViolations) {
                if (!v1.getClause().getThirdTag().varType.meta.isNodeSpecificVal() || v1.getClause().hasComputedValue || !targetRow.node.equals(v1.node)) continue;
                for (Violation v2 : this.originalViolations) {
                    if (!srcRow.node.equals(v2.node) || !v1.getClause().equals(v2.getClause())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    abstract SolrRequest init();

    public SolrRequest getSuggestion() {
        if (!this.isInitialized) {
            Set srcNodes;
            Set<String> collections = this.hints.getOrDefault((Object)Hint.COLL, Collections.emptySet());
            Set<Pair> s = this.hints.getOrDefault((Object)Hint.COLL_SHARD, Collections.emptySet());
            if (!collections.isEmpty() || !s.isEmpty()) {
                HashSet<Pair<String, String>> collectionShardPairs = new HashSet<Pair<String, String>>(s);
                collections.forEach(c -> collectionShardPairs.add(new Pair<String, Object>((String)c, null)));
                collections.forEach(c -> {
                    try {
                        this.getWithCollection((String)c).ifPresent(withCollection -> collectionShardPairs.add(new Pair<String, Object>((String)withCollection, null)));
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while fetching 'withCollection' attribute for collection: " + c, (Throwable)e);
                    }
                });
                s.forEach(kv -> {
                    try {
                        this.getWithCollection((String)kv.first()).ifPresent(withCollection -> collectionShardPairs.add(new Pair<String, Object>((String)withCollection, null)));
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while fetching 'withCollection' attribute for collection: " + (String)kv.first(), (Throwable)e);
                    }
                });
                this.setupCollection(collectionShardPairs);
                Collections.sort(this.session.expandedClauses);
            }
            if ((srcNodes = (Set)this.hints.get((Object)Hint.SRC_NODE)) != null && !srcNodes.isEmpty()) {
                for (String srcNode : srcNodes) {
                    if (!this.session.matrix.stream().noneMatch(row -> row.node.equals(srcNode))) continue;
                    this.session.matrix.add(new Row(srcNode, this.session.getPolicy().params, this.session.getPolicy().perReplicaAttributes, this.session));
                }
            }
            this.session.applyRules();
            this.originalViolations.addAll(this.session.getViolations());
            this.operation = this.init();
            this.isInitialized = true;
        }
        if (this.operation != null && this.session.transaction != null && this.session.transaction.isOpen()) {
            this.session.transaction.updateSession(this.session);
        }
        return this.operation;
    }

    protected Optional<String> getWithCollection(String collectionName) throws IOException {
        DocCollection collection = this.session.cloudManager.getClusterStateProvider().getCollection(collectionName);
        if (collection != null) {
            return Optional.ofNullable(collection.getStr("withCollection"));
        }
        return Optional.empty();
    }

    private void setupCollection(HashSet<Pair<String, String>> collectionShardPairs) {
        ClusterStateProvider stateProvider = this.session.cloudManager.getClusterStateProvider();
        for (Pair<String, String> shard : collectionShardPairs) {
            if (this.session.matrix.stream().noneMatch(row -> row.hasColl((String)shard.first()))) {
                this.session.addClausesForCollection(stateProvider, shard.first());
            }
            for (Row row2 : this.session.matrix) {
                row2.createCollShard(shard);
            }
        }
    }

    public Policy.Session getSession() {
        return this.session;
    }

    List<Row> getMatrix() {
        return this.session.matrix;
    }

    boolean isLessSerious(List<Violation> fresh, List<Violation> old) {
        if (old == null || fresh.size() < old.size()) {
            return true;
        }
        if (fresh.size() == old.size()) {
            for (int i = 0; i < fresh.size(); ++i) {
                Violation freshViolation = fresh.get(i);
                Violation oldViolation = null;
                for (Violation v : old) {
                    if (!v.equals(freshViolation)) continue;
                    oldViolation = v;
                }
                if (oldViolation == null) {
                    for (Violation v : old) {
                        if (!v.isSimilarViolation(freshViolation)) continue;
                        oldViolation = v;
                    }
                }
                if (oldViolation == null || !freshViolation.isLessSerious(oldViolation)) continue;
                return true;
            }
        }
        return false;
    }

    boolean containsNewErrors(List<Violation> violations) {
        boolean isTxOpen;
        boolean bl = isTxOpen = this.session.transaction != null && this.session.transaction.isOpen();
        if (violations.size() > this.originalViolations.size()) {
            return true;
        }
        for (Violation v : violations) {
            int idx;
            if (isTxOpen && v.getClause().hasComputedValue || (idx = this.originalViolations.indexOf(v)) >= 0) continue;
            return true;
        }
        return false;
    }

    List<Pair<ReplicaInfo, Row>> getValidReplicas(boolean sortDesc, boolean isSource, int until) {
        ArrayList<Pair<ReplicaInfo, Row>> allPossibleReplicas = new ArrayList<Pair<ReplicaInfo, Row>>();
        if (sortDesc) {
            if (until == -1) {
                until = this.getMatrix().size();
            }
            for (int i = 0; i < until; ++i) {
                this.addReplicaToList(this.getMatrix().get(i), isSource, allPossibleReplicas);
            }
        } else {
            if (until == -1) {
                until = 0;
            }
            for (int i = this.getMatrix().size() - 1; i >= until; --i) {
                this.addReplicaToList(this.getMatrix().get(i), isSource, allPossibleReplicas);
            }
        }
        return allPossibleReplicas;
    }

    void addReplicaToList(Row r, boolean isSource, List<Pair<ReplicaInfo, Row>> replicaList) {
        if (!this.isAllowed(r.node, isSource ? Hint.SRC_NODE : Hint.TARGET_NODE)) {
            return;
        }
        for (Map.Entry<String, Map<String, List<ReplicaInfo>>> e : r.collectionVsShardVsReplicas.entrySet()) {
            if (!this.isAllowed(e.getKey(), Hint.COLL)) continue;
            block1: for (Map.Entry<String, List<ReplicaInfo>> shard : e.getValue().entrySet()) {
                if (!this.isAllowed(new Pair<String, String>(e.getKey(), shard.getKey()), Hint.COLL_SHARD) || shard.getValue() == null || shard.getValue().isEmpty()) continue;
                for (ReplicaInfo replicaInfo : shard.getValue()) {
                    if (replicaInfo.getName().startsWith("SYNTHETIC.")) continue;
                    replicaList.add(new Pair<ReplicaInfo, Row>(shard.getValue().get(0), r));
                    continue block1;
                }
            }
        }
    }

    List<Violation> testChangedMatrix(boolean executeInStrictMode, Policy.Session session) {
        if (this.deviations != null) {
            this.lastBestDeviation = this.deviations;
        }
        this.deviations = null;
        Policy.setApproxValuesAndSortNodes(session.getPolicy().clusterPreferences, session.matrix);
        ArrayList<Violation> errors = new ArrayList<Violation>();
        for (Clause clause : session.expandedClauses) {
            Clause originalClause;
            Clause clause2 = originalClause = clause.derivedFrom == null ? clause : clause.derivedFrom;
            if (this.deviations == null) {
                this.deviations = new LinkedHashMap();
            }
            this.deviations.put(originalClause, new double[1]);
            List<Violation> errs = clause.test(session, this.deviations == null ? null : this.deviations.get(originalClause));
            if (errs.isEmpty() || !executeInStrictMode && !clause.strict) continue;
            errors.addAll(errs);
        }
        session.violations = errors;
        if (!errors.isEmpty()) {
            this.deviations = null;
        }
        return errors;
    }

    protected boolean isAllowed(Object v, Hint hint) {
        Object hintVal = this.hints.get((Object)hint);
        if (hintVal == null) {
            return true;
        }
        if (hint.multiValued) {
            Set set = (Set)hintVal;
            return set == null || set.contains(v);
        }
        return hintVal == null || hint.valueValidator.test(new Pair<Object, Object>(hintVal, v));
    }

    public String toString() {
        return this.jsonStr();
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"action", String.valueOf((Object)this.getAction()));
        ew.put((CharSequence)"hints", ew1 -> this.hints.forEach((hint, o) -> ew1.putNoEx(hint.toString(), o)));
    }

    protected Collection setupWithCollectionTargetNodes(Set<String> collections, Set<Pair<String, String>> s, String withCollection) {
        Collection originalTargetNodesCopy = null;
        if (withCollection != null) {
            if (log.isDebugEnabled()) {
                HashSet<String> set = new HashSet<String>(collections);
                s.forEach(kv -> set.add((String)kv.first()));
                log.debug("Identified withCollection = {} for collection: {}", (Object)withCollection, set);
            }
            originalTargetNodesCopy = Utils.getDeepCopy((Collection)this.hints.get((Object)Hint.TARGET_NODE), 10, true);
            HashSet withCollectionNodes = new HashSet();
            for (Row row : this.getMatrix()) {
                row.forEachReplica(r -> {
                    if (withCollection.equals(r.getCollection()) && "shard1".equals(r.getShard())) {
                        withCollectionNodes.add(r.getNode());
                    }
                });
            }
            if (originalTargetNodesCopy != null && !originalTargetNodesCopy.isEmpty()) {
                Set set = (Set)this.hints.computeIfAbsent(Hint.TARGET_NODE, h -> new HashSet());
                set.retainAll(withCollectionNodes);
                if (set.isEmpty()) {
                    this.hints.put(Hint.TARGET_NODE, (Object)originalTargetNodesCopy);
                }
            } else if (originalTargetNodesCopy == null) {
                this.hints.put(Hint.TARGET_NODE, withCollectionNodes);
            }
        }
        return originalTargetNodesCopy;
    }

    protected String findWithCollection(Set<String> collections, Set<Pair<String, String>> s) {
        ArrayList withCollections = new ArrayList(1);
        collections.forEach(c -> {
            try {
                this.getWithCollection((String)c).ifPresent(withCollections::add);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while fetching 'withCollection' attribute for collection: " + c, (Throwable)e);
            }
        });
        s.forEach(kv -> {
            try {
                this.getWithCollection((String)kv.first()).ifPresent(withCollections::add);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while fetching 'withCollection' attribute for collection: " + (String)kv.first(), (Throwable)e);
            }
        });
        if (withCollections.size() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The number of 'withCollection' attributes should be exactly 1 for any policy but found: " + withCollections);
        }
        return withCollections.isEmpty() ? null : (String)withCollections.get(0);
    }

    public static enum Hint {
        COLL(true),
        COLL_SHARD(true, v -> {
            Set<Object> c = v instanceof Collection ? (Set<Object>)v : Collections.singleton(v);
            for (Object e : c) {
                if (!(e instanceof Pair)) {
                    throw new RuntimeException("COLL_SHARD hint must use a Pair");
                }
                Pair p = (Pair)e;
                if (p.first() != null && p.second() != null) continue;
                throw new RuntimeException("Both collection and shard must not be null");
            }
        }){

            @Override
            public Object parse(Object v) {
                if (v instanceof Map) {
                    Map map = (Map)v;
                    return Pair.parse(map);
                }
                return super.parse(v);
            }
        }
        ,
        SRC_NODE(true),
        TARGET_NODE(true),
        REPLICATYPE(false, o -> {
            if (!(o instanceof Replica.Type)) {
                throw new RuntimeException("REPLICATYPE hint must use a ReplicaType");
            }
        }),
        MINFREEDISK(false, o -> {
            if (!(o instanceof Number)) {
                throw new RuntimeException("MINFREEDISK hint must be a number");
            }
        }, hintValVsActual -> {
            Double hintFreediskInGb = (Double)Variable.Type.FREEDISK.validate(null, hintValVsActual.first(), false);
            Double actualFreediskInGb = (Double)Variable.Type.FREEDISK.validate(null, hintValVsActual.second(), false);
            if (actualFreediskInGb == null) {
                return false;
            }
            return actualFreediskInGb > hintFreediskInGb;
        }),
        NUMBER(true, o -> {
            if (!(o instanceof Number)) {
                throw new RuntimeException("NUMBER hint must be a number");
            }
        }),
        PARAMS(false, o -> {
            if (!(o instanceof Map)) {
                throw new RuntimeException("PARAMS hint must be a Map<String, Object>");
            }
        }),
        REPLICA(true);

        public final boolean multiValued;
        public final Consumer<Object> validator;
        public final Predicate<Pair<Object, Object>> valueValidator;

        private Hint(boolean multiValued) {
            this(multiValued, v -> {
                Set<Object> c = v instanceof Collection ? (Set<Object>)v : Collections.singleton(v);
                for (Object e : c) {
                    if (e instanceof String) continue;
                    throw new RuntimeException("hint must be of type String");
                }
            });
        }

        private Hint(boolean multiValued, Consumer<Object> c) {
            this(multiValued, c, equalsPredicate);
        }

        private Hint(boolean multiValued, Consumer<Object> c, Predicate<Pair<Object, Object>> testval) {
            this.multiValued = multiValued;
            this.validator = c;
            this.valueValidator = testval;
        }

        public static Hint get(String s) {
            for (Hint hint : Hint.values()) {
                if (!hint.name().equals(s)) continue;
                return hint;
            }
            return null;
        }

        public Object parse(Object v) {
            return v;
        }
    }

    public static class SuggestionInfo
    implements MapWriter {
        Suggestion.Type type;
        Violation violation;
        SolrRequest operation;

        public SuggestionInfo(Violation violation, SolrRequest op, Suggestion.Type type) {
            this.violation = violation;
            this.operation = op;
            this.type = type;
        }

        public SolrRequest getOperation() {
            return this.operation;
        }

        public Violation getViolation() {
            return this.violation;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"type", this.type.name());
            if (this.violation != null) {
                ew.put((CharSequence)"violation", new ConditionalMapWriter(this.violation, (k, v) -> !"violatingReplicas".equals(k)));
            }
            ew.put((CharSequence)"operation", this.operation);
        }

        public String toString() {
            return Utils.toJSONString(this);
        }
    }
}

