/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ListStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream[] streams;
    private TupleStream currentStream;
    private int streamIndex;

    public ListStream(TupleStream ... streams) throws IOException {
        this.init(streams);
    }

    public ListStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        TupleStream[] streams = new TupleStream[streamExpressions.size()];
        for (int idx = 0; idx < streamExpressions.size(); ++idx) {
            streams[idx] = factory.constructStream(streamExpressions.get(idx));
        }
        this.init(streams);
    }

    private void init(TupleStream ... tupleStreams) {
        this.streams = tupleStreams;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            for (TupleStream stream : this.streams) {
                expression.addParameter(((Expressible)((Object)stream)).toExpression(factory));
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        for (TupleStream stream : this.streams) {
            explanation.addChild(stream.toExplanation(factory));
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        for (TupleStream stream : this.streams) {
            stream.setStreamContext(context);
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        for (TupleStream stream : this.streams) {
            l.add(stream);
        }
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple;
        while (true) {
            if (this.currentStream == null) {
                if (this.streamIndex < this.streams.length) {
                    this.currentStream = this.streams[this.streamIndex];
                    this.streams[this.streamIndex] = null;
                    this.currentStream.open();
                } else {
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    map.put("EOF", true);
                    return new Tuple(map);
                }
            }
            tuple = this.currentStream.read();
            if (!tuple.EOF) break;
            this.currentStream.close();
            this.currentStream = null;
            ++this.streamIndex;
        }
        return tuple;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

