/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Parameter;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.NamedValue;

public final class Expectation
implements NamedValue<String> {
    private volatile String name;
    private volatile List<Parameter> parameters;
    private volatile String value;

    public static Expectation continueResponse() {
        return new Expectation("100-continue");
    }

    public Expectation(String name) {
        this(name, null);
    }

    public Expectation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Expectation)) {
            return false;
        }
        Expectation that = (Expectation)obj;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getValue(), that.getValue()) && this.getParameters().equals(that.getParameters());
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameter> getParameters() {
        List<Parameter> r = this.parameters;
        if (r == null) {
            Expectation expectation = this;
            synchronized (expectation) {
                r = this.parameters;
                if (r == null) {
                    this.parameters = r = new CopyOnWriteArrayList<Parameter>();
                }
            }
        }
        return r;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.getName(), this.getValue(), this.getParameters());
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(List<Parameter> parameters) {
        Expectation expectation = this;
        synchronized (expectation) {
            List<Parameter> r = this.getParameters();
            r.clear();
            r.addAll(parameters);
        }
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Expectation [name=" + this.name + ", parameters=" + this.parameters + ", value=" + this.value + "]";
    }
}

