/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.InterruptibleTask$DoNothingRunnable;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class InterruptibleTask
extends AtomicReference
implements Runnable {
    private static final Runnable DONE = new InterruptibleTask$DoNothingRunnable(null);
    private static final Runnable INTERRUPTING = new InterruptibleTask$DoNothingRunnable(null);

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = !this.isDone();
        Object object = null;
        Throwable throwable = null;
        try {
            if (bl) {
                object = this.runInterruptibly();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            if (!this.compareAndSet(thread, DONE)) {
                while (this.get() == INTERRUPTING) {
                    Thread.yield();
                }
            }
            if (bl) {
                this.afterRanInterruptibly(object, throwable);
            }
        }
    }

    abstract boolean isDone();

    abstract Object runInterruptibly();

    abstract void afterRanInterruptibly(@NullableDecl Object var1, @NullableDecl Throwable var2);

    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (runnable instanceof Thread && this.compareAndSet(runnable, INTERRUPTING)) {
            ((Thread)runnable).interrupt();
            this.set(DONE);
        }
    }

    @Override
    public final String toString() {
        Runnable runnable = (Runnable)this.get();
        String string = runnable == DONE ? "running=[DONE]" : (runnable == INTERRUPTING ? "running=[INTERRUPTED]" : (runnable instanceof Thread ? "running=[RUNNING ON " + ((Thread)runnable).getName() + "]" : "running=[NOT STARTED YET]"));
        return string + ", " + this.toPendingString();
    }

    abstract String toPendingString();
}

