/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;

public class Token
extends PackedTokenAttributeImpl
implements FlagsAttribute,
PayloadAttribute {
    private int flags;
    private BytesRef payload;
    public static final AttributeFactory TOKEN_ATTRIBUTE_FACTORY = AttributeFactory.getStaticImplementation((AttributeFactory)AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, Token.class);

    public Token() {
    }

    public Token(CharSequence text, int start, int end) {
        this.append(text);
        this.setOffset(start, end);
    }

    public Token(CharSequence text, int posInc, int start, int end) {
        this.append(text);
        this.setOffset(start, end);
        this.setPositionIncrement(posInc);
    }

    public Token(CharSequence text, int posInc, int start, int end, int posLength) {
        this.append(text);
        this.setOffset(start, end);
        this.setPositionIncrement(posInc);
        this.setPositionLength(posLength);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public BytesRef getPayload() {
        return this.payload;
    }

    public void setPayload(BytesRef payload) {
        this.payload = payload;
    }

    public void clear() {
        super.clear();
        this.flags = 0;
        this.payload = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token other = (Token)((Object)obj);
            return this.flags == other.flags && (this.payload == null ? other.payload == null : this.payload.equals((Object)other.payload)) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        int code = super.hashCode();
        code = code * 31 + this.flags;
        if (this.payload != null) {
            code = code * 31 + this.payload.hashCode();
        }
        return code;
    }

    public Token clone() {
        Token t = (Token)super.clone();
        if (this.payload != null) {
            t.payload = BytesRef.deepCopyOf((BytesRef)this.payload);
        }
        return t;
    }

    public void reinit(Token prototype) {
        prototype.copyToWithoutPayloadClone((AttributeImpl)this);
    }

    private void copyToWithoutPayloadClone(AttributeImpl target) {
        super.copyTo(target);
        ((FlagsAttribute)target).setFlags(this.flags);
        ((PayloadAttribute)target).setPayload(this.payload);
    }

    public void copyTo(AttributeImpl target) {
        super.copyTo(target);
        ((FlagsAttribute)target).setFlags(this.flags);
        ((PayloadAttribute)target).setPayload(this.payload == null ? null : BytesRef.deepCopyOf((BytesRef)this.payload));
    }

    public void reflectWith(AttributeReflector reflector) {
        super.reflectWith(reflector);
        reflector.reflect(FlagsAttribute.class, "flags", (Object)this.flags);
        reflector.reflect(PayloadAttribute.class, "payload", (Object)this.payload);
    }
}

