/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpClusterStateProvider
implements ClusterStateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String urlScheme;
    volatile Set<String> liveNodes;
    long liveNodesTimestamp = 0L;
    volatile Map<String, List<String>> aliases;
    volatile Map<String, Map<String, String>> aliasProperties;
    long aliasesTimestamp = 0L;
    private int cacheTimeout = 5;

    public void init(List<String> solrUrls) throws Exception {
        for (String solrUrl : solrUrls) {
            this.urlScheme = solrUrl.startsWith("https") ? "https" : "http";
            try (SolrClient initialClient = this.getSolrClient(solrUrl);){
                this.liveNodes = BaseHttpClusterStateProvider.fetchLiveNodes(initialClient);
                this.liveNodesTimestamp = System.nanoTime();
                break;
            }
            catch (IOException e) {
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)solrUrl, (Object)e);
            }
        }
        if (this.liveNodes == null || this.liveNodes.isEmpty()) {
            throw new RuntimeException("Tried fetching live_nodes using Solr URLs provided, i.e. " + solrUrls + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
    }

    protected abstract SolrClient getSolrClient(String var1);

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClusterState.CollectionRef getState(String collection) {
        for (String nodeName : this.liveNodes) {
            String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
            try (SolrClient client = this.getSolrClient(baseUrl);){
                ClusterState cs = this.fetchClusterState(client, collection, null);
                ClusterState.CollectionRef collectionRef = cs.getCollectionRef(collection);
                return collectionRef;
            }
            catch (IOException | SolrServerException e) {
                log.warn("Attempt to fetch cluster state from " + Utils.getBaseUrlForNodeName(nodeName, this.urlScheme) + " failed.", (Throwable)e);
            }
            catch (BaseHttpSolrClient.RemoteSolrException e) {
                if ("NOT_FOUND".equals(e.getMetadata("CLUSTERSTATUS"))) {
                    return null;
                }
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
            }
            catch (NotACollectionException e) {
                this.getAliases(true);
                return null;
            }
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    private ClusterState fetchClusterState(SolrClient client, String collection, Map<String, Object> clusterProperties) throws SolrServerException, IOException, NotACollectionException {
        Map properties;
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (collection != null) {
            params.set("collection", collection);
        }
        params.set("action", "CLUSTERSTATUS");
        QueryRequest request = new QueryRequest(params);
        request.setPath("/admin/collections");
        SimpleOrderedMap cluster = (SimpleOrderedMap)client.request(request).get("cluster");
        Map<String, Object> collectionsMap = collection != null ? Collections.singletonMap(collection, ((NamedList)cluster.get("collections")).get(collection)) : ((NamedList)cluster.get("collections")).asMap(10);
        Map collFromStatus = (Map)collectionsMap.get(collection);
        if (collection != null && collFromStatus == null) {
            throw new NotACollectionException();
        }
        int znodeVersion = collection != null ? (Integer)collFromStatus.get("znodeVersion") : -1;
        HashSet<String> liveNodes = new HashSet<String>((List)cluster.get("live_nodes"));
        this.liveNodes = liveNodes;
        this.liveNodesTimestamp = System.nanoTime();
        ClusterState cs = ClusterState.load((Integer)znodeVersion, collectionsMap, liveNodes, "/clusterstate.json");
        if (clusterProperties != null && (properties = (Map)cluster.get("properties")) != null) {
            clusterProperties.putAll(properties);
        }
        return cs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getLiveNodes() {
        if (this.liveNodes == null) {
            throw new RuntimeException("We don't know of any live_nodes to fetch the latest live_nodes information from. If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        if (TimeUnit.SECONDS.convert(System.nanoTime() - this.liveNodesTimestamp, TimeUnit.NANOSECONDS) <= (long)this.getCacheTimeout()) return this.liveNodes;
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
            try (SolrClient client = this.getSolrClient(baseUrl);){
                Set<String> liveNodes = BaseHttpClusterStateProvider.fetchLiveNodes(client);
                this.liveNodes = liveNodes;
                this.liveNodesTimestamp = System.nanoTime();
                Set<String> set = liveNodes;
                return set;
            }
            catch (Exception e) {
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
            }
        }
        throw new RuntimeException("Tried fetching live_nodes using all the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    private static Set<String> fetchLiveNodes(SolrClient client) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", "CLUSTERSTATUS");
        QueryRequest request = new QueryRequest(params);
        request.setPath("/admin/collections");
        SimpleOrderedMap cluster = (SimpleOrderedMap)client.request(request).get("cluster");
        return new HashSet<String>((List)cluster.get("live_nodes"));
    }

    @Override
    public List<String> resolveAlias(String aliasName) {
        return this.resolveAlias(aliasName, false);
    }

    public List<String> resolveAlias(String aliasName, boolean forceFetch) {
        return Aliases.resolveAliasesGivenAliasMap(this.getAliases(forceFetch), aliasName);
    }

    @Override
    public String resolveSimpleAlias(String aliasName) throws IllegalArgumentException {
        return Aliases.resolveSimpleAliasGivenAliasMap(this.getAliases(false), aliasName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> getAliases(boolean forceFetch) {
        if (this.liveNodes == null) {
            throw new RuntimeException("We don't know of any live_nodes to fetch the latest aliases information from. If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        if (!forceFetch && this.aliases != null) {
            if (TimeUnit.SECONDS.convert(System.nanoTime() - this.aliasesTimestamp, TimeUnit.NANOSECONDS) <= (long)this.getCacheTimeout()) return Collections.unmodifiableMap(this.aliases);
        }
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
            try (SolrClient client = this.getSolrClient(baseUrl);){
                CollectionAdminResponse response = (CollectionAdminResponse)new CollectionAdminRequest.ListAliases().process(client);
                this.aliases = response.getAliasesAsLists();
                this.aliasProperties = response.getAliasProperties();
                this.aliasesTimestamp = System.nanoTime();
                Map<String, List<String>> map = Collections.unmodifiableMap(this.aliases);
                return map;
            }
            catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
                if (e instanceof BaseHttpSolrClient.RemoteSolrException && ((BaseHttpSolrClient.RemoteSolrException)e).code() == 400) {
                    log.warn("LISTALIASES not found, possibly using older Solr server. Aliases won't work unless you re-create the CloudSolrClient using zkHost(s) or upgrade Solr server", (Throwable)e);
                    this.aliases = Collections.emptyMap();
                    this.aliasProperties = Collections.emptyMap();
                    this.aliasesTimestamp = System.nanoTime();
                    return this.aliases;
                }
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
            }
        }
        throw new RuntimeException("Tried fetching aliases using all the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using a working solrUrl or zkHost.");
    }

    @Override
    public Map<String, String> getAliasProperties(String alias) {
        this.getAliases(false);
        return Collections.unmodifiableMap(this.aliasProperties.getOrDefault(alias, Collections.emptyMap()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClusterState getClusterState() throws IOException {
        for (String nodeName : this.liveNodes) {
            String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
            try (SolrClient client = this.getSolrClient(baseUrl);){
                ClusterState clusterState = this.fetchClusterState(client, null, null);
                return clusterState;
            }
            catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
            }
            catch (NotACollectionException e) {
                throw new RuntimeException("null should never cause NotACollectionException in fetchClusterState() Please report this as a bug!");
            }
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> getClusterProperties() {
        for (String nodeName : this.liveNodes) {
            String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.urlScheme);
            try (SolrClient client = this.getSolrClient(baseUrl);){
                HashMap<String, Object> clusterProperties = new HashMap<String, Object>();
                this.fetchClusterState(client, null, clusterProperties);
                HashMap<String, Object> hashMap = clusterProperties;
                return hashMap;
            }
            catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
                log.warn("Attempt to fetch cluster state from {} failed.", (Object)baseUrl, (Object)e);
            }
            catch (NotACollectionException e) {
                throw new RuntimeException("null should never cause NotACollectionException in fetchClusterState() Please report this as a bug!");
            }
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        throw new UnsupportedOperationException("Fetching cluster properties not supported using the HttpClusterStateProvider. ZkClientClusterStateProvider can be used for this.");
    }

    public Object getClusterProperty(String propertyName) {
        if (propertyName.equals("urlScheme")) {
            return this.urlScheme;
        }
        return this.getClusterProperties().get(propertyName);
    }

    @Override
    public void connect() {
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    private class NotACollectionException
    extends Exception {
        private NotACollectionException() {
        }
    }
}

