/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCacheHolder<K, V>
implements SolrCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CacheConfig factory;
    protected volatile SolrCache<K, V> delegate;

    public SolrCacheHolder(SolrCache<K, V> delegate, CacheConfig factory) {
        this.delegate = delegate;
        this.factory = factory;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.delegate.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public void setState(SolrCache.State state) {
        this.delegate.setState(state);
    }

    @Override
    public SolrCache.State getState() {
        return this.delegate.getState();
    }

    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) {
        if (old instanceof SolrCacheHolder) {
            old = ((SolrCacheHolder)old).get();
        }
        this.delegate.warm(searcher, old);
    }

    public SolrCache<K, V> get() {
        return this.delegate;
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public int getMaxSize() {
        return this.delegate.getMaxSize();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.delegate.setMaxSize(maxSize);
    }

    @Override
    public int getMaxRamMB() {
        return this.delegate.getMaxRamMB();
    }

    @Override
    public void setMaxRamMB(int maxRamMB) {
        this.delegate.setMaxRamMB(maxRamMB);
    }

    public void warm(SolrIndexSearcher searcher, SolrCacheHolder src) {
        this.delegate.warm(searcher, src.get());
    }

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        return null;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.delegate.getMetricRegistry();
    }

    @Override
    public Set<String> getMetricNames() {
        return this.delegate.getMetricNames();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return this.delegate.getCategory();
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.delegate.initializeMetrics(parentContext, scope);
    }
}

