/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.JWTIssuerConfig;
import org.apache.solr.security.JWTPrincipal;
import org.apache.solr.security.JWTPrincipalWithUserRoles;
import org.apache.solr.security.JWTVerificationkeyResolver;
import org.eclipse.jetty.client.api.Request;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthPlugin
extends AuthenticationPlugin
implements SpecProvider,
ConfigEditablePlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_BLOCK_UNKNOWN = "blockUnknown";
    private static final String PARAM_REQUIRE_SUBJECT = "requireSub";
    private static final String PARAM_REQUIRE_ISSUER = "requireIss";
    private static final String PARAM_PRINCIPAL_CLAIM = "principalClaim";
    private static final String PARAM_REQUIRE_EXPIRATIONTIME = "requireExp";
    private static final String PARAM_ALG_WHITELIST = "algWhitelist";
    private static final String PARAM_JWK_CACHE_DURATION = "jwkCacheDur";
    private static final String PARAM_CLAIMS_MATCH = "claimsMatch";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_ADMINUI_SCOPE = "adminUiScope";
    private static final String PARAM_REDIRECT_URIS = "redirectUris";
    private static final String PARAM_ISSUERS = "issuers";
    private static final String PARAM_REALM = "realm";
    private static final String DEFAULT_AUTH_REALM = "solr-jwt";
    private static final String CLAIM_SCOPE = "scope";
    private static final long RETRY_INIT_DELAY_SECONDS = 30L;
    private static final long DEFAULT_REFRESH_REPRIEVE_THRESHOLD = 5000L;
    static final String PRIMARY_ISSUER = "PRIMARY";
    private static final Set<String> PROPS = ImmutableSet.of((Object)"blockUnknown", (Object)"requireSub", (Object)"principalClaim", (Object)"requireExp", (Object)"algWhitelist", (Object)"jwkCacheDur", (Object[])new String[]{"claimsMatch", "scope", "realm", "adminUiScope", "redirectUris", "requireIss", "issuers", "jwkUrl", "jwksUrl", "jwk", "iss", "clientId", "wellKnownUrl", "aud", "authorizationEndpoint"});
    private JwtConsumer jwtConsumer;
    private boolean requireExpirationTime;
    private List<String> algWhitelist;
    private String principalClaim;
    private HashMap<String, Pattern> claimsMatchCompiled;
    private boolean blockUnknown;
    private List<String> requiredScopes = new ArrayList<String>();
    private Map<String, Object> pluginConfig;
    private Instant lastInitTime = Instant.now();
    private String adminUiScope;
    private List<String> redirectUris;
    private List<JWTIssuerConfig> issuerConfigs;
    private boolean requireIssuer;
    private JWTVerificationkeyResolver verificationKeyResolver;
    String realm;

    @Override
    public void init(Map<String, Object> pluginConfig) {
        String requiredScopesStr;
        this.pluginConfig = pluginConfig;
        this.issuerConfigs = null;
        List unknownKeys = pluginConfig.keySet().stream().filter(k -> !PROPS.contains(k)).collect(Collectors.toList());
        unknownKeys.remove("class");
        unknownKeys.remove("");
        if (!unknownKeys.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid JwtAuth configuration parameter " + unknownKeys);
        }
        this.blockUnknown = Boolean.parseBoolean(String.valueOf(pluginConfig.getOrDefault(PARAM_BLOCK_UNKNOWN, false)));
        this.requireIssuer = Boolean.parseBoolean(String.valueOf(pluginConfig.getOrDefault(PARAM_REQUIRE_ISSUER, "true")));
        this.requireExpirationTime = Boolean.parseBoolean(String.valueOf(pluginConfig.getOrDefault(PARAM_REQUIRE_EXPIRATIONTIME, "true")));
        if (pluginConfig.get(PARAM_REQUIRE_SUBJECT) != null) {
            log.warn("Parameter {} is no longer used and may generate error in a later version. A subject claim is now always required", (Object)PARAM_REQUIRE_SUBJECT);
        }
        this.principalClaim = (String)pluginConfig.getOrDefault(PARAM_PRINCIPAL_CLAIM, "sub");
        this.algWhitelist = (List)pluginConfig.get(PARAM_ALG_WHITELIST);
        this.realm = (String)pluginConfig.getOrDefault(PARAM_REALM, DEFAULT_AUTH_REALM);
        Map claimsMatch = (Map)pluginConfig.get(PARAM_CLAIMS_MATCH);
        this.claimsMatchCompiled = new HashMap();
        if (claimsMatch != null) {
            for (Map.Entry entry : claimsMatch.entrySet()) {
                this.claimsMatchCompiled.put((String)entry.getKey(), Pattern.compile((String)entry.getValue()));
            }
        }
        if (!StringUtils.isEmpty((String)(requiredScopesStr = (String)pluginConfig.get("scope")))) {
            this.requiredScopes = Arrays.asList(requiredScopesStr.split("\\s+"));
        }
        long jwkCacheDuration = Long.parseLong((String)pluginConfig.getOrDefault(PARAM_JWK_CACHE_DURATION, "3600"));
        JWTIssuerConfig.setHttpsJwksFactory(new JWTIssuerConfig.HttpsJwksFactory(jwkCacheDuration, 5000L));
        this.issuerConfigs = new ArrayList<JWTIssuerConfig>();
        Optional<JWTIssuerConfig> topLevelIssuer = this.parseIssuerFromTopLevelConfig(pluginConfig);
        topLevelIssuer.ifPresent(ic -> {
            this.issuerConfigs.add((JWTIssuerConfig)ic);
            log.warn("JWTAuthPlugin issuer is configured using top-level configuration keys. Please consider using the 'issuers' array instead.");
        });
        this.issuerConfigs.addAll(this.parseIssuers(pluginConfig));
        this.verificationKeyResolver = new JWTVerificationkeyResolver(this.issuerConfigs, this.requireIssuer);
        if (this.issuerConfigs.size() > 0 && this.getPrimaryIssuer().getAuthorizationEndpoint() != null) {
            this.adminUiScope = (String)pluginConfig.get(PARAM_ADMINUI_SCOPE);
            if (this.adminUiScope == null && this.requiredScopes.size() > 0) {
                this.adminUiScope = this.requiredScopes.get(0);
                log.warn("No adminUiScope given, using first scope in 'scope' list as required scope for accessing Admin UI");
            }
            if (this.adminUiScope == null) {
                this.adminUiScope = "solr";
                log.info("No adminUiScope provided, fallback to 'solr' as required scope for Admin UI login may not work");
            }
            Object redirectUrisObj = pluginConfig.get(PARAM_REDIRECT_URIS);
            this.redirectUris = Collections.emptyList();
            if (redirectUrisObj != null) {
                if (redirectUrisObj instanceof String) {
                    this.redirectUris = Collections.singletonList((String)redirectUrisObj);
                } else if (redirectUrisObj instanceof List) {
                    this.redirectUris = (List)redirectUrisObj;
                }
            }
        }
        this.initConsumer();
        this.lastInitTime = Instant.now();
    }

    private Optional<JWTIssuerConfig> parseIssuerFromTopLevelConfig(Map<String, Object> conf) {
        try {
            if (conf.get("jwkUrl") != null) {
                log.warn("Configuration uses deprecated key {}. Please use {} instead", (Object)"jwkUrl", (Object)"jwksUrl");
            }
            JWTIssuerConfig primary = new JWTIssuerConfig(PRIMARY_ISSUER).setIss((String)conf.get("iss")).setAud((String)conf.get("aud")).setJwksUrl(conf.get("jwksUrl") != null ? conf.get("jwksUrl") : conf.get("jwkUrl")).setAuthorizationEndpoint((String)conf.get("authorizationEndpoint")).setClientId((String)conf.get("clientId")).setWellKnownUrl((String)conf.get("wellKnownUrl"));
            if (conf.get("jwk") != null) {
                primary.setJsonWebKeySet(JWTIssuerConfig.parseJwkSet((Map)conf.get("jwk")));
            }
            if (primary.isValid()) {
                log.debug("Found issuer in top level config");
                primary.init();
                return Optional.of(primary);
            }
            log.debug("No issuer configured in top level config");
            return Optional.empty();
        }
        catch (JoseException je) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed parsing issuer from top level config", (Throwable)je);
        }
    }

    JWTIssuerConfig getPrimaryIssuer() {
        if (this.issuerConfigs.size() == 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No issuers configured");
        }
        return this.issuerConfigs.get(0);
    }

    List<JWTIssuerConfig> parseIssuers(Map<String, Object> pluginConfig) {
        ArrayList<JWTIssuerConfig> configs = new ArrayList<JWTIssuerConfig>();
        try {
            List issuers = (List)pluginConfig.get(PARAM_ISSUERS);
            if (issuers != null) {
                issuers.forEach(issuerConf -> {
                    JWTIssuerConfig ic = new JWTIssuerConfig((Map<String, Object>)issuerConf);
                    ic.init();
                    configs.add(ic);
                    log.debug("Found issuer with name {} and issuerId {}", (Object)ic.getName(), (Object)ic.getIss());
                });
            }
            return configs;
        }
        catch (ClassCastException cce) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parameter issuers has wrong format.", (Throwable)cce);
        }
    }

    @Override
    public boolean doAuthenticate(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws Exception {
        Optional<JWTIssuerConfig> issuerConfig;
        String issuer;
        JWTAuthenticationResponse authResponse;
        String exceptionMessage;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String header = request.getHeader("Authorization");
        if (this.jwtConsumer == null) {
            if (header == null && !this.blockUnknown) {
                log.info("JWTAuth not configured, but allowing anonymous access since {}==false", (Object)PARAM_BLOCK_UNKNOWN);
                this.numPassThrough.inc();
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            if (this.lastInitTime.plusSeconds(30L).isAfter(Instant.now())) {
                log.info("Retrying JWTAuthPlugin initialization (retry delay={}s)", (Object)30L);
                this.init(this.pluginConfig);
            }
            if (this.jwtConsumer == null) {
                log.warn("JWTAuth not configured");
                this.numErrors.mark();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuth plugin not correctly configured");
            }
        }
        String string = exceptionMessage = (authResponse = this.authenticate(header)).getJwtException() != null ? authResponse.getJwtException().getMessage() : "";
        if (JWTAuthenticationResponse.AuthCode.SIGNATURE_INVALID.equals((Object)authResponse.getAuthCode()) && (issuer = this.jwtConsumer.processToClaims(header).getIssuer()) != null && (issuerConfig = this.issuerConfigs.stream().filter(ic -> issuer.equals(ic.getIss())).findFirst()).isPresent() && issuerConfig.get().usesHttpsJwk()) {
            log.info("Signature validation failed for issuer {}. Refreshing JWKs from IdP before trying again: {}", (Object)issuer, (Object)exceptionMessage);
            for (HttpsJwks httpsJwks : issuerConfig.get().getHttpsJwks()) {
                httpsJwks.refresh();
            }
            authResponse = this.authenticate(header);
            exceptionMessage = authResponse.getJwtException() != null ? authResponse.getJwtException().getMessage() : "";
        }
        switch (authResponse.getAuthCode()) {
            case AUTHENTICATED: {
                final Principal principal = authResponse.getPrincipal();
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

                    public Principal getUserPrincipal() {
                        return principal;
                    }
                };
                if (!(principal instanceof JWTPrincipal)) {
                    this.numErrors.mark();
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuth plugin says AUTHENTICATED but no token extracted");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Authentication SUCCESS");
                }
                this.numAuthenticated.inc();
                filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                return true;
            }
            case PASS_THROUGH: {
                if (log.isDebugEnabled()) {
                    log.debug("Unknown user, but allow due to {}=false", (Object)PARAM_BLOCK_UNKNOWN);
                }
                this.numPassThrough.inc();
                request.setAttribute(AuthenticationPlugin.class.getName(), this.getPromptHeaders(null, null));
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            case AUTZ_HEADER_PROBLEM: 
            case JWT_PARSE_ERROR: {
                log.warn("Authentication failed. {}, {}", (Object)authResponse.getAuthCode(), (Object)authResponse.getAuthCode().getMsg());
                this.numErrors.mark();
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 400, BearerWwwAuthErrorCode.invalid_request);
                return false;
            }
            case CLAIM_MISMATCH: 
            case JWT_EXPIRED: 
            case JWT_VALIDATION_EXCEPTION: 
            case PRINCIPAL_MISSING: {
                log.warn("Authentication failed. {}, {}", (Object)authResponse.getAuthCode(), (Object)exceptionMessage);
                this.numWrongCredentials.inc();
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, BearerWwwAuthErrorCode.invalid_token);
                return false;
            }
            case SIGNATURE_INVALID: {
                log.warn("Signature validation failed: {}", (Object)exceptionMessage);
                this.numWrongCredentials.inc();
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, BearerWwwAuthErrorCode.invalid_token);
                return false;
            }
            case SCOPE_MISSING: {
                this.numWrongCredentials.inc();
                this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, BearerWwwAuthErrorCode.insufficient_scope);
                return false;
            }
        }
        this.numMissingCredentials.inc();
        this.authenticationFailure(response, authResponse.getAuthCode().getMsg(), 401, null);
        return false;
    }

    protected JWTAuthenticationResponse authenticate(String authorizationHeader) {
        if (authorizationHeader != null) {
            String jwtCompact = this.parseAuthorizationHeader(authorizationHeader);
            if (jwtCompact != null) {
                try {
                    try {
                        JwtClaims jwtClaims = this.jwtConsumer.processToClaims(jwtCompact);
                        String principal = jwtClaims.getStringClaimValue(this.principalClaim);
                        if (principal == null || principal.isEmpty()) {
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.PRINCIPAL_MISSING, "Cannot identify principal from JWT. Required claim " + this.principalClaim + " missing. Cannot authenticate");
                        }
                        if (this.claimsMatchCompiled != null) {
                            for (Map.Entry<String, Pattern> entry : this.claimsMatchCompiled.entrySet()) {
                                String claim = entry.getKey();
                                if (jwtClaims.hasClaim(claim)) {
                                    if (entry.getValue().matcher(jwtClaims.getStringClaimValue(claim)).matches()) continue;
                                    return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.CLAIM_MISMATCH, "Claim " + claim + "=" + jwtClaims.getStringClaimValue(claim) + " does not match required regular expression " + entry.getValue().pattern());
                                }
                                return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.CLAIM_MISMATCH, "Claim " + claim + " is required but does not exist in JWT");
                            }
                        }
                        if (!this.requiredScopes.isEmpty() && !jwtClaims.hasClaim("scope")) {
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.CLAIM_MISMATCH, "Claim scope is required but does not exist in JWT");
                        }
                        Set scopes = Collections.emptySet();
                        Object scopesObj = jwtClaims.getClaimValue("scope");
                        if (scopesObj != null) {
                            if (scopesObj instanceof String) {
                                scopes = new HashSet<String>(Arrays.asList(((String)scopesObj).split("\\s+")));
                            } else if (scopesObj instanceof List) {
                                scopes = new HashSet(jwtClaims.getStringListClaimValue("scope"));
                            }
                            if (!this.requiredScopes.isEmpty()) {
                                if (scopes.stream().noneMatch(this.requiredScopes::contains)) {
                                    return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.SCOPE_MISSING, "Claim scope does not contain any of the required scopes: " + this.requiredScopes);
                                }
                            }
                            HashSet<String> finalScopes = new HashSet<String>(scopes);
                            finalScopes.remove("openid");
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTHENTICATED, new JWTPrincipalWithUserRoles(principal, jwtCompact, jwtClaims.getClaimsMap(), finalScopes));
                        }
                        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTHENTICATED, new JWTPrincipal(principal, jwtCompact, jwtClaims.getClaimsMap()));
                    }
                    catch (InvalidJwtSignatureException ise) {
                        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.SIGNATURE_INVALID, (InvalidJwtException)((Object)ise));
                    }
                    catch (InvalidJwtException e) {
                        if (e.hasExpired()) {
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_EXPIRED, "Authentication failed due to expired JWT token. Expired at " + e.getJwtContext().getJwtClaims().getExpirationTime());
                        }
                        if (e.getCause() != null && e.getCause() instanceof JoseException && e.getCause().getMessage().contains("Invalid JOSE Compact Serialization")) {
                            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_PARSE_ERROR, e.getCause().getMessage());
                        }
                        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_VALIDATION_EXCEPTION, e);
                    }
                }
                catch (MalformedClaimException e) {
                    return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.JWT_PARSE_ERROR, "Malformed claim, error was: " + e.getMessage());
                }
            }
            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.AUTZ_HEADER_PROBLEM, "Authorization header is not in correct format");
        }
        if (this.blockUnknown) {
            return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.NO_AUTZ_HEADER, "Missing Authorization header");
        }
        log.debug("No user authenticated, but blockUnknown=false, so letting request through");
        return new JWTAuthenticationResponse(JWTAuthenticationResponse.AuthCode.PASS_THROUGH);
    }

    private String parseAuthorizationHeader(String authorizationHeader) {
        String bearer;
        StringTokenizer st = new StringTokenizer(authorizationHeader);
        if (st.hasMoreTokens() && (bearer = st.nextToken()).equalsIgnoreCase("Bearer") && st.hasMoreTokens()) {
            return st.nextToken();
        }
        return null;
    }

    private void initConsumer() {
        String[] audiences;
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setAllowedClockSkewInSeconds(30);
        String[] issuers = (String[])this.issuerConfigs.stream().map(JWTIssuerConfig::getIss).filter(Objects::nonNull).toArray(String[]::new);
        if (issuers.length > 0) {
            jwtConsumerBuilder.setExpectedIssuers(this.requireIssuer, issuers);
        }
        if ((audiences = (String[])this.issuerConfigs.stream().map(JWTIssuerConfig::getAud).filter(Objects::nonNull).toArray(String[]::new)).length > 0) {
            jwtConsumerBuilder.setExpectedAudience(audiences);
        } else {
            jwtConsumerBuilder.setSkipDefaultAudienceValidation();
        }
        jwtConsumerBuilder.setRequireSubject();
        if (this.requireExpirationTime) {
            jwtConsumerBuilder.setRequireExpirationTime();
        }
        if (this.algWhitelist != null) {
            jwtConsumerBuilder.setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, this.algWhitelist.toArray(new String[0])));
        }
        jwtConsumerBuilder.setVerificationKeyResolver((VerificationKeyResolver)this.verificationKeyResolver);
        this.jwtConsumer = jwtConsumerBuilder.build();
    }

    @Override
    public void close() throws IOException {
        this.jwtConsumer = null;
    }

    public ValidatingJsonMap getSpec() {
        return Utils.getSpec((String)"cluster.security.JwtAuth.Commands").getSpec();
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation command : commands) {
            if (!command.name.equals("set-property")) continue;
            for (Map.Entry e : command.getDataMap().entrySet()) {
                if (PROPS.contains(e.getKey())) {
                    latestConf.put((String)e.getKey(), e.getValue());
                    return latestConf;
                }
                command.addError("Unknown property " + (String)e.getKey());
            }
        }
        if (!CommandOperation.captureErrors(commands).isEmpty()) {
            return null;
        }
        return latestConf;
    }

    private void authenticationFailure(HttpServletResponse response, String message, int httpCode, BearerWwwAuthErrorCode responseError) throws IOException {
        this.getPromptHeaders(responseError, message).forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        response.sendError(httpCode, message);
        log.info("JWT Authentication attempt failed: {}", (Object)message);
    }

    private Map<String, String> getPromptHeaders(BearerWwwAuthErrorCode responseError, String message) {
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<String> wwwAuthParams = new ArrayList<String>();
        wwwAuthParams.add("Bearer realm=\"" + this.realm + "\"");
        if (responseError != null) {
            wwwAuthParams.add("error=\"" + (Object)((Object)responseError) + "\"");
            wwwAuthParams.add("error_description=\"" + message + "\"");
        }
        headers.put("WWW-Authenticate", String.join((CharSequence)", ", wwwAuthParams));
        headers.put("X-Solr-AuthData", this.generateAuthDataHeader());
        return headers;
    }

    protected String generateAuthDataHeader() {
        JWTIssuerConfig primaryIssuer = this.getPrimaryIssuer();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("authorizationEndpoint", primaryIssuer.getAuthorizationEndpoint());
        data.put("client_id", primaryIssuer.getClientId());
        data.put("scope", this.adminUiScope);
        data.put("redirect_uris", this.redirectUris);
        String headerJson = Utils.toJSONString(data);
        return Base64.byteArrayToBase64((byte[])headerJson.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        HttpClientContext httpClientContext;
        if (httpContext instanceof HttpClientContext && (httpClientContext = (HttpClientContext)httpContext).getUserToken() instanceof JWTPrincipal) {
            JWTPrincipal jwtPrincipal = (JWTPrincipal)httpClientContext.getUserToken();
            httpRequest.setHeader("Authorization", "Bearer " + jwtPrincipal.getToken());
            return true;
        }
        return false;
    }

    @Override
    protected boolean interceptInternodeRequest(Request request) {
        Object userToken = request.getAttributes().get("solr-req-principal");
        if (userToken instanceof JWTPrincipal) {
            JWTPrincipal jwtPrincipal = (JWTPrincipal)userToken;
            request.header("Authorization", "Bearer " + jwtPrincipal.getToken());
            return true;
        }
        return false;
    }

    public List<JWTIssuerConfig> getIssuerConfigs() {
        return this.issuerConfigs;
    }

    public JWTIssuerConfig getIssuerConfigByName(String name) {
        return this.issuerConfigs.stream().filter(ic -> name.equals(ic.getName())).findAny().orElse(null);
    }

    static class JWTAuthenticationResponse {
        private final Principal principal;
        private String errorMessage;
        private AuthCode authCode;
        private InvalidJwtException jwtException;

        JWTAuthenticationResponse(AuthCode authCode, InvalidJwtException e) {
            this.authCode = authCode;
            this.jwtException = e;
            this.principal = null;
            this.errorMessage = e.getMessage();
        }

        JWTAuthenticationResponse(AuthCode authCode, String errorMessage) {
            this.authCode = authCode;
            this.errorMessage = errorMessage;
            this.principal = null;
        }

        JWTAuthenticationResponse(AuthCode authCode, Principal principal) {
            this.authCode = authCode;
            this.principal = principal;
        }

        JWTAuthenticationResponse(AuthCode authCode) {
            this.authCode = authCode;
            this.principal = null;
        }

        boolean isAuthenticated() {
            return this.authCode.equals((Object)AuthCode.AUTHENTICATED);
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        InvalidJwtException getJwtException() {
            return this.jwtException;
        }

        AuthCode getAuthCode() {
            return this.authCode;
        }

        static enum AuthCode {
            PASS_THROUGH("No user, pass through"),
            AUTHENTICATED("Authenticated"),
            PRINCIPAL_MISSING("No principal in JWT"),
            JWT_PARSE_ERROR("Invalid JWT"),
            AUTZ_HEADER_PROBLEM("Wrong header"),
            NO_AUTZ_HEADER("Require authentication"),
            JWT_EXPIRED("JWT token expired"),
            CLAIM_MISMATCH("Required JWT claim missing"),
            JWT_VALIDATION_EXCEPTION("JWT validation failed"),
            SCOPE_MISSING("Required scope missing in JWT"),
            SIGNATURE_INVALID("Signature invalid");

            private final String msg;

            public String getMsg() {
                return this.msg;
            }

            private AuthCode(String msg) {
                this.msg = msg;
            }
        }
    }

    private static enum BearerWwwAuthErrorCode {
        invalid_request,
        invalid_token,
        insufficient_scope;

    }
}

