/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.cloud.autoscaling.sim.LiveNodesSet;
import org.apache.solr.cloud.autoscaling.sim.SimClusterStateProvider;
import org.apache.solr.cloud.autoscaling.sim.SimDistribStateManager;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimNodeStateProvider
implements NodeStateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Map<String, Object>> nodeValues = new ConcurrentHashMap<String, Map<String, Object>>();
    private final SimClusterStateProvider clusterStateProvider;
    private final SimDistribStateManager stateManager;
    private final LiveNodesSet liveNodesSet;
    private final ReentrantLock lock = new ReentrantLock();
    private static final Pattern REGISTRY_PATTERN = Pattern.compile("^solr\\.core\\.([\\w.-_]+?)\\.(shard[\\d_]+?)\\.(replica.*)");
    private static final Pattern METRIC_KEY_PATTERN = Pattern.compile("^metrics:([^:]+?):([^:]+?)(:([^:]+))?$");

    public SimNodeStateProvider(LiveNodesSet liveNodesSet, SimDistribStateManager stateManager, SimClusterStateProvider clusterStateProvider, Map<String, Map<String, Object>> nodeValues) {
        this.liveNodesSet = liveNodesSet;
        this.stateManager = stateManager;
        this.clusterStateProvider = clusterStateProvider;
        if (nodeValues != null) {
            this.nodeValues.putAll(nodeValues);
        }
    }

    public Object simGetNodeValue(String node, String key) {
        Map<String, Object> values = this.nodeValues.get(node);
        if (values == null) {
            return null;
        }
        return values.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object simUpdateNodeValue(String node, String key, Function<Object, Object> updater) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Map values = this.nodeValues.computeIfAbsent(node, n -> new ConcurrentHashMap());
            Object object = values.put(key, updater.apply(values.get(key)));
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSetNodeValues(String node, Map<String, Object> values) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Map existing = this.nodeValues.computeIfAbsent(node, n -> new ConcurrentHashMap());
            existing.clear();
            if (values != null) {
                existing.putAll(values);
            }
            if (values == null || values.isEmpty() || values.containsKey("nodeRole")) {
                this.saveRoles();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSetNodeValue(String node, String key, Object value) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Map existing = this.nodeValues.computeIfAbsent(node, n -> new ConcurrentHashMap());
            if (value == null) {
                existing.remove(key);
            } else {
                existing.put(key, value);
            }
            if (key.equals("nodeRole")) {
                this.saveRoles();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simAddNodeValue(String node, String key, Object value) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Map values = this.nodeValues.computeIfAbsent(node, n -> new ConcurrentHashMap());
            Object existing = values.get(key);
            if (existing == null) {
                values.put(key, value);
            } else if (existing instanceof Set) {
                ((Set)existing).add(value);
            } else {
                HashSet<Object> vals = new HashSet<Object>();
                vals.add(existing);
                vals.add(value);
                values.put(key, vals);
            }
            if (key.equals("nodeRole")) {
                this.saveRoles();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simRemoveNodeValues(String node) throws InterruptedException {
        log.debug("--removing value for " + node);
        this.lock.lockInterruptibly();
        try {
            Map<String, Object> values = this.nodeValues.remove(node);
            if (values != null && values.containsKey("nodeRole")) {
                this.saveRoles();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simRemoveDeadNodes() throws InterruptedException {
        HashSet<String> myNodes = new HashSet<String>(this.nodeValues.keySet());
        myNodes.removeAll(this.liveNodesSet.get());
        this.lock.lockInterruptibly();
        try {
            AtomicBoolean updateRoles = new AtomicBoolean(false);
            myNodes.forEach(n -> {
                log.debug("- removing dead node values: " + n);
                Map<String, Object> vals = this.nodeValues.remove(n);
                if (vals.containsKey("nodeRole")) {
                    updateRoles.set(true);
                }
            });
            if (updateRoles.get()) {
                this.saveRoles();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> simGetDeadNodes() {
        TreeSet<String> myNodes = new TreeSet<String>(this.nodeValues.keySet());
        myNodes.removeAll(this.liveNodesSet.get());
        return myNodes;
    }

    public Map<String, Map<String, Object>> simGetAllNodeValues() {
        return this.nodeValues;
    }

    private void saveRoles() {
        HashMap roles = new HashMap();
        this.nodeValues.forEach((n, values) -> {
            String nodeRole = (String)values.get("nodeRole");
            if (nodeRole != null) {
                roles.computeIfAbsent(nodeRole, role -> new HashSet()).add(n);
            }
        });
        try {
            this.stateManager.setData("/roles.json", Utils.toJSON(roles), -1);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception saving roles " + roles, e);
        }
    }

    public Map<String, Object> getReplicaMetricsValues(String node, Collection<String> tags) {
        if (!this.liveNodesSet.contains(node)) {
            throw new RuntimeException("non-live node " + node);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String tag : tags) {
            String key;
            Matcher m = METRIC_KEY_PATTERN.matcher(tag);
            if (!m.matches() || m.groupCount() < 2) {
                log.warn("Invalid metrics: tag: " + tag);
                continue;
            }
            String registryName = m.group(1);
            String string = key = m.group(3) != null ? m.group(2) + m.group(3) : m.group(2);
            if (!registryName.startsWith("solr.core.")) continue;
            m = REGISTRY_PATTERN.matcher(registryName);
            if (!m.matches()) {
                log.warn("Invalid registry name: " + registryName);
                continue;
            }
            String collection = m.group(1);
            String shard = m.group(2);
            String replica = m.group(3);
            List<ReplicaInfo> replicas = this.clusterStateProvider.simGetReplicaInfos(collection, shard);
            replicas.forEach(r -> {
                if (r.getNode().equals(node) && r.getCore().endsWith(replica)) {
                    Object value = r.getVariables().get(key);
                    if (value != null) {
                        values.put(tag, value);
                    } else {
                        value = r.getVariables().get(tag);
                        if (value != null) {
                            values.put(tag, value);
                        }
                    }
                }
            });
        }
        return values;
    }

    public Map<String, Object> getNodeValues(String node, Collection<String> tags) {
        log.trace("-- requested values for " + node + ": " + tags);
        if (!this.liveNodesSet.contains(node)) {
            throw new RuntimeException("non-live node " + node);
        }
        if (tags.isEmpty()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> metrics = this.getReplicaMetricsValues(node, tags.stream().filter(s -> s.startsWith("metrics:solr.core.")).collect(Collectors.toList()));
        HashMap<String, Object> result = new HashMap<String, Object>(metrics);
        Map<String, Object> values = this.nodeValues.get(node);
        if (values == null) {
            return result;
        }
        result.putAll(values.entrySet().stream().filter(e -> tags.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue())));
        return result;
    }

    public Map<String, Map<String, List<ReplicaInfo>>> getReplicaInfo(String node, Collection<String> keys) {
        List<ReplicaInfo> replicas = this.clusterStateProvider.simGetReplicaInfos(node);
        if (replicas == null || replicas.isEmpty()) {
            return new HashMap<String, Map<String, List<ReplicaInfo>>>();
        }
        HashMap<String, Map<String, List<ReplicaInfo>>> res = new HashMap<String, Map<String, List<ReplicaInfo>>>();
        for (ReplicaInfo r : replicas) {
            Map<String, List<ReplicaInfo>> perCollection = res.computeIfAbsent(r.getCollection(), Utils.NEW_HASHMAP_FUN);
            List<ReplicaInfo> perShard = perCollection.computeIfAbsent(r.getShard(), Utils.NEW_ARRAYLIST_FUN);
            perShard.add(r);
        }
        return res;
    }

    public void close() throws IOException {
    }
}

